/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Color
implements Iterable<Integer> {
    public static final int HALF_BLACK = -2013265920;
    public static final Color WHITE = new Color(0xFFFFFF, new int[0], 0xF7F7F7, 0xEFEFEF, 0xE7E7E7, 0xDFDFDF, 0xD7D7D7, 0xCFCFCF, 0xC7C7C7, 0xBFBFBF);
    public static final Color BLACK = new Color(0, new int[]{526344, 0x101010, 0x181818, 0x202020, 0x282828, 0x303030, 0x383838, 0x404040}, new int[0]);
    public static final Color RED = new Color(16007990, new int[]{15684432, 15037299, 15702682, 16764370, 0xFFEBEE}, 15022389, 13840175, 12986408, 12000284);
    public static final Color RED_ACCENT = new Color(0xFF5252, new int[]{16747136}, 16717636, 0xD50000);
    public static final Color PINK = new Color(15277667, new int[]{15483002, 15753874, 16027569, 16301008, 16573676}, 14162784, 12720219, 11342935, 8916559);
    public static final Color PINK_ACCENT = new Color(16728193, new int[]{16744619}, 16056407, 12915042);
    public static final Color PURPLE = new Color(10233776, new int[]{11225020, 12216520, 13538264, 14794471, 15984117}, 9315498, 8069026, 6953882, 4854924);
    public static final Color PURPLE_ACCENT = new Color(14696699, new int[]{15368444}, 13959417, 0xAA00FF);
    public static final Color DEEP_PURPLE = new Color(6765239, new int[]{8280002, 9795021, 11771355, 13747433, 15591414}, 6174129, 5320104, 4532128, 3218322);
    public static final Color DEEP_PURPLE_ACCENT = new Color(8146431, new int[]{11766015}, 6627327, 6627327);
    public static final Color INDIGO = new Color(4149685, new int[]{6056896, 7964363, 10463450, 12962537, 15264502}, 3754411, 3162015, 2635155, 1713022);
    public static final Color INDIGO_ACCENT = new Color(5467646, new int[]{9215743}, 4020990, 3166206);
    public static final Color BLUE = new Color(2201331, new int[]{4367861, 6600182, 9489145, 12312315, 14938877}, 2001125, 1668818, 1402304, 870305);
    public static final Color BLUE_ACCENT = new Color(4492031, new int[]{8565247}, 2718207, 2712319);
    public static final Color LIGHT_BLUE = new Color(240116, new int[]{2733814, 5227511, 8508666, 11789820, 14808574}, 236517, 166097, 161725, 87963);
    public static final Color LIGHT_BLUE_ACCENT = new Color(4244735, new int[]{8444159}, 45311, 37354);
    public static final Color CYAN = new Color(48340, new int[]{2541274, 5099745, 8445674, 11725810, 14743546}, 44225, 38823, 33679, 24676);
    public static final Color CYAN_ACCENT = new Color(0x18FFFF, new int[]{0x84FFFF}, 58879, 47316);
    public static final Color TEAL = new Color(38536, new int[]{2533018, 5093036, 8440772, 11722715, 14742257}, 35195, 31083, 26972, 19776);
    public static final Color TEAL_ACCENT = new Color(6619098, new int[]{11010027}, 1960374, 49061);
    public static final Color GREEN = new Color(5025616, new int[]{0x66BB6A, 8505220, 10868391, 13166281, 15267305}, 4431943, 3706428, 3046706, 1793568);
    public static final Color GREEN_ACCENT = new Color(6942894, new int[]{12187338}, 58998, 51283);
    public static final Color LIGHT_GREEN = new Color(9159498, new int[]{10275941, 11457921, 12968357, 14478792, 15857897}, 8172354, 6856504, 5606191, 3369246);
    public static final Color LIGHT_GREEN_ACCENT = new Color(11730777, new int[]{13434768}, 7798531, 6610199);
    public static final Color LIME = new Color(13491257, new int[]{13951319, 14477173, 15134364, 15791299, 16382951}, 12634675, 11514923, 10394916, 8550167);
    public static final Color LIME_ACCENT = new Color(15662913, new int[]{16056193}, 13041408, 0xAEEA00);
    public static final Color YELLOW = new Color(16771899, new int[]{16772696, 16773494, 16774557, 16775620, 16776679}, 16635957, 16498733, 16361509, 16088855);
    public static final Color YELLOW_ACCENT = new Color(0xFFFF00, new int[]{0xFFFF8D}, 16771584, 16766464);
    public static final Color AMBER = new Color(16761095, new int[]{16763432, 16766287, 16769154, 16772275, 16775393}, 16757504, 0xFFA000, 0xFF8F00, 0xFF6F00);
    public static final Color AMBER_ACCENT = new Color(16766784, new int[]{16770431}, 16761856, 16755456);
    public static final Color ORANGE = new Color(16750592, new int[]{16754470, 16758605, 16764032, 16769202, -3104}, 16485376, 16088064, 15690752, 15094016);
    public static final Color ORANGE_ACCENT = new Color(16755520, new int[]{16765312}, 16748800, 16739584);
    public static final Color DEEP_ORANGE = new Color(16733986, new int[]{16740419, 16747109, 16755601, 0xFFCCBC, 16509415}, 16011550, 15092249, 14172949, 12531212);
    public static final Color DEEP_ORANGE_ACCENT = new Color(16739904, new int[]{16752256}, 16727296, 14494720);
    public static final Color BROWN = new Color(7951688, new int[]{9268835, 10586239, 12364452, 14142664, 15723497}, 7162945, 6111287, 5125166, 4073251);
    public static final Color GREY = new Color(0x9E9E9E, new int[]{0xBDBDBD, 0xE0E0E0, 0xEEEEEE, 0xF5F5F5, 0xFAFAFA}, 0x757575, 0x616161, 0x424242, 0x212121);
    public static final Color BLUE_GREY = new Color(6323595, new int[]{7901340, 9479342, 11583173, 13621468, 15527921}, 5533306, 4545124, 3622735, 2503224);
    public final int normal;
    private final int[] shadeBright;
    private final int[] shadeDark;
    private final int[] all;

    public static int rgb(int red, int green, int blue) {
        return Color.argb(red, green, blue, 255);
    }

    public static int argb(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int argb(float red, float green, float blue, float alpha) {
        return Color.argb((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static int rgba(int red, int green, int blue, int alpha) {
        return (red & 0xFF) << 24 | (green & 0xFF) << 16 | (blue & 0xFF) << 8 | alpha & 0xFF;
    }

    public static int rgba(float red, float green, float blue, float alpha) {
        return Color.rgba((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static int rgb(float red, float green, float blue) {
        return Color.argb(red, green, blue, 1.0f);
    }

    public static int ofHSV(int hue, float saturation, float value, float alpha) {
        float b;
        float g;
        float r;
        hue = Math.max(0, Math.min(hue, 360));
        float c = value * saturation;
        float x = c * (1.0f - ((float)hue / 60.0f % 2.0f - 1.0f));
        x = Math.max(x, -x);
        float m = value - c;
        if (hue < 60) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (hue < 120) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (hue < 180) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (hue < 240) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (hue < 300) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return Color.argb(r + m, g + m, b + m, alpha);
    }

    public static int withRed(int argb, int red) {
        return (argb &= 0xFF00FFFF) | red << 16;
    }

    public static int withGreen(int argb, int green) {
        return (argb &= 0xFFFF00FF) | green << 8;
    }

    public static int withBlue(int argb, int blue) {
        return (argb &= 0xFFFFFF00) | blue;
    }

    public static int withAlpha(int argb, int alpha) {
        return (argb &= 0xFFFFFF) | alpha << 24;
    }

    public static int withRed(int argb, float red) {
        return Color.withRed(argb, (int)(red * 255.0f));
    }

    public static int withGreen(int argb, float green) {
        return Color.withGreen(argb, (int)(green * 255.0f));
    }

    public static int withBlue(int argb, float blue) {
        return Color.withBlue(argb, (int)(blue * 255.0f));
    }

    public static int withAlpha(int argb, float alpha) {
        return Color.withAlpha(argb, (int)(alpha * 255.0f));
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static float getRedF(int argb) {
        return (float)Color.getRed(argb) / 255.0f;
    }

    public static float getGreenF(int argb) {
        return (float)Color.getGreen(argb) / 255.0f;
    }

    public static float getBlueF(int argb) {
        return (float)Color.getBlue(argb) / 255.0f;
    }

    public static float getAlphaF(int argb) {
        return (float)Color.getAlpha(argb) / 255.0f;
    }

    public static int[] getValues(int argb) {
        return new int[]{Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb), Color.getAlpha(argb)};
    }

    public static int rgbaToArgb(int rgba) {
        return Color.argb(Color.getAlpha(rgba), Color.getRed(rgba), Color.getGreen(rgba), Color.getBlue(rgba));
    }

    public static int argbToRgba(int argb) {
        return Color.rgba(Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb), Color.getAlpha(argb));
    }

    public static int invert(int argb) {
        return Color.argb(255 - Color.getRed(argb), 255 - Color.getGreen(argb), 255 - Color.getBlue(argb), Color.getAlpha(argb));
    }

    public static int multiply(int argb, float factor, boolean multiplyAlpha) {
        return Color.argb(Color.getRedF(argb) * factor, Color.getGreenF(argb) * factor, Color.getBlueF(argb) * factor, multiplyAlpha ? Color.getAlphaF(argb) * factor : Color.getAlphaF(argb));
    }

    public static int average(int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int color : colors) {
            r += Color.getRed(color);
            g += Color.getGreen(color);
            b += Color.getBlue(color);
            a += Color.getAlpha(color);
        }
        return Color.argb(r / colors.length, g / colors.length, b / colors.length, a / colors.length);
    }

    public static int interpolate(int color1, int color2, double value) {
        value = MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
        int r = (int)((double)(Color.getRed(color2) - Color.getRed(color1)) * value + (double)Color.getRed(color1));
        int g = (int)((double)(Color.getGreen(color2) - Color.getGreen(color1)) * value + (double)Color.getGreen(color1));
        int b = (int)((double)(Color.getBlue(color2) - Color.getBlue(color1)) * value + (double)Color.getBlue(color1));
        int a = (int)((double)(Color.getAlpha(color2) - Color.getAlpha(color1)) * value + (double)Color.getAlpha(color1));
        return Color.argb(r, g, b, a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setGlColor(int color) {
        if (color == 0) {
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            return;
        }
        float a = Color.getAlphaF(color);
        if (a == 0.0f) {
            a = 1.0f;
        }
        GlStateManager.func_179131_c((float)Color.getRedF(color), (float)Color.getGreenF(color), (float)Color.getBlueF(color), (float)a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setGlColorOpaque(int color) {
        if (color == 0) {
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            return;
        }
        GlStateManager.func_179131_c((float)Color.getRedF(color), (float)Color.getGreenF(color), (float)Color.getBlueF(color), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetGlColor() {
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Color.setGlColorOpaque(Color.WHITE.normal);
    }

    @Nullable
    public static Integer ofJson(JsonElement jsonElement) {
        int color;
        if (jsonElement.isJsonPrimitive() && (color = (int)Long.decode(jsonElement.getAsString()).longValue()) != 0 && Color.getAlpha(color) == 0) {
            return Color.withAlpha(color, 255);
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            int red = JsonHelper.getInt(json, 255, "r", "red");
            int green = JsonHelper.getInt(json, 255, "g", "green");
            int blue = JsonHelper.getInt(json, 255, "b", "blue");
            int alpha = JsonHelper.getInt(json, 255, "a", "alpha");
            if ((red | green | blue) != 0 && alpha == 0) {
                alpha = 255;
            }
            return Color.argb(red, green, blue, alpha);
        }
        return null;
    }

    public Color(int normal, int[] shadeBright, int ... shadeDark) {
        int i;
        this.normal = Color.withAlpha(normal, 255);
        this.shadeBright = shadeBright;
        this.shadeDark = shadeDark;
        for (i = 0; i < this.shadeBright.length; ++i) {
            this.shadeBright[i] = Color.withAlpha(this.shadeBright[i], 255);
        }
        for (i = 0; i < this.shadeDark.length; ++i) {
            this.shadeDark[i] = Color.withAlpha(this.shadeDark[i], 255);
        }
        this.all = new int[shadeBright.length + shadeDark.length + 1];
        int index = 0;
        for (int i2 = shadeBright.length - 1; i2 >= 0; --i2) {
            this.all[index++] = shadeBright[i2];
        }
        this.all[index++] = normal;
        for (int shade : shadeDark) {
            this.all[index++] = shade;
        }
    }

    public int bright(int index) {
        return this.shadeBright[index];
    }

    public int dark(int index) {
        return this.shadeDark[index];
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return Arrays.stream(this.all).iterator();
    }
}

