/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.ScrollData;
import com.cleanroommc.modularui.utils.ScrollDirection;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScrollArea
extends Area {
    private ScrollData scrollX;
    private ScrollData scrollY;
    private int scrollBarBackgroundColor;

    public ScrollArea(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.normal, 0.25f);
    }

    public ScrollArea() {
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.normal, 0.25f);
    }

    public void setScrollData(ScrollData data) {
        if (data != null) {
            if (data.direction == ScrollDirection.HORIZONTAL) {
                this.scrollX = data;
            } else {
                this.scrollY = data;
            }
        }
    }

    public void setScrollDataX(ScrollData scrollX) {
        this.scrollX = scrollX;
    }

    public void setScrollDataY(ScrollData data) {
        this.scrollY = data;
    }

    public ScrollData getScrollX() {
        return this.scrollX;
    }

    public ScrollData getScrollY() {
        return this.scrollY;
    }

    public ScrollData getScrollData(GuiAxis axis) {
        return axis.isVertical() ? this.scrollY : this.scrollX;
    }

    public ScrollData getScrollData(ScrollDirection axis) {
        return this.getScrollData(axis.axis);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(GuiContext context) {
        return this.mouseClicked(context.getAbsMouseX(), context.getAbsMouseY());
    }

    public boolean mouseClicked(int x, int y) {
        ScrollData data;
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            data = this.scrollX;
        } else if (this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y)) {
            data = this.scrollY;
        } else {
            return false;
        }
        data.dragging = true;
        int scrollbar = data.getScrollbarThickness();
        if (data.opposite) {
            return data.direction == ScrollDirection.VERTICAL ? x <= this.x + scrollbar : y <= this.y + scrollbar;
        }
        return data.direction == ScrollDirection.VERTICAL ? x >= this.ex() - scrollbar : y >= this.ey() - scrollbar;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseScroll(GuiContext context) {
        return this.mouseScroll(context.getAbsMouseX(), context.getAbsMouseY(), context.getMouseWheel(), GuiScreen.func_146272_n());
    }

    public boolean mouseScroll(int x, int y, int scroll, boolean shift) {
        ScrollData data;
        if (!this.isInside(x, y)) {
            return false;
        }
        if (this.scrollX != null) {
            data = this.scrollY == null || shift ? this.scrollX : this.scrollY;
        } else if (this.scrollY != null) {
            data = this.scrollY;
        } else {
            return false;
        }
        int scrollTo = data.scroll - (int)Math.copySign(data.scrollSpeed, scroll);
        int oldScroll = data.scroll;
        data.scrollTo(this, scrollTo);
        boolean changed = data.scroll != oldScroll;
        data.scrollTo(this, oldScroll);
        if (changed) {
            data.animateTo(this, scrollTo);
            return true;
        }
        return data.cancelScrollEdge;
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseReleased(GuiContext context) {
        this.mouseReleased(context.getAbsMouseX(), context.getAbsMouseY());
    }

    public void mouseReleased(int x, int y) {
        if (this.scrollX != null) {
            this.scrollX.dragging = false;
        }
        if (this.scrollY != null) {
            this.scrollY.dragging = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drag(GuiContext context) {
        this.drag(context.getMouseX(), context.getMouseY());
    }

    public void drag(int x, int y) {
        ScrollData data;
        if (this.scrollX != null && this.scrollX.dragging) {
            data = this.scrollX;
        } else if (this.scrollY != null && this.scrollY.dragging) {
            data = this.scrollY;
        } else {
            return;
        }
        float progress = data.direction.getProgress(this, x, y);
        data.animateTo(this, (int)(progress * (float)(data.scrollSize - data.direction.getSide(this) + data.getScrollbarThickness())));
    }

    public boolean isInsideScrollbarArea(int x, int y) {
        if (!this.isInside(x, y)) {
            return false;
        }
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            return true;
        }
        return this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y);
    }

    public boolean isScrollBarXActive() {
        return this.scrollX != null && this.scrollX.scrollSize > this.scrollX.direction.getSide(this);
    }

    public boolean isScrollBarYActive() {
        return this.scrollY != null && this.scrollY.scrollSize > this.scrollY.direction.getSide(this);
    }

    public int getScrollBarBackgroundColor() {
        return this.scrollBarBackgroundColor;
    }

    public void setScrollBarBackgroundColor(int scrollBarBackgroundColor) {
        this.scrollBarBackgroundColor = scrollBarBackgroundColor;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawScrollbar() {
        if (this.scrollX != null) {
            this.scrollX.drawScrollbar(this);
        }
        if (this.scrollY != null) {
            this.scrollY.drawScrollbar(this);
        }
    }
}

