/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.utils.Animator;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.ScrollArea;
import com.cleanroommc.modularui.utils.ScrollDirection;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScrollData {
    public final ScrollDirection direction;
    public int scrollItemSize;
    public int scrollSize;
    public int scroll;
    public boolean dragging;
    public int scrollSpeed = ModularUIConfig.defaultScrollSpeed;
    public boolean opposite;
    public int scrollbarWidth = -1;
    public boolean cancelScrollEdge = false;
    private Animator scrollAnimator;

    public ScrollData(ScrollDirection direction) {
        this.direction = direction;
    }

    public int getScrollbarThickness() {
        return this.scrollbarWidth <= 0 ? 4 : this.scrollbarWidth;
    }

    public void setSize(int items) {
        this.scrollSize = items * this.scrollItemSize;
    }

    public void scrollBy(ScrollArea area, int x) {
        this.scroll += x;
        this.clamp(area);
    }

    public void scrollTo(ScrollArea area, int x) {
        this.scroll = x;
        this.clamp(area);
    }

    public void animateTo(ScrollArea area, int x) {
        if (this.scrollAnimator == null) {
            this.scrollAnimator = new Animator(30, Interpolation.QUAD_OUT).setCallback(value -> this.scrollTo(area, (int)value));
        }
        this.scrollAnimator.setValueBounds(this.scroll, x);
        this.scrollAnimator.forward();
    }

    public void scrollIntoView(ScrollArea area, int x) {
        this.scrollIntoView(area, x, this.scrollItemSize, 0);
    }

    public void scrollIntoView(ScrollArea area, int x, int bottomOffset) {
        this.scrollIntoView(area, x, bottomOffset, 0);
    }

    public void scrollIntoView(ScrollArea area, int x, int bottomOffset, int topOffset) {
        if (this.scroll + topOffset > x) {
            this.scrollTo(area, x - topOffset);
        } else if (x > this.scroll + this.direction.getSide(area) - bottomOffset) {
            this.scrollTo(area, x - this.direction.getSide(area) + bottomOffset);
        }
    }

    public void clamp(ScrollArea area) {
        int size = this.direction.getSide(area);
        this.scroll = this.scrollSize <= size ? 0 : MathHelper.func_76125_a((int)this.scroll, (int)0, (int)(this.scrollSize - size));
    }

    public int getIndex(ScrollArea area, int x, int y) {
        int axis = this.direction.getScroll(area, x, y);
        int index = axis / this.scrollItemSize;
        if (axis < 0) {
            return -1;
        }
        if (axis > this.scrollSize) {
            return -2;
        }
        return index > this.scrollSize / this.scrollItemSize ? -1 : index;
    }

    public int getScrollBarLength(ScrollArea area) {
        return (int)((float)(this.direction.getSide(area) * this.direction.getFullSide(area)) / (float)this.scrollSize);
    }

    public boolean isInsideScrollbarArea(ScrollArea area, int x, int y) {
        if (!area.isInside(x, y) || !this.isScrollBarActive(area)) {
            return false;
        }
        int scrollbar = this.getScrollbarThickness();
        if (this.direction == ScrollDirection.HORIZONTAL) {
            if (area.getScrollY() != null && area.getScrollY().isScrollBarActive(area, true)) {
                int thickness = area.getScrollY().getScrollbarThickness();
                if (area.getScrollY().opposite ? x < area.x + thickness : x >= area.ex() - thickness) {
                    return false;
                }
            }
            return this.opposite ? y >= area.y && y < area.y + scrollbar : y >= area.ey() - scrollbar && y < area.ey();
        }
        if (this.direction == ScrollDirection.VERTICAL) {
            if (area.getScrollX() != null && area.getScrollX().isScrollBarActive(area, true)) {
                int thickness = area.getScrollX().getScrollbarThickness();
                if (area.getScrollX().opposite ? y < area.y + thickness : y >= area.ey() - thickness) {
                    return false;
                }
            }
            return this.opposite ? x >= area.x && x < area.x + scrollbar : x >= area.ex() - scrollbar && x < area.ex();
        }
        return false;
    }

    public boolean isScrollBarActive(ScrollArea area) {
        return this.isScrollBarActive(area, false);
    }

    public boolean isScrollBarActive(ScrollArea area, boolean isOtherActive) {
        return this.scrollSize > this.direction.getSide(area, isOtherActive);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawScrollbar(ScrollArea area) {
        int ry;
        int rx;
        int side = this.direction.getSide(area);
        if (!this.isScrollBarActive(area)) {
            return;
        }
        int scrollbar = this.getScrollbarThickness();
        int h = this.getScrollBarLength(area);
        int x = 0;
        int y = 0;
        if (this.direction == ScrollDirection.VERTICAL) {
            x = this.opposite ? 0 : area.width - scrollbar;
            rx = x + scrollbar;
            ry = area.height;
        } else {
            y = this.opposite ? 0 : area.height - scrollbar;
            ry = y + scrollbar;
            rx = area.width;
        }
        GuiDraw.drawRect(x, y, rx, ry, area.getScrollBarBackgroundColor());
        if (this.direction == ScrollDirection.VERTICAL) {
            y = (this.direction.getFullSide(area) - h) * this.scroll / (this.scrollSize - side);
            if (area.getScrollX() != null && area.getScrollX().isScrollBarActive(area, true) && area.getScrollX().opposite) {
                y += area.getScrollX().getScrollbarThickness();
            }
            ry = y + h;
        } else {
            y = this.opposite ? 0 : area.height - scrollbar;
            x = (this.direction.getFullSide(area) - h) * this.scroll / (this.scrollSize - side);
            if (area.getScrollY() != null && area.getScrollY().isScrollBarActive(area, true) && area.getScrollY().opposite) {
                x += area.getScrollY().getScrollbarThickness();
            }
            rx = x + h;
            ry = y + scrollbar;
        }
        int color = 0;
        GuiDraw.drawDropShadow(x, y, rx, ry, 5, color, Color.withAlpha(color, 0));
        Gui.func_73734_a((int)x, (int)y, (int)rx, (int)ry, (int)-1118482);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)rx, (int)ry, (int)-10066330);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(rx - 1), (int)(ry - 1), (int)-5592406);
    }

    public ScrollData copyWith(ScrollDirection direction) {
        ScrollData data = new ScrollData(direction);
        data.scroll = this.scroll;
        data.dragging = this.dragging;
        data.cancelScrollEdge = this.cancelScrollEdge;
        data.opposite = this.opposite;
        data.scrollAnimator = this.scrollAnimator;
        data.scrollbarWidth = this.scrollbarWidth;
        data.scrollItemSize = this.scrollItemSize;
        data.scrollSize = this.scrollSize;
        data.scrollSpeed = this.scrollSpeed;
        return data;
    }
}

