/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.utils.ScrollArea;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;

public enum ScrollDirection {
    VERTICAL(GuiAxis.Y){

        @Override
        public int getPosition(Area area, float x) {
            return area.y(x);
        }

        @Override
        public int getSide(ScrollArea area, boolean otherIsActive) {
            return Math.max(0, this.getFullSide(area, otherIsActive) - area.getPadding().vertical());
        }

        @Override
        public int getFullSide(ScrollArea area, boolean otherIsActive) {
            int offset = 0;
            if (otherIsActive || area.getScrollX() != null && area.getScrollX().isScrollBarActive(area, true)) {
                offset = area.getScrollX().getScrollbarThickness();
            }
            return area.h() - offset;
        }

        @Override
        public int getScroll(ScrollArea area, int x, int y) {
            return y - area.y + area.getScrollY().scroll;
        }

        @Override
        public float getProgress(ScrollArea area, int x, int y) {
            return (float)(y - area.y) / (float)this.getFullSide(area);
        }
    }
    ,
    HORIZONTAL(GuiAxis.X){

        @Override
        public int getPosition(Area area, float x) {
            return area.x(x);
        }

        @Override
        public int getSide(ScrollArea area, boolean otherIsActive) {
            return Math.max(0, this.getFullSide(area, otherIsActive) - area.getPadding().horizontal());
        }

        @Override
        public int getFullSide(ScrollArea area, boolean otherIsActive) {
            int offset = 0;
            if (otherIsActive || area.getScrollY() != null && area.getScrollY().isScrollBarActive(area, true)) {
                offset = area.getScrollY().getScrollbarThickness();
            }
            return area.w() - offset;
        }

        @Override
        public int getScroll(ScrollArea area, int x, int y) {
            return x - area.x + area.getScrollX().scroll;
        }

        @Override
        public float getProgress(ScrollArea area, int x, int y) {
            return (float)(x - area.x) / (float)this.getFullSide(area);
        }
    };

    public final GuiAxis axis;

    private ScrollDirection(GuiAxis axis) {
        this.axis = axis;
    }

    public abstract int getPosition(Area var1, float var2);

    public int getSide(ScrollArea area) {
        return this.getSide(area, false);
    }

    public abstract int getSide(ScrollArea var1, boolean var2);

    public int getFullSide(ScrollArea area) {
        return this.getFullSide(area, false);
    }

    public abstract int getFullSide(ScrollArea var1, boolean var2);

    public abstract int getScroll(ScrollArea var1, int var2, int var3);

    public abstract float getProgress(ScrollArea var1, int var2, int var3);
}

