/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IDraggable;
import com.cleanroommc.modularui.api.widget.IWidgetList;
import com.cleanroommc.modularui.utils.BitHelper;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public class DraggableWidget<W extends DraggableWidget<W>>
extends Widget<W>
implements IDraggable {
    private boolean moving = false;
    private int relativeClickX;
    private int relativeClickY;
    private final Area movingArea = this.getArea().createCopy();

    @Override
    public void drawMovingState(float partialTicks) {
        WidgetTree.drawTree(this, this.getContext(), true);
    }

    @Override
    public boolean onDragStart(int mouseButton) {
        if (mouseButton == 0) {
            this.relativeClickX = this.getContext().getMouseX() - this.getArea().x;
            this.relativeClickY = this.getContext().getMouseY() - this.getArea().y;
            this.movingArea.x = this.getContext().getAbsMouseX() - this.relativeClickX;
            this.movingArea.y = this.getContext().getAbsMouseY() - this.relativeClickY;
            return true;
        }
        return false;
    }

    @Override
    public void onDragEnd(boolean successful) {
        if (successful) {
            this.flex().top(this.getContext().getAbsMouseY() - this.relativeClickY).left(this.getContext().getAbsMouseX() - this.relativeClickX);
            this.movingArea.x = this.getArea().x;
            this.movingArea.y = this.getArea().y;
            WidgetTree.resize(this);
        }
    }

    @Override
    public void onDrag(int mouseButton, long timeSinceLastClick) {
        this.movingArea.x = this.getContext().getAbsMouseX() - this.relativeClickX;
        this.movingArea.y = this.getContext().getAbsMouseY() - this.relativeClickY;
    }

    @Override
    @Nullable
    public Area getMovingArea() {
        return this.movingArea;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void setMoving(boolean moving) {
        this.moving = moving;
        this.setEnabled(!moving);
    }

    @Override
    public void getWidgetsBeforeApply(Stack<IViewport> viewports, IWidgetList widgets, int x, int y) {
        if (!this.isMoving() && this.getArea().isInside(this.getContext().localX(x), this.getContext().localY(y))) {
            widgets.add(this, viewports);
        }
    }

    @Override
    public void getWidgetsAt(Stack<IViewport> viewports, IWidgetList widgets, int x, int y) {
        if (!this.isMoving() && this.hasChildren()) {
            IViewport.getChildrenAt(this, viewports, widgets, x, y);
        }
    }

    @Override
    public void apply(IViewportStack stack, int context) {
        if (BitHelper.hasAnyBits(context, 6144)) {
            stack.pushViewport(this, this.getMovingArea());
            if (this.isMoving()) {
                stack.translate(-this.movingArea.x + this.getContext().globalX(this.getArea().x), -this.movingArea.y + this.getContext().globalY(this.getArea().y));
            }
        }
    }

    @Override
    public void unapply(IViewportStack stack, int context) {
        if (BitHelper.hasNone(context, 16) && BitHelper.hasAnyBits(context, 6144)) {
            stack.popViewport(this);
        }
    }
}

