/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.api.sync.ValueSyncHandler;
import com.cleanroommc.modularui.api.widget.IGuiAction;
import com.cleanroommc.modularui.api.widget.IPositioned;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.api.widget.ITooltip;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DrawableArray;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.Tooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.sync.GuiSyncHandler;
import com.cleanroommc.modularui.sync.MapKey;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widget.sizer.IResizeable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Widget<W extends Widget<W>>
implements IWidget,
IPositioned<W>,
ITooltip<W>,
ISynced<W> {
    public static final IDrawable[] EMPTY_BACKGROUND = new IDrawable[0];
    private final Area area = new Area();
    private boolean enabled = true;
    private boolean valid = false;
    private List<IGuiAction> guiActionListeners;
    private IWidget parent = null;
    private ModularPanel panel = null;
    private GuiContext context = null;
    private Flex flex = new Flex(this);
    private IResizeable resizer = this.flex;
    private String debugName;
    @Nullable
    private MapKey syncKey;
    @Nullable
    private SyncHandler syncHandler;
    @Nullable
    private IDrawable background = null;
    @Nullable
    private IDrawable overlay = null;
    @Nullable
    private IDrawable hoverBackground = null;
    @Nullable
    private IDrawable hoverOverlay = null;
    @Nullable
    private Tooltip tooltip;

    @Override
    @ApiStatus.Internal
    public void initialise(@NotNull IWidget parent) {
        if (this instanceof ModularPanel) {
            this.getArea().z(2);
        } else {
            this.parent = parent;
            this.panel = parent.getPanel();
            this.context = parent.getContext();
            this.getArea().z(parent.getArea().z() + 1);
            if (this.guiActionListeners != null) {
                for (IGuiAction action : this.guiActionListeners) {
                    this.context.screen.registerGuiActionListener(action);
                }
            }
        }
        this.valid = true;
        this.applyTheme(this.context.getTheme());
        this.onInit();
        if (this.tooltip != null && this.tooltip.getExcludeArea() == null && ModularUIConfig.placeTooltipNextToPanel()) {
            this.tooltip.excludeArea(this.getPanel().getArea());
        }
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.initialise(this);
            }
        }
        if (this.getScreen().getMainPanel() == this) {
            this.getArea().z(1);
        }
        this.afterInit();
    }

    @ApiStatus.OverrideOnly
    public void onInit() {
    }

    @ApiStatus.OverrideOnly
    public void afterInit() {
    }

    @Override
    public void initialiseSyncHandler(GuiSyncHandler syncHandler) {
        if (this.syncKey != null) {
            this.syncHandler = syncHandler.getSyncHandler(this.syncKey);
            if (!this.isValidSyncHandler(this.syncHandler)) {
                String type = this.syncHandler == null ? null : this.syncHandler.getClass().getName();
                this.syncHandler = null;
                throw new IllegalStateException("SyncHandler of type " + type + " is not valid for " + this.getClass().getName() + ", with key " + this.syncKey);
            }
            if (this.syncHandler instanceof ValueSyncHandler && ((ValueSyncHandler)this.syncHandler).getChangeListener() == null) {
                ((ValueSyncHandler)this.syncHandler).setChangeListener(this::markDirty);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.guiActionListeners != null) {
            for (IGuiAction action : this.guiActionListeners) {
                this.context.screen.removeGuiActionListener(action);
            }
        }
        if (!(this instanceof ModularPanel)) {
            this.panel = null;
            this.parent = null;
            this.context = null;
        }
        this.valid = false;
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.dispose();
            }
        }
    }

    @Override
    public void drawBackground(GuiContext context) {
        WidgetTheme widgetTheme = this.getWidgetTheme(context.getTheme());
        IDrawable bg = this.getCurrentBackground();
        if (bg != null) {
            bg.applyThemeColor(context.getTheme(), widgetTheme);
            bg.drawAtZero(context, this.getArea());
        }
        if ((bg = this.getCurrentOverlay()) != null) {
            bg.applyThemeColor(context.getTheme(), widgetTheme);
            bg.drawAtZero(context, this.getArea());
        }
    }

    @Override
    public void draw(GuiContext context) {
    }

    @Override
    public void drawForeground(GuiContext context) {
        Tooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw(this.getContext());
        }
    }

    @Override
    public void applyTheme(ITheme theme) {
        WidgetTheme widgetTheme = this.getWidgetTheme(theme);
        this.applyThemeBackground(false, widgetTheme.getBackground());
        this.applyThemeBackground(true, widgetTheme.getHoverBackground());
    }

    @Override
    public void onFrameUpdate() {
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public W getThis() {
        return (W)this;
    }

    @Override
    public ModularScreen getScreen() {
        return this.getPanel().getScreen();
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not in a valid state!");
        }
        return this.panel;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean canBeSeen() {
        return true;
    }

    @Override
    public void markDirty() {
        if (this.tooltip != null) {
            this.tooltip.markDirty();
        }
    }

    @Override
    @NotNull
    public IWidget getParent() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not in a valid state!");
        }
        return this.parent;
    }

    @Override
    public GuiContext getContext() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not in a valid state!");
        }
        return this.context;
    }

    protected final void setContext(GuiContext context) {
        this.context = context;
    }

    protected void applyThemeBackground(boolean hover, IDrawable drawable) {
        if (hover) {
            if (this.hoverBackground == null) {
                this.hoverBackground = drawable;
            }
        } else if (this.background == null) {
            this.background = drawable;
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getOverlay() {
        return this.overlay;
    }

    public IDrawable getHoverBackground() {
        return this.hoverBackground;
    }

    public IDrawable getHoverOverlay() {
        return this.hoverOverlay;
    }

    public IDrawable getCurrentBackground() {
        IDrawable hoverBackground = this.getHoverBackground();
        return hoverBackground != null && this.isHovering() ? hoverBackground : this.getBackground();
    }

    public IDrawable getCurrentOverlay() {
        IDrawable hoverBackground = this.getHoverOverlay();
        return hoverBackground != null && this.isHovering() ? hoverBackground : this.getOverlay();
    }

    @Override
    @Nullable
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public Tooltip tooltip() {
        if (this.tooltip == null) {
            this.tooltip = new Tooltip();
            if (!ModularUIConfig.placeTooltipNextToPanel()) {
                this.tooltip.excludeArea(this.getArea());
            }
        }
        return this.tooltip;
    }

    @Override
    public Flex getFlex() {
        return this.flex;
    }

    @Override
    public Flex flex() {
        if (this.flex == null) {
            this.flex = new Flex(this);
            if (this.resizer == null) {
                this.resizer = this.flex;
            }
        }
        return this.flex;
    }

    @Override
    public IResizeable resizer() {
        return this.resizer;
    }

    @Override
    public void resizer(IResizeable resizer) {
        this.resizer = resizer;
    }

    public SyncHandler getSyncHandler() {
        if (this.syncKey == null) {
            throw new IllegalStateException("Widget is not synced!");
        }
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised!");
        }
        return this.syncHandler;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public W disabled() {
        this.setEnabled(false);
        return (W)this.getThis();
    }

    public W background(IDrawable ... background) {
        this.background = background.length == 0 ? null : (background.length == 1 ? background[0] : new DrawableArray(background));
        return (W)this.getThis();
    }

    public W overlay(IDrawable ... overlay) {
        this.overlay = overlay.length == 0 ? null : (overlay.length == 1 ? overlay[0] : new DrawableArray(overlay));
        return (W)this.getThis();
    }

    public W hoverBackground(IDrawable ... background) {
        this.hoverBackground = background.length == 0 ? null : (background.length == 1 ? background[0] : new DrawableArray(background));
        return (W)this.getThis();
    }

    public W hoverOverlay(IDrawable ... overlay) {
        this.hoverOverlay = overlay.length == 0 ? null : (overlay.length == 1 ? overlay[0] : new DrawableArray(overlay));
        return (W)this.getThis();
    }

    public W listenGuiAction(IGuiAction action) {
        if (this.guiActionListeners == null) {
            this.guiActionListeners = new ArrayList<IGuiAction>();
        }
        this.guiActionListeners.add(action);
        if (this.isValid()) {
            this.context.screen.registerGuiActionListener(action);
        }
        return (W)this.getThis();
    }

    public W debugName(String name) {
        this.debugName = name;
        return (W)this.getThis();
    }

    @Override
    public W setSynced(MapKey key) {
        this.syncKey = key;
        return (W)this.getThis();
    }

    public String toString() {
        if (this.debugName != null) {
            return this.getClass().getSimpleName() + "#" + this.debugName;
        }
        return this.getClass().getSimpleName();
    }
}

