/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.IResizeable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.ApiStatus;

public class WidgetTree {
    private WidgetTree() {
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent) {
        return WidgetTree.getAllChildrenByLayer(parent, false);
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent, boolean includeSelf) {
        ArrayList<IWidget> children = new ArrayList<IWidget>();
        if (includeSelf) {
            children.add(parent);
        }
        LinkedList<IWidget> parents = new LinkedList<IWidget>();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.pollFirst()).getChildren()) {
                if (!child.getChildren().isEmpty()) {
                    parents.add(child);
                }
                children.add(child);
            }
        }
        return children;
    }

    public static boolean foreachChildByLayer(IWidget parent, Predicate<IWidget> consumer) {
        return WidgetTree.foreachChildByLayer(parent, consumer, false);
    }

    public static boolean foreachChildByLayer(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        LinkedList<IWidget> parents = new LinkedList<IWidget>();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.pollFirst()).getChildren()) {
                if (child.hasChildren()) {
                    parents.addLast(child);
                }
                if (consumer.test(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean foreachChildByLayer2(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        LinkedList<IWidget> parents = new LinkedList<IWidget>();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.pollFirst()).getChildren()) {
                if (!consumer.test(child)) {
                    return false;
                }
                if (!child.hasChildren()) continue;
                parents.addLast(child);
            }
        }
        return true;
    }

    public static boolean foreachChild(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        if (parent.getChildren().isEmpty()) {
            return true;
        }
        for (IWidget widget : parent.getChildren()) {
            if (!consumer.test(widget)) {
                return false;
            }
            if (widget.getChildren().isEmpty() || !WidgetTree.foreachChild(widget, consumer, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean foreachChildReverse(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (parent.getChildren().isEmpty()) {
            return !includeSelf || consumer.test(parent);
        }
        for (IWidget widget : parent.getChildren()) {
            if (!widget.getChildren().isEmpty() && WidgetTree.foreachChildReverse(widget, consumer, false)) {
                return false;
            }
            if (consumer.test(widget)) continue;
            return false;
        }
        return !includeSelf || consumer.test(parent);
    }

    public static void drawTree(IWidget parent, GuiContext context) {
        WidgetTree.drawTree(parent, context, false);
    }

    public static void drawTree(IWidget parent, GuiContext context, boolean ignoreEnabled) {
        IViewport viewport;
        float y;
        float x;
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        GlStateManager.func_179094_E();
        Area panel = parent.getPanel().getArea();
        float alpha = parent.getPanel().getAlpha();
        float scale = parent.getPanel().getScale();
        float sf = 1.0f / scale;
        if (parent instanceof ModularPanel) {
            GlStateManager.func_179109_b((float)parent.getArea().x, (float)parent.getArea().y, (float)0.0f);
            x = (float)parent.getArea().width / 2.0f;
            y = (float)parent.getArea().height / 2.0f;
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        } else {
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            x = ((float)panel.x + (float)panel.w() / 2.0f * (1.0f - scale) + (float)(parent.getArea().x - panel.x) * scale) * sf;
            y = ((float)panel.y + (float)panel.h() / 2.0f * (1.0f - scale) + (float)(parent.getArea().y - panel.y) * scale) * sf;
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179147_l();
        context.applyToOpenGl();
        parent.drawBackground(context);
        parent.draw(context);
        IViewport iViewport = viewport = parent instanceof IViewport ? (IViewport)((Object)parent) : null;
        if (viewport != null) {
            viewport.preDraw(context, false);
            viewport.apply(context, 5);
            context.applyTopToOpenGl();
            viewport.preDraw(context, true);
        }
        GlStateManager.func_179121_F();
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            children.forEach(widget -> WidgetTree.drawTree(widget, context, false));
        }
        if (viewport != null) {
            GlStateManager.func_179094_E();
            if (parent instanceof ModularPanel) {
                GlStateManager.func_179109_b((float)parent.getArea().x, (float)parent.getArea().y, (float)0.0f);
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
            } else {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179147_l();
            context.applyToOpenGl();
            viewport.postDraw(context, true);
            context.unapplyTopToOpenGl();
            viewport.unapply(context, 9);
            viewport.postDraw(context, false);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawTreeForeground(IWidget parent, GuiContext context) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        parent.drawForeground(context);
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            children.forEach(widget -> WidgetTree.drawTreeForeground(widget, context));
        }
    }

    @ApiStatus.Internal
    public static void onFrameUpdate(IWidget parent) {
        WidgetTree.foreachChildByLayer(parent, widget -> {
            widget.onFrameUpdate();
            return true;
        }, true);
    }

    public static void resize(IWidget parent) {
        parent.resize();
        WidgetTree.foreachChildByLayer(parent, child -> {
            IResizeable resizer = child.resizer();
            if (resizer != null) {
                resizer.applyPos((IGuiElement)child);
            }
            return true;
        }, true);
        WidgetTree.foreachChildByLayer(parent, child -> {
            child.postResize();
            return true;
        }, true);
    }

    public static IGuiElement findParent(IGuiElement parent, Predicate<IGuiElement> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return filter.test(parent) ? parent : null;
    }

    public static IWidget findParent(IWidget parent, Predicate<IWidget> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return filter.test(parent) ? parent : null;
    }
}

