/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.sizer;

import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;
import com.cleanroommc.modularui.widget.sizer.Unit;
import java.util.function.IntSupplier;

public class DimensionSizer {
    private final GuiAxis axis;
    private Unit start;
    private Unit end;
    private Unit size;
    private Unit p1;
    private Unit p2;
    private boolean coverChildren = false;
    private boolean cancelAutoMovement = false;
    private boolean defaultMode = false;

    public DimensionSizer(GuiAxis axis) {
        this.axis = axis;
        this.reset();
    }

    public void reset() {
        this.p1 = new Unit();
        this.p2 = new Unit();
        this.start = null;
        this.end = null;
        this.size = null;
    }

    public void setDefaultMode(boolean defaultMode) {
        this.defaultMode = defaultMode;
    }

    public void setCoverChildren(boolean coverChildren) {
        this.getSize();
        this.coverChildren = coverChildren;
    }

    public void setCancelAutoMovement(boolean cancelAutoMovement) {
        this.cancelAutoMovement = cancelAutoMovement;
    }

    public boolean hasStart() {
        return this.start != null;
    }

    public boolean hasEnd() {
        return this.end != null;
    }

    public boolean hasPos() {
        return this.start != null || this.end != null;
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public boolean dependsOnChildren() {
        return this.coverChildren;
    }

    public boolean dependsOnParent() {
        return this.end != null || this.start != null && this.start.isRelative() || this.size != null && this.size.isRelative();
    }

    public void apply(Area area, Area relativeTo, IntSupplier defaultSize) {
        int s;
        int p;
        int parentSize = relativeTo.getSize(this.axis);
        if (this.start == null && this.end == null) {
            p = 0;
            s = this.size == null ? defaultSize.getAsInt() : this.calcSize(this.size, parentSize);
        } else if (this.size == null) {
            if (this.start != null && this.end != null) {
                p = this.calcPoint(this.start, -1, parentSize);
                int x2 = this.calcPoint(this.end, -1, parentSize);
                s = Math.abs(parentSize - x2 - p);
            } else {
                s = defaultSize.getAsInt();
                if (this.start == null) {
                    p = this.calcPoint(this.end, s, parentSize);
                    p -= s;
                } else {
                    p = this.calcPoint(this.start, s, parentSize);
                }
            }
        } else if (this.end == null) {
            s = this.calcSize(this.size, parentSize);
            p = this.calcPoint(this.start, s, parentSize);
        } else {
            s = this.calcSize(this.size, parentSize);
            p = this.calcPoint(this.end, s, parentSize);
            p = parentSize - p - s;
        }
        Box.SHARED.all(0);
        Box padding = relativeTo.getPadding();
        Box margin = area.getMargin();
        if (parentSize < 1 || this.size != null && !this.size.isRelative()) {
            area.setRelativePoint(this.axis, p);
        } else {
            area.setRelativePoint(this.axis, Math.max(p, padding.getStart(this.axis) + margin.getStart(this.axis)));
            s = Math.min(s, parentSize - padding.getTotal(this.axis) - margin.getTotal(this.axis));
        }
        area.setSize(this.axis, s);
        area.setPoint(this.axis, p += relativeTo.x);
    }

    public int postApply(Area area, Area relativeTo, int p0, int p1) {
        int p;
        int moveAmount = 0;
        int s = p1 - p0;
        area.setSize(this.axis, s);
        if (this.start != null) {
            p = this.calcPoint(this.start, s, relativeTo.getSize(this.axis));
        } else if (this.end != null) {
            p = this.calcPoint(this.end, s, relativeTo.getSize(this.axis));
            p = relativeTo.getSize(this.axis) - p - s;
        } else {
            p = area.getRelativePoint(this.axis) + p0 + area.getMargin().getStart(this.axis);
            if (!this.cancelAutoMovement) {
                moveAmount = -p0;
            }
        }
        area.setRelativePoint(this.axis, p);
        return moveAmount;
    }

    private int calcSize(Unit s, int parentSize) {
        float val = s.getValue();
        if (s.isRelative()) {
            return (int)(val * (float)parentSize);
        }
        return (int)val;
    }

    public int calcPoint(Unit p, int width, int parentSize) {
        float val = p.getValue();
        if (p.isRelative()) {
            val = (float)parentSize * val;
        }
        float anchor = p.getAnchor();
        if (width > 0 && anchor != 0.0f) {
            val -= (float)width * anchor;
        }
        if (p.getOffset() != 0) {
            val += (float)p.getOffset();
        }
        return (int)val;
    }

    protected Unit getStart() {
        if (this.start == null) {
            Unit u = null;
            if (this.p1.type == -2) {
                u = this.p1;
            } else if (this.p2.type == -2) {
                u = this.p2;
            } else if (!this.defaultMode) {
                if (this.end.type == -1) {
                    u = this.end;
                    this.end = null;
                } else if (this.size.type == -1) {
                    u = this.size;
                    this.size = null;
                }
            }
            if (u == null) {
                throw new IllegalStateException();
            }
            this.start = u;
            this.start.reset();
        }
        this.start.type = (byte)(this.defaultMode ? -1 : 0);
        return this.start;
    }

    protected Unit getEnd() {
        if (this.end == null) {
            Unit u = null;
            if (this.p1.type == -2) {
                u = this.p1;
            } else if (this.p2.type == -2) {
                u = this.p2;
            } else if (!this.defaultMode) {
                if (this.start.type == -1) {
                    u = this.start;
                    this.start = null;
                } else if (this.size.type == -1) {
                    u = this.size;
                    this.size = null;
                }
            }
            if (u == null) {
                throw new IllegalStateException();
            }
            this.end = u;
            this.end.reset();
        }
        this.end.type = (byte)(this.defaultMode ? -1 : 1);
        return this.end;
    }

    protected Unit getSize() {
        if (this.size == null) {
            Unit u = null;
            if (this.p1.type == -2) {
                u = this.p1;
            } else if (this.p2.type == -2) {
                u = this.p2;
            } else if (!this.defaultMode) {
                if (this.end.type == -1) {
                    u = this.end;
                    this.end = null;
                } else if (this.start.type == -1) {
                    u = this.start;
                    this.start = null;
                }
            }
            if (u == null) {
                throw new IllegalStateException();
            }
            this.size = u;
            this.size.reset();
        }
        this.size.type = (byte)(this.defaultMode ? -1 : 2);
        return this.size;
    }
}

