/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.sizer;

import com.cleanroommc.modularui.GuiError;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widget.sizer.DimensionSizer;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;
import com.cleanroommc.modularui.widget.sizer.IResizeable;
import com.cleanroommc.modularui.widget.sizer.Unit;
import java.util.List;
import net.minecraft.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;

public class Flex
implements IResizeable {
    private final DimensionSizer x = new DimensionSizer(GuiAxis.X);
    private final DimensionSizer y = new DimensionSizer(GuiAxis.Y);
    private boolean expanded = false;
    private final IGuiElement parent;
    private Area relativeTo;
    private boolean relativeToParent = true;
    private boolean skip = false;

    public Flex(IGuiElement parent) {
        this.parent = parent;
    }

    public void reset() {
        this.x.reset();
        this.y.reset();
    }

    public Flex startDefaultMode() {
        this.x.setDefaultMode(true);
        this.y.setDefaultMode(true);
        return this;
    }

    public Flex endDefaultMode() {
        this.x.setDefaultMode(false);
        this.y.setDefaultMode(false);
        return this;
    }

    public Flex coverChildrenWidth() {
        this.x.setCoverChildren(true);
        return this;
    }

    public Flex coverChildrenHeight() {
        this.y.setCoverChildren(true);
        return this;
    }

    public Flex cancelMovementX() {
        this.x.setCancelAutoMovement(true);
        return this;
    }

    public Flex cancelMovementY() {
        this.y.setCancelAutoMovement(true);
        return this;
    }

    public Flex expanded() {
        this.expanded = true;
        return this;
    }

    public Flex coverChildren() {
        return this.coverChildrenWidth().coverChildrenHeight();
    }

    public Flex relative(IGuiElement guiElement) {
        return this.relative(guiElement.getArea());
    }

    public Flex relative(Area guiElement) {
        this.relativeTo = guiElement;
        this.relativeToParent = false;
        return this;
    }

    public Flex relativeToScreen() {
        this.relativeTo = null;
        this.relativeToParent = false;
        return this;
    }

    public Flex relativeToParent() {
        this.relativeToParent = true;
        return this;
    }

    public Flex left(int x) {
        return this.left(x, 0, 0.0f, Unit.Measure.PIXEL, true);
    }

    public Flex left(float x) {
        return this.left(x, 0, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex left(float x, int offset) {
        return this.left(x, offset, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex left(float x, float anchor) {
        return this.left(x, 0, anchor, Unit.Measure.RELATIVE, false);
    }

    public Flex left(float x, int offset, float anchor, Unit.Measure measure) {
        return this.left(x, offset, anchor, measure, false);
    }

    @ApiStatus.Internal
    public Flex left(float x, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getLeft(), x, offset, anchor, measure, autoAnchor);
    }

    public Flex right(int x) {
        return this.right(x, 0, 0.0f, Unit.Measure.PIXEL, true);
    }

    public Flex right(float x) {
        return this.right(x, 0, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex right(float x, int offset) {
        return this.right(x, offset, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex right(float x, float anchor) {
        return this.right(x, 0, anchor, Unit.Measure.RELATIVE, false);
    }

    public Flex right(float x, int offset, float anchor, Unit.Measure measure) {
        return this.right(x, offset, anchor, measure, false);
    }

    @ApiStatus.Internal
    public Flex right(float x, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getRight(), x, offset, anchor, measure, autoAnchor);
    }

    private Flex unit(Unit u, float val, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        u.setValue(val);
        u.setMeasure(measure);
        u.setOffset(offset);
        u.setAnchor(anchor);
        u.setAutoAnchor(autoAnchor);
        return this;
    }

    public Flex top(int y) {
        return this.top(y, 0, 0.0f, Unit.Measure.PIXEL, true);
    }

    public Flex top(float y) {
        return this.top(y, 0, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex top(float y, int offset) {
        return this.top(y, offset, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex top(float y, float anchor) {
        return this.top(y, 0, anchor, Unit.Measure.RELATIVE, false);
    }

    public Flex top(float y, int offset, float anchor, Unit.Measure measure) {
        return this.top(y, offset, anchor, measure, false);
    }

    @ApiStatus.Internal
    public Flex top(float y, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getTop(), y, offset, anchor, measure, autoAnchor);
    }

    public Flex bottom(int y) {
        return this.bottom(y, 0, 0.0f, Unit.Measure.PIXEL, true);
    }

    public Flex bottom(float y) {
        return this.bottom(y, 0, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex bottom(float y, int offset) {
        return this.bottom(y, offset, 0.0f, Unit.Measure.RELATIVE, true);
    }

    public Flex bottom(float y, float anchor) {
        return this.bottom(y, 0, anchor, Unit.Measure.RELATIVE, false);
    }

    public Flex bottom(float y, int offset, float anchor, Unit.Measure measure) {
        return this.bottom(y, offset, anchor, measure, false);
    }

    @ApiStatus.Internal
    public Flex bottom(float y, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getBottom(), y, offset, anchor, measure, autoAnchor);
    }

    public Flex pos(int x, int y) {
        return this.left(x).top(y);
    }

    public Flex pos(float x, float y) {
        return this.left(x).top(y);
    }

    public Flex width(int w) {
        return this.width(w, Unit.Measure.PIXEL);
    }

    public Flex width(float w) {
        return this.width(w, Unit.Measure.RELATIVE);
    }

    public Flex width(float w, Unit.Measure measure) {
        return this.unitSize(this.getWidth(), w, measure);
    }

    public Flex height(int h) {
        return this.height(h, Unit.Measure.PIXEL);
    }

    public Flex height(float h) {
        return this.height(h, Unit.Measure.RELATIVE);
    }

    public Flex height(float h, Unit.Measure measure) {
        return this.unitSize(this.getHeight(), h, measure);
    }

    private Flex unitSize(Unit u, float val, Unit.Measure measure) {
        u.setValue(val);
        u.setMeasure(measure);
        return this;
    }

    public Flex size(int w, int h) {
        return this.width(w).height(h);
    }

    public Flex size(float w, float h) {
        return this.width(w).height(h);
    }

    public Flex anchorLeft(float val) {
        this.getLeft().setAnchor(val);
        this.getLeft().setAutoAnchor(false);
        return this;
    }

    public Flex anchorRight(float val) {
        this.getRight().setAnchor(1.0f - val);
        this.getRight().setAutoAnchor(false);
        return this;
    }

    public Flex anchorTop(float val) {
        this.getTop().setAnchor(val);
        this.getTop().setAutoAnchor(false);
        return this;
    }

    public Flex anchorBottom(float val) {
        this.getBottom().setAnchor(1.0f - val);
        this.getBottom().setAutoAnchor(false);
        return this;
    }

    public Flex anchor(Alignment alignment) {
        if (this.x.hasStart()) {
            this.anchorLeft(alignment.x);
        }
        if (this.x.hasEnd()) {
            this.anchorRight(alignment.x);
        }
        if (this.y.hasStart()) {
            this.anchorTop(alignment.y);
        }
        if (this.y.hasEnd()) {
            this.anchorBottom(alignment.y);
        }
        return this;
    }

    public Flex alignX(float val) {
        return this.left(val).anchorLeft(val);
    }

    public Flex alignY(float val) {
        return this.top(val).anchorTop(val);
    }

    public Flex align(Alignment alignment) {
        this.alignX(alignment.x);
        this.alignY(alignment.y);
        return this;
    }

    private Area getRelativeTo() {
        Area relativeTo = this.relativeToParent ? this.parent.getParentArea() : this.relativeTo;
        return relativeTo != null ? relativeTo : this.parent.getScreen().getViewport();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean hasYPos() {
        return this.y.hasPos();
    }

    public boolean hasXPos() {
        return this.x.hasPos();
    }

    public boolean hasHeight() {
        return this.y.hasSize();
    }

    public boolean hasWidth() {
        return this.x.hasSize();
    }

    public boolean xAxisDependsOnChildren() {
        return this.x.dependsOnChildren();
    }

    public boolean yAxisDependsOnChildren() {
        return this.y.dependsOnChildren();
    }

    @ApiStatus.Internal
    public void skip() {
        this.skip = true;
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    @Override
    public void apply(IGuiElement guiElement) {
        if (this.isSkip()) {
            return;
        }
        Area relativeTo = this.getRelativeTo();
        if (relativeTo.z() >= this.parent.getArea().z()) {
            GuiError.throwNew(this.parent, GuiError.Type.SIZING, "Widget can't be relative to a widget at the same level or above");
            return;
        }
        if (this.x.dependsOnChildren() || this.y.dependsOnChildren()) {
            if (!(this.parent instanceof IWidget)) {
                throw new IllegalStateException("Can only cover children if instance of IWidget");
            }
            IWidget widget = (IWidget)this.parent;
            List<IWidget> children = widget.getChildren();
            if (!children.isEmpty()) {
                for (IWidget child : children) {
                    if (!this.dependsOnThis(child, null)) continue;
                    child.flex().skip();
                }
            }
        }
        this.x.apply(guiElement.getArea(), relativeTo, guiElement::getDefaultWidth);
        this.y.apply(guiElement.getArea(), relativeTo, guiElement::getDefaultHeight);
    }

    @Override
    public void postApply(IGuiElement guiElement) {
        List<IWidget> children;
        if ((this.x.dependsOnChildren() || this.y.dependsOnChildren()) && !(children = ((IWidget)this.parent).getChildren()).isEmpty()) {
            int moveChildrenX = 0;
            int moveChildrenY = 0;
            Box padding = this.parent.getArea().getPadding();
            int x0 = Integer.MAX_VALUE;
            int x1 = Integer.MIN_VALUE;
            int y0 = Integer.MAX_VALUE;
            int y1 = Integer.MIN_VALUE;
            for (IWidget child : children) {
                Box margin = child.getArea().getMargin();
                Flex flex = child.flex();
                Area area = child.getArea();
                if (this.x.dependsOnChildren() && !this.dependsOnThis(child, GuiAxis.X)) {
                    x0 = Math.min(x0, area.rx - padding.left - margin.left);
                    x1 = Math.max(x1, area.rx + area.width + padding.right + margin.right);
                }
                if (!this.y.dependsOnChildren() || this.dependsOnThis(child, GuiAxis.Y)) continue;
                y0 = Math.min(y0, area.ry - padding.top - margin.top);
                y1 = Math.max(y1, area.ry + area.height + padding.bottom + margin.bottom);
            }
            Area relativeTo = this.getRelativeTo();
            if (this.x.dependsOnChildren()) {
                moveChildrenX = this.x.postApply(this.parent.getArea(), relativeTo, x0, x1);
            }
            if (this.y.dependsOnChildren()) {
                moveChildrenY = this.y.postApply(this.parent.getArea(), relativeTo, y0, y1);
            }
            for (IWidget widget : children) {
                if (widget.flex().isSkip()) {
                    widget.flex().skip = false;
                    widget.resize();
                    continue;
                }
                Area area = widget.getArea();
                area.rx += moveChildrenX;
                area.ry += moveChildrenY;
            }
        }
    }

    @Override
    public void applyPos(IGuiElement parent) {
        Area relativeTo = this.getRelativeTo();
        parent.getArea().applyPos(relativeTo.x, relativeTo.y);
        if (parent instanceof IVanillaSlot) {
            Slot slot = ((IVanillaSlot)((Object)parent)).getVanillaSlot();
            slot.field_75223_e = parent.getArea().x;
            slot.field_75221_f = parent.getArea().y;
        }
    }

    private boolean dependsOnThis(IWidget child, GuiAxis axis) {
        Flex flex = child.getFlex();
        if (flex == null || flex.getRelativeTo() != this.parent.getArea()) {
            return false;
        }
        return axis == null ? flex.x.dependsOnParent() || flex.y.dependsOnParent() : (axis == GuiAxis.X ? flex.x.dependsOnParent() : flex.y.dependsOnParent());
    }

    private Unit getLeft() {
        return this.x.getStart();
    }

    private Unit getRight() {
        return this.x.getEnd();
    }

    private Unit getTop() {
        return this.y.getStart();
    }

    private Unit getBottom() {
        return this.y.getEnd();
    }

    private Unit getWidth() {
        return this.x.getSize();
    }

    private Unit getHeight() {
        return this.y.getSize();
    }
}

