/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.layout.MainAxisAlignment;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.Dialog;
import com.cleanroommc.modularui.widgets.PageButton;
import com.cleanroommc.modularui.widgets.PagedWidget;
import com.cleanroommc.modularui.widgets.SliderWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import java.util.function.Consumer;

public class ColorPickerDialog
extends Dialog<Integer> {
    private int color;
    private final int alpha;
    private final boolean controlAlpha;
    private final Rectangle preview = new Rectangle();
    private final Rectangle sliderBackgroundR = new Rectangle();
    private final Rectangle sliderBackgroundG = new Rectangle();
    private final Rectangle sliderBackgroundB = new Rectangle();
    private final Rectangle sliderBackgroundA = new Rectangle();

    public ColorPickerDialog(GuiContext context, Consumer<Integer> resultConsumer, int startColor) {
        this(context, resultConsumer, startColor, false);
    }

    public ColorPickerDialog(GuiContext context, Consumer<Integer> resultConsumer, int startColor, boolean controlAlpha) {
        super(context, resultConsumer);
        this.name("color_picker");
        this.alpha = Color.getAlpha(startColor);
        this.updateColor(startColor);
        this.controlAlpha = controlAlpha;
        ((ModularPanel)this.size(140, controlAlpha ? 106 : 94)).background(GuiTextures.BACKGROUND);
        this.align(Alignment.Center);
        PagedWidget.Controller controller = new PagedWidget.Controller();
        this.child((IWidget)((Column)((Column)((Column)((Column)((Column)((Column)((Column)new Column().left(5)).right(5)).top(5)).bottom(5)).child((IWidget)((Row)((Row)((Row)((Row)new Row().left(5)).right(5)).height(14)).child((IWidget)((PageButton)new PageButton(0, controller).size(0.5f, 1.0f)).background(true, GuiTextures.BUTTON).background(false, GuiTextures.SLOT_DARK).overlay(IKey.str("RGB")))).child((IWidget)((PageButton)new PageButton(1, controller).size(0.5f, 1.0f)).background(true, GuiTextures.BUTTON).background(false, GuiTextures.SLOT_DARK).overlay(IKey.str("HSV"))))).child((IWidget)((Row)((Row)((Row)((Row)((Row)new Row().width(1.0f)).height(12)).marginTop(4)).child((IWidget)IKey.str("Hex: ").asWidget().height(1.0f))).child(((TextFieldWidget)new TextFieldWidget().expanded()).setValidator(this::validateRawColor).getter(() -> {
            if (controlAlpha) {
                return "#" + Integer.toHexString(this.color);
            }
            return "#" + Integer.toHexString(Color.withAlpha(this.color, 0));
        }).setter(val -> {
            try {
                this.updateColor(Integer.decode(val));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }))).child((IWidget)((Widget)this.preview.asWidget().background(GuiTextures.CHECKBOARD).size(10, 10)).margin(1)))).child((IWidget)((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)new PagedWidget().left(5)).right(5)).expanded()).controller(controller)).addPage(this.createRGBPage(context))).addPage(this.createHSVPage(context)))).child((IWidget)((Row)((Row)((Row)((Row)new Row().left(10)).right(10)).height(14)).mainAxisAlignment(MainAxisAlignment.SPACE_BETWEEN).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().height(1.0f)).width(50)).overlay(IKey.str("Cancel"))).onMousePressed(button -> {
            this.animateClose();
            return true;
        }))).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().height(1.0f)).width(50)).overlay(IKey.str("Confirm"))).onMousePressed(button -> {
            this.closeWith(this.color);
            return true;
        }))));
    }

    private IWidget createRGBPage(GuiContext context) {
        Rectangle handleBackground = new Rectangle().setColor(Color.WHITE.normal);
        Column parentWidget = (Column)((Column)((Column)((Column)new Column().size(1.0f, 1.0f)).child((IWidget)((Row)((Row)((Row)new Row().width(1.0f)).height(12)).child((IWidget)IKey.str("R: ").asWidget().height(1.0f))).child(((SliderWidget)((SliderWidget)((SliderWidget)new SliderWidget().expanded()).height(1.0f)).background(this.sliderBackgroundR.asIcon().size(0, 4))).sliderTexture(handleBackground).sliderSize(2, 8).bounds(0.0, 255.0).setter(val -> this.updateColor(Color.withRed(this.color, (int)val))).getter(() -> Color.getRed(this.color))))).child((IWidget)((Row)((Row)((Row)new Row().width(1.0f)).height(12)).child((IWidget)IKey.str("G: ").asWidget().height(1.0f))).child(((SliderWidget)((SliderWidget)((SliderWidget)new SliderWidget().expanded()).height(1.0f)).background(this.sliderBackgroundG.asIcon().size(0, 4))).sliderTexture(handleBackground).sliderSize(2, 8).bounds(0.0, 255.0).setter(val -> this.updateColor(Color.withGreen(this.color, (int)val))).getter(() -> Color.getGreen(this.color))))).child((IWidget)((Row)((Row)((Row)new Row().width(1.0f)).height(12)).child((IWidget)IKey.str("B: ").asWidget().height(1.0f))).child(((SliderWidget)((SliderWidget)((SliderWidget)new SliderWidget().expanded()).height(1.0f)).background(this.sliderBackgroundB.asIcon().size(0, 4))).sliderTexture(handleBackground).sliderSize(2, 8).bounds(0.0, 255.0).setter(val -> this.updateColor(Color.withBlue(this.color, (int)val))).getter(() -> Color.getBlue(this.color))));
        if (this.controlAlpha) {
            parentWidget.child((IWidget)((Row)((Row)((Row)new Row().width(1.0f)).height(12)).child((IWidget)IKey.str("A: ").asWidget().height(1.0f))).child(((SliderWidget)((SliderWidget)((SliderWidget)new SliderWidget().expanded()).height(1.0f)).background(this.sliderBackgroundA.asIcon().size(0, 4))).sliderTexture(handleBackground).sliderSize(2, 8).bounds(0.0, 255.0).setter(val -> this.updateColor(Color.withAlpha(this.color, (int)val))).getter(() -> Color.getAlpha(this.color))));
        }
        return parentWidget;
    }

    private IWidget createHSVPage(GuiContext context) {
        return ((ParentWidget)new ParentWidget().size(1.0f, 1.0f)).child(((TextWidget)IKey.str("WIP").asWidget().size(1.0f, 1.0f)).alignment(Alignment.Center));
    }

    private String validateRawColor(String raw) {
        if (!raw.startsWith("#")) {
            if (raw.startsWith("0x") || raw.startsWith("0X")) {
                raw = raw.substring(2);
            }
            return "#" + raw;
        }
        return raw;
    }

    public void updateColor(int color) {
        this.color = color;
        if (!this.controlAlpha) {
            this.color = Color.withAlpha(this.color, this.alpha);
        }
        color = Color.withAlpha(color, 255);
        int rs = Color.withRed(color, 0);
        int re = Color.withRed(color, 255);
        int gs = Color.withGreen(color, 0);
        int ge = Color.withGreen(color, 255);
        int bs = Color.withBlue(color, 0);
        int be = Color.withBlue(color, 255);
        int as = Color.withAlpha(color, 0);
        int ae = Color.withAlpha(color, 255);
        this.sliderBackgroundR.setHorizontalGradient(rs, re);
        this.sliderBackgroundG.setHorizontalGradient(gs, ge);
        this.sliderBackgroundB.setHorizontalGradient(bs, be);
        this.sliderBackgroundA.setHorizontalGradient(as, ae);
        this.preview.setColor(this.color);
    }
}

