/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.sync.INumberSyncHandler;
import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.Tooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CycleButtonWidget
extends Widget<CycleButtonWidget>
implements Interactable {
    private int length = 1;
    private IntConsumer setter;
    private IntSupplier getter;
    private IntFunction<IDrawable> textureGetter;
    private IDrawable texture = IDrawable.EMPTY;
    private final List<Tooltip> stateTooltip = new ArrayList<Tooltip>();
    private INumberSyncHandler<?> syncHandler;

    @Override
    public void onInit() {
        if (this.textureGetter == null) {
            ModularUI.LOGGER.warn("Texture Getter of {} was not set!", (Object)this);
            this.textureGetter = val -> IDrawable.EMPTY;
        }
        this.texture = this.textureGetter.apply(this.getState());
        for (Tooltip tooltip : this.stateTooltip) {
            if (tooltip == null || tooltip.getExcludeArea() != null || !ModularUIConfig.placeTooltipNextToPanel()) continue;
            tooltip.excludeArea(this.getPanel().getArea());
        }
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof INumberSyncHandler) {
            this.syncHandler = (INumberSyncHandler)((Object)syncHandler);
            return true;
        }
        return false;
    }

    private int getState() {
        if (this.syncHandler != null) {
            return this.syncHandler.getCacheAsInt();
        }
        if (this.getter != null) {
            return this.getter.getAsInt();
        }
        return 0;
    }

    public void next() {
        int state = this.getState();
        if (++state == this.length) {
            state = 0;
        }
        this.setState(state);
    }

    public void prev() {
        int state = this.getState();
        if (--state == -1) {
            state = this.length - 1;
        }
        this.setState(state);
    }

    public void setState(int state) {
        if (state < 0 || state >= this.length) {
            throw new IndexOutOfBoundsException("CycleButton state out of bounds");
        }
        if (this.setter != null) {
            this.setter.accept(state);
        }
        if (this.syncHandler != null) {
            this.syncHandler.updateFromClient(state);
        }
        this.texture = this.textureGetter.apply(state);
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        switch (mouseButton) {
            case 0: {
                this.next();
                Interactable.playButtonClickSound();
                return Interactable.Result.SUCCESS;
            }
            case 1: {
                this.prev();
                Interactable.playButtonClickSound();
                return Interactable.Result.SUCCESS;
            }
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public void draw(GuiContext context) {
        this.texture.applyThemeColor(context.getTheme(), this.getWidgetTheme(context.getTheme()));
        this.texture.draw(context, 0, 0, this.getArea().w(), this.getArea().h());
    }

    @Override
    public boolean hasTooltip() {
        int state = this.getState();
        return super.hasTooltip() || this.stateTooltip.size() > state && !this.stateTooltip.get(state).isEmpty();
    }

    @Override
    public void markDirty() {
        super.markDirty();
        for (Tooltip tooltip : this.stateTooltip) {
            tooltip.markDirty();
        }
        this.texture = this.textureGetter.apply(this.getState());
    }

    @Override
    @Nullable
    public Tooltip getTooltip() {
        Tooltip tooltip = super.getTooltip();
        if (tooltip == null || tooltip.isEmpty()) {
            return this.stateTooltip.get(this.getState());
        }
        return tooltip;
    }

    public CycleButtonWidget setter(IntConsumer setter) {
        this.setter = setter;
        return this;
    }

    public CycleButtonWidget getter(IntSupplier getter) {
        this.getter = getter;
        return this;
    }

    public <T extends Enum<T>> CycleButtonWidget forEnum(Class<T> clazz, Supplier<T> getter, Consumer<T> setter) {
        return this.setter(val -> setter.accept(((Enum[])clazz.getEnumConstants())[val])).getter(() -> ((Enum)getter.get()).ordinal()).length(((Enum[])clazz.getEnumConstants()).length);
    }

    public CycleButtonWidget toggle(BooleanSupplier getter, Consumer<Boolean> setter) {
        return this.setter(val -> setter.accept(val == 1)).getter(() -> getter.getAsBoolean() ? 1 : 0).length(2);
    }

    public CycleButtonWidget textureGetter(IntFunction<IDrawable> textureGetter) {
        this.textureGetter = textureGetter;
        return this;
    }

    public CycleButtonWidget texture(UITexture texture) {
        return this.textureGetter(val -> {
            float a = 1.0f / (float)this.length;
            return texture.getSubArea(0.0f, (float)val * a, 1.0f, (float)val * a + a);
        });
    }

    public CycleButtonWidget addTooltip(int state, IDrawable tooltip) {
        if (state >= this.stateTooltip.size() || state < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.stateTooltip.get(state).addLine(tooltip);
        return this;
    }

    public CycleButtonWidget addTooltip(int state, String tooltip) {
        return this.addTooltip(state, IKey.str(tooltip));
    }

    public CycleButtonWidget length(int length) {
        this.length = length;
        while (this.stateTooltip.size() < this.length) {
            Tooltip tooltip = new Tooltip();
            if (!ModularUIConfig.placeTooltipNextToPanel()) {
                tooltip.excludeArea(this.getArea());
            }
            this.stateTooltip.add(tooltip);
        }
        while (this.stateTooltip.size() > this.length) {
            this.stateTooltip.remove(this.stateTooltip.size() - 1);
        }
        return this;
    }

    public CycleButtonWidget tooltip(int index, Consumer<Tooltip> builder) {
        builder.accept(this.stateTooltip.get(index));
        return this;
    }

    public CycleButtonWidget tooltipBuilder(int index, Consumer<Tooltip> builder) {
        this.stateTooltip.get(index).tooltipBuilder(builder);
        return this;
    }
}

