/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.Tooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.sync.FluidSlotSyncHandler;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.ClickData;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.widget.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSlot
extends Widget<FluidSlot>
implements Interactable {
    private static final IFluidTank EMPTY = new FluidTank(0);
    private final TextRenderer textRenderer = new TextRenderer();
    private FluidSlotSyncHandler syncHandler;
    private int contentOffsetX = 1;
    private int contentOffsetY = 1;
    private boolean alwaysShowFull = true;
    @Nullable
    private IDrawable overlayTexture = null;

    public FluidSlot() {
        this.flex().startDefaultMode().size(18, 18).endDefaultMode();
        this.tooltipBuilder(tooltip -> {
            IFluidTank fluidTank = this.getFluidTank();
            FluidStack fluid = this.syncHandler.getCachedValue();
            if (this.syncHandler.isPhantom()) {
                if (fluid != null) {
                    tooltip.addLine(IKey.str(fluid.getLocalizedName()));
                    if (this.syncHandler.controlsAmount()) {
                        tooltip.addLine(IKey.format("modularui.fluid.phantom.amount", fluid.amount));
                    }
                } else {
                    tooltip.addLine(IKey.format("modularui.fluid.empty", new Object[0]));
                }
                if (this.syncHandler.controlsAmount()) {
                    tooltip.addLine(IKey.format("modularui.fluid.phantom.control", new Object[0]));
                }
            } else {
                if (fluid != null) {
                    tooltip.addLine(IKey.str(fluid.getLocalizedName()));
                    tooltip.addLine(IKey.format("modularui.fluid.amount", fluid.amount, fluidTank.getCapacity()));
                    this.addAdditionalFluidInfo((Tooltip)tooltip, fluid);
                } else {
                    tooltip.addLine(IKey.format("modularui.fluid.empty", new Object[0]));
                }
                if (this.syncHandler.canFillSlot() || this.syncHandler.canDrainSlot()) {
                    tooltip.addLine(IKey.EMPTY);
                    if (Interactable.hasShiftDown()) {
                        if (this.syncHandler.canFillSlot() && this.syncHandler.canDrainSlot()) {
                            tooltip.addLine(IKey.format("modularui.fluid.click_combined", new Object[0]));
                        } else if (this.syncHandler.canDrainSlot()) {
                            tooltip.addLine(IKey.format("modularui.fluid.click_to_fill", new Object[0]));
                        } else if (this.syncHandler.canFillSlot()) {
                            tooltip.addLine(IKey.format("modularui.fluid.click_to_empty", new Object[0]));
                        }
                    } else {
                        tooltip.addLine(IKey.format("modularui.tooltip.shift", new Object[0]));
                    }
                }
            }
        });
    }

    public void addAdditionalFluidInfo(Tooltip tooltip, FluidStack fluidStack) {
    }

    @Override
    public void onInit() {
        this.textRenderer.setShadow(true);
        this.textRenderer.setScale(0.5f);
        this.textRenderer.setColor(Color.WHITE.normal);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof FluidSlotSyncHandler) {
            this.syncHandler = (FluidSlotSyncHandler)syncHandler;
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiContext context) {
        IFluidTank fluidTank = this.getFluidTank();
        FluidStack content = this.syncHandler.getCachedValue();
        if (content != null) {
            int y = this.contentOffsetY;
            float height = this.getArea().height - y * 2;
            if (!this.alwaysShowFull) {
                float newHeight = height * (float)content.amount * 1.0f / (float)fluidTank.getCapacity();
                y = (int)((float)y + (height - newHeight));
                height = newHeight;
            }
            GuiDraw.drawFluidTexture(content, this.contentOffsetX, y, this.getArea().width - this.contentOffsetX * 2, height, 0.0f);
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.draw(context, this.getArea());
        }
        if (content != null && this.syncHandler.controlsAmount()) {
            String s = NumberFormat.format(content.amount);
            this.textRenderer.setAlignment(Alignment.CenterRight, (float)(this.getArea().width - this.contentOffsetX) - 1.0f);
            this.textRenderer.setPos((int)((float)this.contentOffsetX + 0.5f), (int)((float)this.getArea().height - 5.5f));
            this.textRenderer.draw(s);
        }
        if (this.isHovering()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawSolidRect(1.0f, 1.0f, 16.0f, 16.0f, this.getWidgetTheme(context.getTheme()).getSlotHoverColor());
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    public WidgetSlotTheme getWidgetTheme(ITheme theme) {
        return theme.getFluidSlotTheme();
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(int mouseButton) {
        if (!this.syncHandler.canFillSlot() && !this.syncHandler.canDrainSlot()) {
            return Interactable.Result.IGNORE;
        }
        ItemStack cursorStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (this.syncHandler.isPhantom() || !cursorStack.func_190926_b() && cursorStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            ClickData clickData = ClickData.create(mouseButton);
            this.syncHandler.syncToServer(1, clickData::writeToPacket);
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.syncHandler.isPhantom()) {
            if (scrollDirection.isUp() && !this.syncHandler.canFillSlot() || scrollDirection.isDown() && !this.syncHandler.canDrainSlot()) {
                return false;
            }
            ClickData clickData = ClickData.create(scrollDirection.modifier);
            this.syncHandler.syncToServer(2, clickData::writeToPacket);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char typedChar, int keyCode) {
        if (keyCode == 42 || keyCode == 54) {
            this.markDirty();
        }
        return Interactable.super.onKeyPressed(typedChar, keyCode);
    }

    @Override
    public boolean onKeyRelease(char typedChar, int keyCode) {
        if (keyCode == 42 || keyCode == 54) {
            this.markDirty();
        }
        return Interactable.super.onKeyRelease(typedChar, keyCode);
    }

    public IFluidTank getFluidTank() {
        if (this.syncHandler == null) {
            return EMPTY;
        }
        return this.syncHandler.getFluidTank();
    }

    public FluidSlot contentOffset(int x, int y) {
        this.contentOffsetX = x;
        this.contentOffsetY = y;
        return this;
    }

    public FluidSlot alwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    public FluidSlot overlayTexture(@Nullable IDrawable overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }
}

