/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.core.mixin.GuiContainerAccessor;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.TextRenderer;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.sync.ItemSlotSH;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.ClickData;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.widget.Widget;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemSlot
extends Widget<ItemSlot>
implements IVanillaSlot,
Interactable {
    private static final TextRenderer textRenderer = new TextRenderer();
    private ItemSlotSH syncHandler;

    @Override
    public void onInit() {
        this.size(18, 18);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof ItemSlotSH) {
            this.syncHandler = (ItemSlotSH)syncHandler;
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiContext context) {
        if (this.syncHandler == null) {
            return;
        }
        RenderHelper.func_74520_c();
        this.drawSlot(this.getSlot());
        RenderHelper.func_74519_b();
        GlStateManager.func_179140_f();
        if (this.isHovering()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawSolidRect(1.0f, 1.0f, 16.0f, 16.0f, this.getWidgetTheme(context.getTheme()).getSlotHoverColor());
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    public WidgetSlotTheme getWidgetTheme(ITheme theme) {
        return theme.getItemSlotTheme();
    }

    @Override
    public boolean canHover() {
        return true;
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (this.syncHandler.isPhantom()) {
            ClickData clickData = ClickData.create(mouseButton);
            this.syncHandler.syncToServer(2, clickData::writeToPacket);
        } else {
            this.getScreen().getScreenWrapper().clickSlot();
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        this.getScreen().getScreenWrapper().releaseSlot();
        return true;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.syncHandler.isPhantom()) {
            ClickData clickData = ClickData.create(scrollDirection.modifier);
            this.syncHandler.syncToServer(3, clickData::writeToPacket);
            return true;
        }
        return false;
    }

    public Slot getSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    public Slot getVanillaSlot() {
        return this.syncHandler.getSlot();
    }

    @SideOnly(value=Side.CLIENT)
    private void drawSlot(Slot slotIn) {
        GuiScreenWrapper guiScreen = this.getScreen().getScreenWrapper();
        GuiContainerAccessor accessor = guiScreen.getAccessor();
        int x = slotIn.field_75223_e;
        int y = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == accessor.getClickedSlot() && !accessor.getDraggedStack().func_190926_b() && !accessor.getIsRightMouseClick();
        ItemStack itemstack1 = guiScreen.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        int amount = -1;
        String format = null;
        if (slotIn == accessor.getClickedSlot() && !accessor.getDraggedStack().func_190926_b() && accessor.getIsRightMouseClick() && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (guiScreen.isDragSplitting() && guiScreen.getDragSlots().contains(slotIn) && !itemstack1.func_190926_b()) {
            if (guiScreen.getDragSlots().size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && guiScreen.field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(guiScreen.getDragSlots(), (int)accessor.getDragSplittingLimit(), (ItemStack)itemstack, (int)(slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E()));
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    amount = k;
                    format = TextFormatting.YELLOW.toString();
                    itemstack.func_190920_e(k);
                }
            } else {
                guiScreen.getDragSlots().remove(slotIn);
                accessor.invokeUpdateDragSplitting();
            }
        }
        guiScreen.setZ(100.0f);
        guiScreen.getItemRenderer().field_77023_b = 100.0f;
        if (!flag1) {
            if (flag) {
                GuiDraw.drawSolidRect(1.0f, 1.0f, 16.0f, 16.0f, -2130706433);
            }
            if (!itemstack.func_190926_b()) {
                GlStateManager.func_179126_j();
                guiScreen.getItemRenderer().func_184391_a((EntityLivingBase)guiScreen.field_146297_k.field_71439_g, itemstack, 1, 1);
                if (amount < 0) {
                    amount = itemstack.func_190916_E();
                }
                if (amount > 1 || format != null) {
                    String amountText = NumberFormat.format(amount, 2);
                    if (format != null) {
                        amountText = format + amountText;
                    }
                    float scale = 1.0f;
                    if (amountText.length() == 3) {
                        scale = 0.8f;
                    } else if (amountText.length() == 4) {
                        scale = 0.6f;
                    } else if (amountText.length() > 4) {
                        scale = 0.5f;
                    }
                    textRenderer.setShadow(true);
                    textRenderer.setScale(scale);
                    textRenderer.setColor(Color.WHITE.normal);
                    textRenderer.setAlignment(Alignment.BottomRight, this.getArea().width - 1, this.getArea().height - 1);
                    textRenderer.setPos(1, 1);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179084_k();
                    textRenderer.draw(amountText);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179147_l();
                }
                int cachedCount = itemstack.func_190916_E();
                itemstack.func_190920_e(1);
                guiScreen.getItemRenderer().func_180453_a(guiScreen.getFontRenderer(), itemstack, 1, 1, null);
                itemstack.func_190920_e(cachedCount);
                GlStateManager.func_179097_i();
            }
        }
        guiScreen.getItemRenderer().field_77023_b = 0.0f;
        guiScreen.setZ(0.0f);
    }
}

