/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IValueWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.ScrollData;
import com.cleanroommc.modularui.utils.ScrollDirection;
import com.cleanroommc.modularui.widget.ScrollWidget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ListWidget<T, I extends IWidget, W extends ListWidget<T, I, W>>
extends ScrollWidget<W>
implements ILayoutWidget {
    protected final Function<T, I> valueToWidgetMapper;
    protected final Function<I, T> widgetToValueMapper;
    private ScrollData scrollData;
    private boolean keepScrollBarInArea = false;

    public ListWidget() {
        this((T v) -> null, (I w) -> null);
    }

    public ListWidget(Collection<IWidget> widgets) {
        this();
        for (IWidget widget : widgets) {
            this.child(widget);
        }
    }

    public ListWidget(Function<T, I> valueToWidgetMapper, Function<I, T> widgetToValueMapper) {
        this.valueToWidgetMapper = Objects.requireNonNull(valueToWidgetMapper);
        this.widgetToValueMapper = Objects.requireNonNull(widgetToValueMapper);
        this.scrollData = new ScrollData(ScrollDirection.VERTICAL);
        this.getScrollArea().setScrollData(this.scrollData);
    }

    public static <T, V extends IValueWidget<T> & IWidget, W extends ListWidget<T, V, W>> ListWidget<T, V, W> of(Function<T, V> valueToWidgetMapper) {
        return new ListWidget<Object, IValueWidget, W>(valueToWidgetMapper, rec$ -> ((IValueWidget)rec$).getValue());
    }

    public static <T, I extends IWidget, W extends ListWidget<T, I, W>> ListWidget<T, I, W> builder(List<T> list, Function<T, I> creator) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap map_reverse = new Object2ObjectOpenHashMap();
        ListWidget<Object, IWidget, W> listWidget = new ListWidget<Object, IWidget, W>(((Map)map)::get, ((Map)map_reverse)::get);
        for (T t : list) {
            IWidget widget = (IWidget)creator.apply(t);
            map.put(t, widget);
            map_reverse.put(widget, t);
            listWidget.child(widget);
        }
        return listWidget;
    }

    @Override
    public void resize() {
        super.resize();
        if (this.keepScrollBarInArea) {
            return;
        }
        if (this.scrollData.direction == ScrollDirection.VERTICAL) {
            this.getArea().width += this.scrollData.getScrollbarThickness();
        } else {
            this.getArea().height += this.scrollData.getScrollbarThickness();
        }
    }

    public boolean add(T value, int index) {
        if (this.addChild((IWidget)this.valueToWidgetMapper.apply(value), index)) {
            if (this.isValid()) {
                WidgetTree.resize(this);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public IWidget remove(T value) {
        IWidget widget = (IWidget)this.valueToWidgetMapper.apply(value);
        if (this.remove(widget)) {
            return widget;
        }
        return null;
    }

    public List<T> getValues() {
        return this.getChildren().stream().map(widget -> this.widgetToValueMapper.apply(widget)).collect(Collectors.toList());
    }

    @Override
    public void layoutWidgets() {
    }

    @Override
    public void postLayoutWidgets() {
        GuiAxis axis = this.scrollData.direction.axis;
        int p = 0;
        int lastMargin = this.getArea().getPadding().getStart(axis);
        for (IWidget widget : this.getChildren()) {
            if (widget.getFlex() != null && (axis.isVertical() ? widget.getFlex().hasYPos() : widget.getFlex().hasXPos())) continue;
            widget.getArea().setRelativePoint(axis, p += Math.max(lastMargin, widget.getArea().getMargin().getStart(axis)));
            p += widget.getArea().getSize(axis);
            lastMargin = widget.getArea().getMargin().getEnd(axis);
        }
        this.getScrollData().scrollSize = p + Math.max(lastMargin, this.getArea().getPadding().getEnd(axis));
    }

    public ScrollData getScrollData() {
        return this.scrollData;
    }

    public W scrollDirection(ScrollDirection direction) {
        if (this.scrollData.direction != direction) {
            this.scrollData = this.scrollData.copyWith(direction);
            this.getScrollArea().setScrollDataY(null);
            this.getScrollArea().setScrollDataX(null);
            this.getScrollArea().setScrollData(this.scrollData);
        }
        return (W)((ListWidget)this.getThis());
    }

    public W keepScrollBarInArea() {
        this.keepScrollBarInArea = true;
        return (W)((ListWidget)this.getThis());
    }
}

