/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.sync.DoubleSyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import java.util.function.DoubleSupplier;
import net.minecraft.util.math.MathHelper;

public class ProgressWidget
extends Widget<ProgressWidget> {
    private final UITexture[] fullTexture = new UITexture[4];
    private DoubleSupplier progress;
    private UITexture emptyTexture;
    private Direction direction = Direction.RIGHT;
    private int imageSize = -1;
    private DoubleSyncHandler syncHandler;

    @Override
    public void onInit() {
        if (this.direction == Direction.CIRCULAR_CW && this.fullTexture[0] != null) {
            UITexture base = this.fullTexture[0];
            this.fullTexture[0] = base.getSubArea(0.0f, 0.5f, 0.5f, 1.0f);
            this.fullTexture[1] = base.getSubArea(0.0f, 0.0f, 0.5f, 0.5f);
            this.fullTexture[2] = base.getSubArea(0.5f, 0.0f, 1.0f, 0.5f);
            this.fullTexture[3] = base.getSubArea(0.5f, 0.5f, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof DoubleSyncHandler) {
            this.syncHandler = (DoubleSyncHandler)syncHandler;
            return true;
        }
        return false;
    }

    @Override
    public void resize() {
        super.resize();
        if (this.imageSize < 0) {
            this.imageSize = this.getArea().width;
        }
    }

    public float getCurrentProgress() {
        if (this.syncHandler != null) {
            return (float)this.syncHandler.getDoubleValue();
        }
        if (this.progress != null) {
            return (float)this.progress.getAsDouble();
        }
        return 1.0f;
    }

    @Override
    public void draw(GuiContext context) {
        if (this.emptyTexture != null) {
            this.emptyTexture.draw(context, 0, 0, this.getArea().w(), this.getArea().h());
        }
        float progress = this.getCurrentProgress();
        if (this.fullTexture[0] != null && progress > 0.0f) {
            if (this.direction == Direction.CIRCULAR_CW) {
                this.drawCircular(progress);
                return;
            }
            if (progress >= 1.0f) {
                this.fullTexture[0].draw(context, 0, 0, this.getArea().w(), this.getArea().h());
            } else {
                progress = this.getProgressUV(progress);
                float u0 = 0.0f;
                float v0 = 0.0f;
                float u1 = 1.0f;
                float v1 = 1.0f;
                float x = 0.0f;
                float y = 0.0f;
                float width = this.getArea().width;
                float height = this.getArea().height;
                switch (this.direction) {
                    case RIGHT: {
                        u1 = progress;
                        width *= progress;
                        break;
                    }
                    case LEFT: {
                        u0 = 1.0f - progress;
                        x = (float)this.getArea().width - (width *= progress);
                        break;
                    }
                    case DOWN: {
                        v1 = progress;
                        height *= progress;
                        break;
                    }
                    case UP: {
                        v0 = 1.0f - progress;
                        y = (float)this.getArea().height - (height *= progress);
                    }
                }
                this.fullTexture[0].drawSubArea(x, y, width, height, u0, v0, u1, v1);
            }
        }
    }

    public float getProgressUV(float uv) {
        if (ModularUIConfig.smoothProgressBar) {
            return uv;
        }
        return (float)(Math.floor(uv * (float)this.imageSize) / (double)this.imageSize);
    }

    private void drawCircular(float progress) {
        float[] subAreas = new float[]{this.getProgressUV(MathHelper.func_76131_a((float)(progress / 0.25f), (float)0.0f, (float)1.0f)), this.getProgressUV(MathHelper.func_76131_a((float)((progress - 0.25f) / 0.25f), (float)0.0f, (float)1.0f)), this.getProgressUV(MathHelper.func_76131_a((float)((progress - 0.5f) / 0.25f), (float)0.0f, (float)1.0f)), this.getProgressUV(MathHelper.func_76131_a((float)((progress - 0.75f) / 0.25f), (float)0.0f, (float)1.0f))};
        float halfWidth = (float)this.getArea().width / 2.0f;
        float halfHeight = (float)this.getArea().height / 2.0f;
        float progressScaled = subAreas[0] * halfHeight;
        this.fullTexture[0].drawSubArea(0.0f, (float)this.getArea().height - progressScaled, halfWidth, progressScaled, 0.0f, 1.0f - progressScaled / halfHeight, 1.0f, 1.0f);
        progressScaled = subAreas[1] * halfWidth;
        this.fullTexture[1].drawSubArea(0.0f, 0.0f, progressScaled, halfHeight, 0.0f, 0.0f, progressScaled / halfWidth, 1.0f);
        progressScaled = subAreas[2] * halfHeight;
        this.fullTexture[2].drawSubArea(halfWidth, 0.0f, halfWidth, progressScaled, 0.0f, 0.0f, 1.0f, progressScaled / halfHeight);
        progressScaled = subAreas[3] * halfWidth;
        this.fullTexture[3].drawSubArea((float)this.getArea().width - progressScaled, halfHeight, progressScaled, halfHeight, 1.0f - progressScaled / halfWidth, 0.0f, 1.0f, 1.0f);
    }

    public ProgressWidget progress(DoubleSupplier progress) {
        this.progress = progress;
        return this;
    }

    public ProgressWidget progress(double progress) {
        this.progress = () -> progress;
        return this;
    }

    public ProgressWidget texture(UITexture emptyTexture, UITexture fullTexture, int imageSize) {
        this.emptyTexture = emptyTexture;
        this.fullTexture[0] = fullTexture;
        this.imageSize = imageSize;
        return this;
    }

    public ProgressWidget texture(UITexture texture, int imageSize) {
        return this.texture(texture.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), texture.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), imageSize);
    }

    public ProgressWidget direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        CIRCULAR_CW;

    }
}

