/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.sync.DoubleSyncHandler;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.GuiAxis;
import com.cleanroommc.modularui.widget.sizer.Unit;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class SliderWidget
extends Widget<SliderWidget>
implements Interactable {
    private DoubleSupplier getter;
    private DoubleConsumer setter;
    private DoubleSyncHandler syncHandler;
    private IDrawable stopperDrawable;
    private IDrawable handleDrawable;
    private GuiAxis axis;
    private DoubleList stopper;
    private int stopperWidth;
    private int stopperHeight;
    private final Unit sliderWidth;
    private final Unit sliderHeight;
    private final Area sliderArea;
    private double min;
    private double max;
    private boolean dragging;
    private double cache;

    public SliderWidget() {
        this.stopperDrawable = new Rectangle().setColor(Color.withAlpha(Color.WHITE.normal, 0.4f));
        this.handleDrawable = GuiTextures.BUTTON;
        this.axis = GuiAxis.X;
        this.stopperWidth = 2;
        this.stopperHeight = 4;
        this.sliderWidth = new Unit();
        this.sliderHeight = new Unit();
        this.sliderArea = new Area();
        this.dragging = false;
        this.cache = Double.MIN_VALUE;
        this.sliderHeight(1.0f).sliderWidth(6);
        this.listenGuiAction(button -> {
            boolean val = this.dragging;
            this.dragging = false;
            return val;
        });
        this.bounds(0.0, 100.0);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof DoubleSyncHandler) {
            this.syncHandler = (DoubleSyncHandler)syncHandler;
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(GuiContext context) {
        super.drawBackground(context);
        if (this.stopper != null && this.stopperDrawable != null && this.stopperWidth > 0 && this.stopperHeight > 0) {
            DoubleListIterator doubleListIterator = this.stopper.iterator();
            while (doubleListIterator.hasNext()) {
                int crossAxisPos;
                double stop = (Double)doubleListIterator.next();
                int pos = this.valueToPos(stop) + this.sliderArea.getSize(this.axis) / 2;
                if (this.axis.isHorizontal()) {
                    crossAxisPos = (int)((double)this.getArea().height / 2.0 - (double)this.stopperHeight / 2.0);
                    this.stopperDrawable.draw(context, pos -= this.stopperWidth / 2, crossAxisPos, this.stopperWidth, this.stopperHeight);
                    continue;
                }
                crossAxisPos = (int)((double)this.getArea().width / 2.0 - (double)this.stopperWidth / 2.0);
                this.stopperDrawable.draw(context, crossAxisPos, pos -= this.stopperHeight / 2, this.stopperWidth, this.stopperHeight);
            }
        }
    }

    @Override
    public void draw(GuiContext context) {
        if (this.handleDrawable != null) {
            this.handleDrawable.draw(context, this.sliderArea);
        }
    }

    @Override
    public void resize() {
        super.resize();
        float sw = this.sliderWidth.getValue();
        if (this.sliderWidth.isRelative()) {
            sw *= (float)this.getArea().width;
        }
        float sh = this.sliderHeight.getValue();
        if (this.sliderHeight.isRelative()) {
            sh *= (float)this.getArea().height;
        }
        this.sliderArea.setSize((int)sw, (int)sh);
        GuiAxis other = this.axis.getOther();
        this.sliderArea.setPoint(other, this.getArea().getSize(other) / 2 - this.sliderArea.getSize(other) / 2);
    }

    @Override
    public void postResize() {
        this.setValue(this.getValue(), false);
    }

    @Override
    public void onFrameUpdate() {
        if (this.dragging) {
            return;
        }
        double val = this.getValue();
        if (this.cache != val) {
            this.setValue(val, false);
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        int p = this.getContext().getMouse(this.axis) - this.getArea().getPoint(this.axis);
        this.setValue(this.posToValue(p), true);
        this.dragging = true;
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        if (this.dragging) {
            this.onMousePressed(mouseButton);
        }
    }

    public double posToValue(int p) {
        double v = ((double)p - (double)this.sliderArea.getSize(this.axis) / 2.0) / (double)(this.getArea().getSize(this.axis) - this.sliderArea.getSize(this.axis));
        return v * (this.max - this.min) + this.min;
    }

    public int valueToPos(double value) {
        value -= this.min;
        return (int)((value /= this.max - this.min) * (double)(this.getArea().getSize(this.axis) - this.sliderArea.getSize(this.axis)));
    }

    public double getValue() {
        if (this.syncHandler != null) {
            return this.syncHandler.getDoubleValue();
        }
        if (this.getter != null) {
            return this.getter.getAsDouble();
        }
        return (this.max - this.min) / 2.0 + this.min;
    }

    public void setValue(double value, boolean setSource) {
        if (this.stopper != null && !this.stopper.isEmpty()) {
            double lastDistance = Double.MAX_VALUE;
            boolean found = false;
            for (int i = 0; i < this.stopper.size(); ++i) {
                double dist = Math.abs((Double)this.stopper.get(i) - value);
                if (dist < lastDistance) {
                    lastDistance = dist;
                    continue;
                }
                if (!(dist > lastDistance)) continue;
                value = (Double)this.stopper.get(i - 1);
                found = true;
                break;
            }
            if (!found && lastDistance < Double.MAX_VALUE) {
                value = (Double)this.stopper.get(this.stopper.size() - 1);
            }
        }
        this.cache = value = MathHelper.func_151237_a((double)value, (double)this.min, (double)this.max);
        this.sliderArea.setPoint(this.axis, this.valueToPos(value));
        if (setSource) {
            if (this.syncHandler != null) {
                this.syncHandler.updateFromClient(value);
            } else if (this.setter != null) {
                this.setter.accept(value);
            }
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public String toString() {
        return super.toString() + " # " + this.getValue();
    }

    public SliderWidget getter(DoubleSupplier getter) {
        this.getter = getter;
        return this;
    }

    public SliderWidget setter(DoubleConsumer setter) {
        this.setter = setter;
        return this;
    }

    public SliderWidget bounds(double min, double max) {
        this.max = Math.max(min, max);
        this.min = Math.min(min, max);
        return this;
    }

    public SliderWidget stopper(DoubleList stopper) {
        if (this.stopper == null) {
            this.stopper = new DoubleArrayList();
        }
        this.stopper.addAll(stopper);
        this.stopper.sort(Double::compare);
        return this;
    }

    public SliderWidget stopper(double ... stopper) {
        if (this.stopper == null) {
            this.stopper = new DoubleArrayList();
        }
        for (double stop : stopper) {
            this.stopper.add(stop);
        }
        this.stopper.sort(Double::compare);
        return this;
    }

    public SliderWidget setAxis(GuiAxis axis) {
        this.axis = axis;
        return this;
    }

    public SliderWidget sliderWidth(int w) {
        this.sliderWidth.setValue(w);
        this.sliderWidth.setMeasure(Unit.Measure.PIXEL);
        return this;
    }

    public SliderWidget sliderWidth(float w) {
        this.sliderWidth.setValue(w);
        this.sliderWidth.setMeasure(Unit.Measure.RELATIVE);
        return this;
    }

    public SliderWidget sliderHeight(int h) {
        this.sliderHeight.setValue(h);
        this.sliderHeight.setMeasure(Unit.Measure.PIXEL);
        return this;
    }

    public SliderWidget sliderHeight(float h) {
        this.sliderHeight.setValue(h);
        this.sliderHeight.setMeasure(Unit.Measure.RELATIVE);
        return this;
    }

    public SliderWidget sliderSize(int w, int h) {
        return this.sliderWidth(w).sliderHeight(h);
    }

    public SliderWidget sliderSize(float w, float h) {
        return this.sliderWidth(w).sliderHeight(h);
    }

    public SliderWidget sliderTexture(IDrawable sliderTexture) {
        this.handleDrawable = sliderTexture;
        return this;
    }

    public SliderWidget stopperTexture(IDrawable sliderTexture) {
        this.stopperDrawable = sliderTexture;
        return this;
    }

    public SliderWidget stopperSize(int w, int h) {
        this.stopperWidth = w;
        this.stopperHeight = h;
        return this;
    }
}

