/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.layout.CrossAxisAlignment;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.layout.MainAxisAlignment;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Box;

public class Column
extends ParentWidget<Column>
implements ILayoutWidget {
    private MainAxisAlignment maa = MainAxisAlignment.START;
    private CrossAxisAlignment caa = CrossAxisAlignment.CENTER;

    public Column() {
        this.flex().startDefaultMode().size(1.0f, 1.0f).endDefaultMode();
    }

    @Override
    public void layoutWidgets() {
        int height = this.getArea().height;
        int width = this.getArea().width;
        Box padding = this.getArea().getPadding();
        int maxWidth = 0;
        int totalHeight = 0;
        int expandedAmount = 0;
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasYPos()) continue;
            maxWidth = Math.max(maxWidth, widget.getArea().requestedWidth());
            if (widget.flex().isExpanded()) {
                ++expandedAmount;
                totalHeight += widget.getArea().getMargin().vertical();
                continue;
            }
            totalHeight += widget.getArea().requestedHeight();
        }
        if (expandedAmount > 0) {
            int newHeight = (height - totalHeight) / expandedAmount;
            for (IWidget widget : this.getChildren()) {
                if (widget.flex().hasYPos() || !widget.flex().isExpanded()) continue;
                widget.getArea().h(newHeight);
            }
        }
        int lastY = 0;
        if (this.maa == MainAxisAlignment.CENTER) {
            lastY = (int)((float)height / 2.0f - (float)totalHeight / 2.0f);
        } else if (this.maa == MainAxisAlignment.END) {
            lastY = height - totalHeight;
        }
        lastY = Math.max(lastY, padding.top) - this.getArea().getMargin().top;
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasYPos()) continue;
            Box margin = widget.getArea().getMargin();
            if (!widget.flex().hasXPos()) {
                int x = 0;
                if (this.caa == CrossAxisAlignment.CENTER) {
                    x = (int)((float)width / 2.0f - (float)widget.getArea().requestedWidth() / 2.0f);
                } else if (this.caa == CrossAxisAlignment.END) {
                    x = width - widget.getArea().requestedWidth();
                }
                widget.getArea().rx = x = Math.max(x, padding.left + margin.left);
            }
            widget.getArea().ry = lastY + margin.top;
            lastY += widget.getArea().requestedHeight();
            if (this.maa != MainAxisAlignment.SPACE_BETWEEN) continue;
            lastY += (height - totalHeight) / (this.getChildren().size() - 1);
        }
    }

    public Column crossAxisAlignment(CrossAxisAlignment caa) {
        this.caa = caa;
        return this;
    }

    public Column mainAxisAlignment(MainAxisAlignment maa) {
        this.maa = maa;
        return this;
    }
}

