/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.ScrollData;
import com.cleanroommc.modularui.utils.ScrollDirection;
import com.cleanroommc.modularui.widget.ScrollWidget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Box;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Grid
extends ScrollWidget<Grid>
implements ILayoutWidget {
    private final List<List<IWidget>> matrix = new ArrayList<List<IWidget>>();
    private final Box minElementMargin = new Box();
    private int minRowHeight = 5;
    private int minColWidth = 5;
    private boolean dirty = false;

    public Grid() {
        this.minElementMargin.all(2);
    }

    @Override
    public void onInit() {
        super.onInit();
        int maxRowSize = 0;
        for (List<IWidget> row : this.matrix) {
            maxRowSize = Math.max(maxRowSize, row.size());
        }
        for (List<IWidget> row : this.matrix) {
            while (row.size() < maxRowSize) {
                row.add(null);
            }
        }
    }

    private int getElementWidth(Area area) {
        return area.width + Math.max(area.getMargin().left, this.minElementMargin.left) + Math.max(area.getMargin().right, this.minElementMargin.right);
    }

    private int getElementHeight(Area area) {
        return area.height + Math.max(area.getMargin().top, this.minElementMargin.top) + Math.max(area.getMargin().bottom, this.minElementMargin.bottom);
    }

    @Override
    public void layoutWidgets() {
        IntArrayList rowSizes = new IntArrayList();
        IntArrayList colSizes = new IntArrayList();
        int i = 0;
        for (List<IWidget> row : this.matrix) {
            int j = 0;
            rowSizes.add(this.minRowHeight);
            for (IWidget child : row) {
                if (i == 0) {
                    colSizes.add(this.minColWidth);
                }
                if (child != null) {
                    rowSizes.set(i, Math.max(rowSizes.getInt(i), this.getElementHeight(child.getArea())));
                    colSizes.set(j, Math.max(colSizes.getInt(j), this.getElementWidth(child.getArea())));
                }
                ++j;
            }
            ++i;
        }
        int x = 0;
        int y = 0;
        for (int r = 0; r < rowSizes.size(); ++r) {
            x = 0;
            int height = (Integer)rowSizes.get(r);
            for (int c = 0; c < colSizes.size(); ++c) {
                int width = (Integer)colSizes.get(c);
                IWidget child = this.matrix.get(r).get(c);
                if (child != null) {
                    child.getArea().rx = (int)((double)x + (double)width * 0.5 - (double)child.getArea().width * 0.5);
                    child.getArea().ry = (int)((double)y + (double)height * 0.5 - (double)child.getArea().height * 0.5);
                }
                x += width;
            }
            y += height;
        }
        if (this.getScrollArea().getScrollX() != null) {
            this.getScrollArea().getScrollX().scrollSize = x;
        }
        if (this.getScrollArea().getScrollY() != null) {
            this.getScrollArea().getScrollY().scrollSize = y;
        }
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        if (this.dirty) {
            this.makeFlatList();
            this.dirty = false;
        }
        return super.getChildren();
    }

    private void makeFlatList() {
        super.getChildren().clear();
        super.getChildren().addAll(this.matrix.stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public int getDefaultHeight() {
        int h = 0;
        for (List<IWidget> row : this.matrix) {
            int rowHeight = 0;
            for (IWidget child : row) {
                if (child == null) continue;
                rowHeight = Math.max(rowHeight, this.getElementHeight(child.getArea()));
            }
            h += Math.min(rowHeight, this.minRowHeight);
        }
        return h;
    }

    @Override
    public int getDefaultWidth() {
        IntArrayList colSizes = new IntArrayList();
        int i = 0;
        for (List<IWidget> row : this.matrix) {
            int j = 0;
            for (IWidget child : row) {
                if (i == 0) {
                    colSizes.add(this.minColWidth);
                }
                if (child != null) {
                    colSizes.set(j, Math.max(colSizes.getInt(j), this.getElementWidth(child.getArea())));
                }
                ++j;
            }
            ++i;
        }
        int w = 0;
        IntListIterator intListIterator = colSizes.iterator();
        while (intListIterator.hasNext()) {
            int colWidth = (Integer)intListIterator.next();
            w += colWidth;
        }
        return w;
    }

    public <I extends IWidget> Grid matrix(List<List<I>> matrix) {
        this.matrix.clear();
        for (List<I> row : matrix) {
            this.matrix.add(row);
        }
        this.dirty = true;
        return this;
    }

    public Grid row(List<IWidget> row) {
        this.matrix.add(row);
        this.dirty = true;
        return this;
    }

    public Grid row(IWidget ... row) {
        ArrayList<IWidget> list = new ArrayList<IWidget>();
        Collections.addAll(list, row);
        return this.row(list);
    }

    @Override
    public boolean addChild(IWidget child, int index) {
        if (child == this || this.getChildren().contains(child)) {
            return false;
        }
        if (index < 0) {
            index = this.getChildren().size() + index + 1;
        }
        super.getChildren().add(index, child);
        if (this.isValid()) {
            child.initialise(this);
        }
        this.onChildAdd(child);
        this.dirty = true;
        return true;
    }

    @Override
    public Grid child(@Nullable IWidget widget) {
        this.matrix.get(this.matrix.size() - 1).add(widget);
        this.dirty = true;
        return this;
    }

    public Grid nextRow() {
        this.matrix.add(new ArrayList());
        return this;
    }

    public <T, I extends IWidget> Grid mapTo(int rowLength, List<T> collection, IndexedElementMapper<T, I> widgetCreator) {
        return this.matrix(Grid.mapToMatrix(rowLength, collection, widgetCreator));
    }

    public Grid minColWidth(int minColWidth) {
        this.minColWidth = minColWidth;
        return this;
    }

    public Grid minRowHeight(int minRowHeight) {
        this.minRowHeight = minRowHeight;
        return this;
    }

    public Grid scrollable() {
        return this.scrollable(new ScrollData(ScrollDirection.VERTICAL), new ScrollData(ScrollDirection.HORIZONTAL));
    }

    public Grid scrollable(ScrollDirection direction) {
        return this.scrollable(new ScrollData(direction));
    }

    public Grid scrollable(ScrollData data) {
        this.getScrollArea().setScrollData(data);
        return this;
    }

    public Grid scrollable(ScrollData data1, ScrollData data2) {
        this.getScrollArea().setScrollData(data1);
        this.getScrollArea().setScrollData(data2);
        return this;
    }

    public Grid minElementMargin(int left, int right, int top, int bottom) {
        this.minElementMargin.all(left, right, top, bottom);
        return (Grid)this.getThis();
    }

    public Grid minElementMargin(int horizontal, int vertical) {
        this.minElementMargin.all(horizontal, vertical);
        return (Grid)this.getThis();
    }

    @Override
    public Grid margin(int all) {
        this.minElementMargin.all(all);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginLeft(int val) {
        this.minElementMargin.left(val);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginRight(int val) {
        this.minElementMargin.right(val);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginTop(int val) {
        this.minElementMargin.top(val);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginBottom(int val) {
        this.minElementMargin.bottom(val);
        return (Grid)this.getThis();
    }

    public static <T, I extends IWidget> List<List<I>> mapToMatrix(int rowLength, List<T> collection, IndexedElementMapper<T, I> widgetCreator) {
        ArrayList<List<I>> matrix = new ArrayList<List<I>>();
        for (int i = 0; i < collection.size(); ++i) {
            List<I> row;
            int r = i / rowLength;
            if (matrix.size() <= r) {
                row = new ArrayList();
                matrix.add(row);
            } else {
                row = (List)matrix.get(r);
            }
            row.add(widgetCreator.apply(i, collection.get(i)));
        }
        return matrix;
    }

    public static interface IndexedElementMapper<T, I> {
        public I apply(int var1, T var2);
    }
}

