/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.layout.CrossAxisAlignment;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.layout.MainAxisAlignment;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.sizer.Box;

public class Row
extends ParentWidget<Row>
implements ILayoutWidget {
    private MainAxisAlignment maa = MainAxisAlignment.START;
    private CrossAxisAlignment caa = CrossAxisAlignment.START;

    public Row() {
        this.flex().startDefaultMode().size(1.0f, 1.0f).endDefaultMode();
    }

    @Override
    public void layoutWidgets() {
        int width = this.getArea().width;
        int height = this.getArea().height;
        Box padding = this.getArea().getPadding();
        int maxHeight = 0;
        int totalWidth = 0;
        int expandedAmount = 0;
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasXPos()) continue;
            maxHeight = Math.max(maxHeight, widget.getArea().requestedHeight());
            if (widget.flex().isExpanded()) {
                ++expandedAmount;
                totalWidth += widget.getArea().getMargin().horizontal();
                continue;
            }
            totalWidth += widget.getArea().requestedWidth();
        }
        if (expandedAmount > 0) {
            int newWidth = (width - totalWidth) / expandedAmount;
            for (IWidget widget : this.getChildren()) {
                if (widget.flex().hasXPos() || !widget.flex().isExpanded()) continue;
                widget.getArea().w(newWidth);
            }
        }
        int lastX = 0;
        if (this.maa == MainAxisAlignment.CENTER) {
            lastX = (int)((float)width / 2.0f - (float)totalWidth / 2.0f);
        } else if (this.maa == MainAxisAlignment.END) {
            lastX = width - totalWidth;
        }
        lastX = Math.max(lastX, padding.left) - this.getArea().getMargin().left;
        for (IWidget widget : this.getChildren()) {
            if (widget.flex().hasXPos()) continue;
            Box margin = widget.getArea().getMargin();
            if (!widget.flex().hasYPos()) {
                int y = 0;
                if (this.caa == CrossAxisAlignment.CENTER) {
                    y = (int)((float)height / 2.0f - (float)widget.getArea().requestedHeight() / 2.0f);
                } else if (this.caa == CrossAxisAlignment.END) {
                    y = height - widget.getArea().requestedHeight();
                }
                widget.getArea().ry = y = Math.max(y, padding.top);
            }
            widget.getArea().rx = lastX + margin.left;
            lastX += widget.getArea().requestedWidth();
            if (this.maa != MainAxisAlignment.SPACE_BETWEEN) continue;
            lastX += (width - totalWidth) / (this.getChildren().size() - 1);
        }
    }

    public Row crossAxisAlignment(CrossAxisAlignment caa) {
        this.caa = caa;
        return this;
    }

    public Row mainAxisAlignment(MainAxisAlignment maa) {
        this.maa = maa;
        return this;
    }
}

