/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.slot;

import com.cleanroommc.modularui.api.SlotAccessor;
import com.cleanroommc.modularui.core.mixin.SlotAccessorClient;
import com.cleanroommc.modularui.widgets.slot.ICustomSlot;
import java.util.Objects;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotDelegate
extends Slot
implements ICustomSlot {
    private boolean enabled = true;
    private final Slot slot;

    public static SlotDelegate create(Slot slot) {
        return SlotDelegate.create(slot, false);
    }

    public static SlotDelegate create(Slot slot, boolean force) {
        Objects.requireNonNull(slot);
        if (force) {
            return new SlotDelegate(slot);
        }
        Slot delegated = slot;
        while (delegated instanceof SlotDelegate) {
            delegated = ((SlotDelegate)delegated).getDelegate();
        }
        SlotDelegate newDelegate = new SlotDelegate(delegated);
        newDelegate.field_75223_e = slot.field_75223_e;
        newDelegate.field_75221_f = slot.field_75221_f;
        return newDelegate;
    }

    private SlotDelegate(Slot slot) {
        super(slot.field_75224_c, slot.field_75222_d, slot.field_75223_e, slot.field_75221_f);
        this.slot = slot;
    }

    public void func_75220_a(@NotNull ItemStack p_75220_1_, @NotNull ItemStack p_75220_2_) {
        this.slot.func_75220_a(p_75220_1_, p_75220_2_);
    }

    protected void func_75210_a(@NotNull ItemStack stack, int amount) {
        ((SlotAccessor)this.slot).invokeOnCrafting(stack, amount);
    }

    protected void func_190900_b(int p_190900_1_) {
        ((SlotAccessor)this.slot).invokeOnSwapCraft(p_190900_1_);
    }

    protected void func_75208_c(@NotNull ItemStack stack) {
        ((SlotAccessor)this.slot).invokeOnCrafting(stack);
    }

    @NotNull
    public ItemStack func_190901_a(@NotNull EntityPlayer thePlayer, @NotNull ItemStack stack) {
        return this.slot.func_190901_a(thePlayer, stack);
    }

    public boolean func_75214_a(@NotNull ItemStack stack) {
        return this.slot.func_75214_a(stack);
    }

    @NotNull
    public ItemStack func_75211_c() {
        return this.slot.func_75211_c();
    }

    public boolean func_75216_d() {
        return this.slot.func_75216_d();
    }

    public void func_75215_d(@NotNull ItemStack stack) {
        this.slot.func_75215_d(stack);
    }

    public void func_75218_e() {
        this.slot.func_75218_e();
    }

    public int func_75219_a() {
        return this.slot.func_75219_a();
    }

    public int func_178170_b(@NotNull ItemStack stack) {
        return this.slot.func_178170_b(stack);
    }

    @Nullable
    public String func_178171_c() {
        return this.slot.func_178171_c();
    }

    @NotNull
    public ItemStack func_75209_a(int amount) {
        return this.slot.func_75209_a(amount);
    }

    public boolean func_75217_a(@NotNull IInventory inv, int slotIn) {
        return this.slot.func_75217_a(inv, slotIn);
    }

    public boolean func_82869_a(@NotNull EntityPlayer playerIn) {
        return this.slot.func_82869_a(playerIn);
    }

    public boolean func_111238_b() {
        return this.enabled && this.slot.func_111238_b();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public ResourceLocation getBackgroundLocation() {
        return this.slot.getBackgroundLocation();
    }

    public void setBackgroundLocation(@NotNull ResourceLocation texture) {
        this.slot.setBackgroundLocation(texture);
    }

    public void setBackgroundName(@Nullable String name) {
        this.slot.setBackgroundName(name);
    }

    @Nullable
    public TextureAtlasSprite getBackgroundSprite() {
        return this.slot.getBackgroundSprite();
    }

    @NotNull
    protected TextureMap getBackgroundMap() {
        return ((SlotAccessorClient)this.slot).invokeGetBackgroundMap();
    }

    public int getSlotIndex() {
        return this.slot.getSlotIndex();
    }

    public boolean isSameInventory(@NotNull Slot other) {
        return this.slot.isSameInventory(other);
    }

    public Slot getDelegate() {
        return this.slot;
    }
}

