/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.IValue;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.sync.IStringSyncHandler;
import com.cleanroommc.modularui.api.sync.SyncHandler;
import com.cleanroommc.modularui.api.sync.ValueSyncHandler;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.math.Constant;
import com.cleanroommc.modularui.utils.math.MathBuilder;
import com.cleanroommc.modularui.widgets.textfield.BaseTextFieldWidget;
import java.awt.Point;
import java.text.ParsePosition;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWidget
extends BaseTextFieldWidget<TextFieldWidget> {
    private IStringSyncHandler<?> syncHandler;
    private Function<String, String> validator = val -> val;
    @Nullable
    private Supplier<String> getter;
    @Nullable
    private Consumer<String> setter;
    protected boolean changedMarkedColor = false;

    public static IValue parse(String num) {
        try {
            return MathBuilder.INSTANCE.parse(num);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Constant(0.0);
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        if (this.getter != null) {
            this.setText(this.getter.get());
        }
        if (!this.hasTooltip()) {
            this.tooltip().excludeArea(this.getArea());
            this.tooltipBuilder(tooltip -> tooltip.addLine(IKey.str(this.getText())));
        }
        if (!this.changedMarkedColor) {
            this.renderer.setMarkedColor(this.getWidgetTheme(this.getContext().getTheme()).getMarkedColor());
        }
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        if (syncHandler instanceof IStringSyncHandler && syncHandler instanceof ValueSyncHandler) {
            this.syncHandler = (IStringSyncHandler)((Object)syncHandler);
            ((ValueSyncHandler)((Object)this.syncHandler)).setChangeListener(() -> {
                this.markDirty();
                this.setText(this.syncHandler.getCachedValue().toString());
            });
            return true;
        }
        return false;
    }

    @Override
    public void onFrameUpdate() {
        super.onFrameUpdate();
        if (!this.isFocused() && this.getter != null) {
            String s = this.getter.get();
            if (!this.getText().equals(s)) {
                this.setText(s);
            }
        }
    }

    @Override
    public void drawText(GuiContext context) {
        this.renderer.setSimulate(false);
        this.renderer.setPos(this.getArea().getPadding().left, 0);
        this.renderer.setScale(this.scale);
        this.renderer.setAlignment(this.textAlignment, -1.0f, this.getArea().height);
        this.renderer.draw(this.handler.getText());
        this.getScrollData().scrollSize = Math.max(0, (int)this.renderer.getLastWidth());
    }

    @Override
    public void drawForeground(GuiContext context) {
        if (this.hasTooltip() && this.getScrollData().isScrollBarActive(this.getScrollArea()) && this.isHoveringFor(this.getTooltip().getShowUpTimer())) {
            this.getTooltip().draw(this.getContext());
        }
    }

    @NotNull
    public String getText() {
        if (this.handler.getText().isEmpty()) {
            return "";
        }
        if (this.handler.getText().size() > 1) {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        return this.handler.getText().get(0);
    }

    public void setText(@NotNull String text) {
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(text);
        } else {
            this.handler.getText().set(0, text);
        }
    }

    @Override
    public void onFocus(GuiContext context) {
        super.onFocus(context);
        Point main = this.handler.getMainCursor();
        if (main.x == 0) {
            this.handler.setCursor(main.y, this.getText().length(), true, true);
        }
    }

    @Override
    public void onRemoveFocus(GuiContext context) {
        super.onRemoveFocus(context);
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(this.validator.apply(""));
        } else if (this.handler.getText().size() == 1) {
            this.handler.getText().set(0, this.validator.apply(this.handler.getText().get(0)));
            this.markDirty();
        } else {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        if (this.syncHandler != null) {
            if (this.syncHandler.getCachedValue() instanceof Number) {
                this.syncHandler.updateFromClient(format.parse(this.getText(), new ParsePosition(0)).toString());
            } else {
                this.syncHandler.updateFromClient(this.getText());
            }
        }
        if (this.setter != null) {
            this.setter.accept(this.getText());
        }
    }

    @Override
    public boolean canHover() {
        return true;
    }

    public TextFieldWidget setMaxLength(int maxLength) {
        this.handler.setMaxCharacters(maxLength);
        return this;
    }

    public TextFieldWidget setPattern(Pattern pattern) {
        this.handler.setPattern(pattern);
        return this;
    }

    @Override
    public TextFieldWidget setTextColor(int textColor) {
        this.renderer.setColor(textColor);
        this.changedTextColor = true;
        return this;
    }

    public TextFieldWidget setMarkedColor(int color) {
        this.renderer.setMarkedColor(color);
        this.changedMarkedColor = true;
        return this;
    }

    public TextFieldWidget setValidator(Function<String, String> validator) {
        this.validator = validator;
        return this;
    }

    public TextFieldWidget setNumbersLong(Function<Long, Long> validator) {
        this.setValidator(val -> {
            long num = val.isEmpty() ? 0L : (long)TextFieldWidget.parse(val).doubleValue();
            return format.format(validator.apply(num));
        });
        return this;
    }

    public TextFieldWidget setNumbers(Function<Integer, Integer> validator) {
        return this.setValidator(val -> {
            int num = val.isEmpty() ? 0 : (int)TextFieldWidget.parse(val).doubleValue();
            return format.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbersDouble(Function<Double, Double> validator) {
        return this.setValidator(val -> {
            double num = val.isEmpty() ? 0.0 : TextFieldWidget.parse(val).doubleValue();
            return format.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbers(Supplier<Integer> min, Supplier<Integer> max) {
        return this.setNumbers(val -> Math.min((Integer)max.get(), Math.max((Integer)min.get(), val)));
    }

    public TextFieldWidget setNumbersLong(Supplier<Long> min, Supplier<Long> max) {
        return this.setNumbersLong(val -> Math.min((Long)max.get(), Math.max((Long)min.get(), val)));
    }

    public TextFieldWidget setNumbers(int min, int max) {
        return this.setNumbers(val -> Math.min(max, Math.max(min, val)));
    }

    public TextFieldWidget getter(Supplier<String> getter) {
        this.getter = getter;
        return this;
    }

    public TextFieldWidget setter(Consumer<String> setter) {
        this.setter = setter;
        return this;
    }

    public TextFieldWidget getterLong(LongSupplier getter) {
        this.getter = () -> String.valueOf(getter.getAsLong());
        return this;
    }

    public TextFieldWidget setterLong(LongConsumer setter) {
        this.setter = val -> {
            try {
                setter.accept(Long.parseLong(val));
            }
            catch (NumberFormatException e) {
                ModularUI.LOGGER.catching((Throwable)e);
                setter.accept(0L);
            }
        };
        return this;
    }

    public TextFieldWidget getterDouble(DoubleSupplier getter) {
        this.getter = () -> String.valueOf(getter.getAsDouble());
        return this;
    }

    public TextFieldWidget setterDouble(DoubleConsumer setter) {
        this.setter = val -> {
            try {
                setter.accept(Double.parseDouble(val));
            }
            catch (NumberFormatException e) {
                ModularUI.LOGGER.catching((Throwable)e);
                setter.accept(0.0);
            }
        };
        return this;
    }
}

