/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.brackethandler;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.zenscript.IBracketHandler;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCTextureArea;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.ITextureArea;
import eutros.multiblocktweaker.helper.ReflectionHelper;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextureArea;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class GuiTextureBracketHandler
implements IBracketHandler {
    public static final Map<String, ITextureArea> cache = new HashMap<String, ITextureArea>();
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(GuiTextureBracketHandler.class, (String)"get", (Class[])new Class[]{String.class});

    public static ITextureArea get(String member) {
        if (!cache.containsKey(member)) {
            TextureArea textureArea = (TextureArea)ReflectionHelper.getStatic(GuiTextures.class, member);
            if (textureArea == null) {
                cache.put(member, ITextureArea.fullImage(member));
            } else {
                cache.put(member, new MCTextureArea(textureArea));
            }
        }
        return cache.get(member);
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        if (!tokens.get(0).getValue().equalsIgnoreCase("texture_area")) {
            return null;
        }
        if (!tokens.get(1).getValue().equals(":")) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            nameBuilder.append(tokens.get(i).getValue());
        }
        return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, nameBuilder.toString())});
    }
}

