/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.construction;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import eutros.multiblocktweaker.crafttweaker.gtwrap.constants.ConstantRelativeDirection;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCBlockPattern;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IBlockPattern;
import eutros.multiblocktweaker.crafttweaker.predicate.CTTraceabilityPredicate;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.util.RelativeDirection;
import java.util.Arrays;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.multiblock.FactoryBlockPattern")
@ZenRegister
public class BlockPatternBuilder {
    private FactoryBlockPattern delegate;

    public BlockPatternBuilder(FactoryBlockPattern delegate) {
        this.delegate = delegate;
    }

    @ZenMethod
    public static BlockPatternBuilder start() {
        return new BlockPatternBuilder(FactoryBlockPattern.start());
    }

    @ZenMethod
    public static BlockPatternBuilder start(ConstantRelativeDirection charDir, ConstantRelativeDirection stringDir, ConstantRelativeDirection aisleDir) {
        return new BlockPatternBuilder(FactoryBlockPattern.start((RelativeDirection)charDir.val, (RelativeDirection)stringDir.val, (RelativeDirection)aisleDir.val));
    }

    @ZenMethod
    public BlockPatternBuilder aisleRepeatable(int minRepeat, int maxRepeat, String ... aisle) {
        this.delegate = this.delegate.aisleRepeatable(minRepeat, maxRepeat, aisle);
        return this;
    }

    @ZenMethod
    public BlockPatternBuilder aisleRepeatable(int repeats, String ... aisle) {
        return this.aisleRepeatable(repeats, repeats, aisle);
    }

    @ZenMethod
    public BlockPatternBuilder aisle(String ... aisle) {
        this.delegate = this.delegate.aisle(aisle);
        return this;
    }

    @ZenMethod
    public BlockPatternBuilder setRepeatable(int minRepeat, int maxRepeat) {
        this.delegate = this.delegate.setRepeatable(minRepeat, maxRepeat);
        return this;
    }

    @ZenMethod
    public BlockPatternBuilder setRepeatable(int repeatCount) {
        this.delegate = this.delegate.setRepeatable(repeatCount);
        return this;
    }

    @ZenMethod
    public BlockPatternBuilder where(String symbol, CTTraceabilityPredicate predicate) {
        if (symbol.length() != 1) {
            CraftTweakerAPI.logError((String)"Symbol given is not a single character!");
            return this;
        }
        this.delegate = this.delegate.where(symbol.charAt(0), predicate.toInternal());
        return this;
    }

    @ZenMethod
    public BlockPatternBuilder whereOr(String symbol, CTTraceabilityPredicate first, CTTraceabilityPredicate ... predicates) {
        if (symbol.length() != 1) {
            CraftTweakerAPI.logError((String)"Symbol given is not a single character!");
            return this;
        }
        this.delegate = this.delegate.where(symbol.charAt(0), Arrays.stream(predicates).reduce(first, CTTraceabilityPredicate::or).toInternal());
        return this;
    }

    @ZenMethod
    public IBlockPattern build() {
        return new MCBlockPattern(this.delegate.build());
    }
}

