/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.construction;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IFacing;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCBlockInfo;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCMultiblockShapeInfo;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IBlockInfo;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IMetaTileEntity;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IMultiblockShapeInfo;
import gregtech.api.pattern.MultiblockShapeInfo;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.multiblock.FactoryMultiblockShapeInfo")
@ZenRegister
public class MultiblockShapeInfoBuilder {
    private MultiblockShapeInfo.Builder inner = MultiblockShapeInfo.builder();
    private final Map<Character, MCBlockInfo.ControllerInfo> proxyMetaTileEntity = new Char2ObjectOpenHashMap();

    @ZenMethod
    public static MultiblockShapeInfoBuilder start() {
        return new MultiblockShapeInfoBuilder();
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder aisle(String ... data) {
        this.inner = this.inner.aisle(data);
        return this;
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder aisleRepeated(int count, String ... data) {
        for (int i = 0; i < count; ++i) {
            this.inner = this.inner.aisle(data);
        }
        return this;
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder where(String symbol, IBlockInfo value) {
        char c = this.getSymbol(symbol);
        if (c != '\u0000') {
            if (value instanceof MCBlockInfo.ControllerInfo) {
                this.proxyMetaTileEntity.put(Character.valueOf(c), (MCBlockInfo.ControllerInfo)value);
            } else {
                this.inner = this.inner.where(c, value.getInternal());
            }
        }
        return this;
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder where(String symbol, IBlock block) {
        Block blocc = CraftTweakerMC.getBlock((IBlockDefinition)block.getDefinition());
        char c = this.getSymbol(symbol);
        if (c != '\u0000') {
            this.inner = this.inner.where(c, blocc.func_176223_P());
        }
        return this;
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder where(String symbol, IItemStack stack) {
        return this.where(symbol, stack.asBlock());
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder where(String symbol, IBlockState blockState) {
        char c = this.getSymbol(symbol);
        if (c != '\u0000') {
            this.inner = this.inner.where(c, CraftTweakerMC.getBlockState((IBlockState)blockState));
        }
        return this;
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder where(String symbol, ILiquidStack liquidStack) {
        return this.where(symbol, liquidStack.getDefinition().getBlock());
    }

    @ZenMethod
    public MultiblockShapeInfoBuilder where(String symbol, IMetaTileEntity te, IFacing frontSide) {
        char c = this.getSymbol(symbol);
        if (c != '\u0000') {
            this.inner = this.inner.where(c, te.getInternal(), (EnumFacing)frontSide.getInternal());
        }
        return this;
    }

    @ZenMethod
    public IMultiblockShapeInfo build() {
        this.proxyMetaTileEntity.forEach((k, v) -> this.inner.where(k.charValue(), v.copy().getInternal()));
        return new MCMultiblockShapeInfo(this.inner.build());
    }

    private char getSymbol(String symbol) {
        if (symbol.length() != 1) {
            CraftTweakerAPI.logError((String)"Symbol given is not a single character!");
            return '\u0000';
        }
        return symbol.charAt(0);
    }
}

