/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.gregtech.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import eutros.multiblocktweaker.crafttweaker.CustomMultiblock;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCControllerTile;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCIEnergyContainer;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCIItemHandlerModifiable;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCIMultipleTankHandler;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCRecipe;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IControllerTile;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IIEnergyContainer;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IIItemHandlerModifiable;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IIMultipleTankHandler;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IRecipe;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IRecipeLogic;
import eutros.multiblocktweaker.gregtech.tile.TileControllerCustom;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.NonNullList;

public class CustomMultiblockRecipeLogic
extends MultiblockRecipeLogic
implements IRecipeLogic {
    public final CustomMultiblock multiblock;

    public CustomMultiblockRecipeLogic(TileControllerCustom controller) {
        super((RecipeMapMultiblockController)controller);
        this.multiblock = controller.multiblock;
    }

    private void logFailure(String func, Throwable t) {
        CraftTweakerAPI.logError((String)String.format("Couldn't run %s function of %s.", func, this.getMetaTile().getMultiblock()), (Throwable)t);
    }

    protected int[] performOverclocking(Recipe recipe) {
        byte recipeTier = GTUtility.getTierByVoltage((long)recipe.getEUt());
        int maximumOverclockTier = this.getOverclockForTier(this.getMaximumOverclockVoltage());
        int maxOverclocks = maximumOverclockTier - recipeTier - 1;
        if (this.multiblock.runOverclockingLogic != null) {
            try {
                return this.multiblock.runOverclockingLogic.run(this, new MCRecipe(recipe), recipe.getEUt() < 0, maxOverclocks);
            }
            catch (RuntimeException t) {
                this.logFailure("runOverclockingLogic", t);
                this.multiblock.runOverclockingLogic = null;
            }
        }
        return super.runOverclockingLogic(recipe.getRecipePropertyStorage(), recipe.getEUt(), this.getMaxVoltage(), recipe.getDuration(), maxOverclocks);
    }

    @Override
    public void trySearchNewRecipe() {
        super.trySearchNewRecipe();
    }

    @Override
    public void trySearchNewRecipeCombined() {
        super.trySearchNewRecipeCombined();
    }

    @Override
    public void trySearchNewRecipeDistinct() {
        super.trySearchNewRecipeDistinct();
    }

    @Override
    public boolean checkPreviousRecipeDistinct(IIItemHandlerModifiable previousBus) {
        return super.checkPreviousRecipeDistinct(previousBus.getInner());
    }

    @Override
    public boolean prepareRecipeDistinct(IRecipe recipe) {
        return super.prepareRecipeDistinct(recipe.getInner());
    }

    @Override
    public void performMaintenanceMufflerOperations() {
        super.performMaintenanceMufflerOperations();
    }

    public void updateWorkable() {
        boolean result = true;
        if (this.multiblock.updateWorktableFunction != null) {
            try {
                result = this.multiblock.updateWorktableFunction.run(this);
            }
            catch (RuntimeException t) {
                this.logFailure("updateWorktable", t);
                this.multiblock.updateWorktableFunction = null;
            }
        }
        if (result) {
            super.updateWorkable();
        }
    }

    protected void setupRecipe(Recipe recipe) {
        boolean result = true;
        if (this.multiblock.setupRecipeFunction != null) {
            try {
                result = this.multiblock.setupRecipeFunction.run(this, new MCRecipe(recipe));
            }
            catch (RuntimeException t) {
                this.logFailure("setupRecipe", t);
                this.multiblock.setupRecipeFunction = null;
            }
        }
        if (result) {
            super.setupRecipe(recipe);
        }
    }

    protected void completeRecipe() {
        boolean result = true;
        if (this.multiblock.completeRecipeFunction != null) {
            try {
                result = this.multiblock.completeRecipeFunction.run(this);
            }
            catch (RuntimeException t) {
                this.logFailure("completeRecipe", t);
                this.multiblock.completeRecipeFunction = null;
            }
        }
        if (result) {
            super.completeRecipe();
        }
    }

    @Override
    public void superSetupRecipe(IRecipe recipe) {
        super.setupRecipe(recipe.getInner());
    }

    @Override
    public void superCompleteRecipe() {
        super.completeRecipe();
    }

    @Override
    public void superUpdateWorkable() {
        super.updateWorkable();
    }

    @Override
    public int parallelRecipesPerformed() {
        return this.parallelRecipesPerformed;
    }

    @Override
    public void ParallelRecipesPerformed(int amount) {
        this.setParallelRecipesPerformed(amount);
    }

    @Override
    public long overclockVoltage() {
        return this.getMaximumOverclockVoltage();
    }

    @Override
    public void overclockVoltage(long overclockVoltage) {
        this.setMaximumOverclockVoltage(overclockVoltage);
    }

    @Override
    public int progressTime() {
        return this.progressTime;
    }

    @Override
    public void progressTime(int progressTime) {
        this.progressTime = progressTime;
    }

    @Override
    public int maxProgressTime() {
        return this.getMaxProgress();
    }

    @Override
    public void maxProgressTime(int maxProgressTime) {
        this.setMaxProgress(maxProgressTime);
    }

    @Override
    public int recipeEUt() {
        return this.getRecipeEUt();
    }

    @Override
    public void recipeEUt(int eut) {
        this.recipeEUt = eut;
    }

    @Override
    public ILiquidStack[] fluidOutputs() {
        return this.fluidOutputs == null ? null : (ILiquidStack[])this.fluidOutputs.stream().map(CraftTweakerMC::getILiquidStack).toArray(ILiquidStack[]::new);
    }

    @Override
    public void fluidOutputs(ILiquidStack[] fluidOutputs) {
        this.fluidOutputs = fluidOutputs == null ? null : Arrays.stream(fluidOutputs).map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList());
    }

    @Override
    public IItemStack[] itemOutputs() {
        return this.itemOutputs == null ? null : (IItemStack[])this.itemOutputs.stream().map(CraftTweakerMC::getIItemStack).toArray(IItemStack[]::new);
    }

    @Override
    public void itemOutputs(IItemStack[] itemOutputs) {
        if (itemOutputs == null) {
            this.itemOutputs = null;
        } else {
            this.itemOutputs = NonNullList.func_191196_a();
            Arrays.stream(itemOutputs).map(CraftTweakerMC::getItemStack).forEach(arg_0 -> this.itemOutputs.add(arg_0));
        }
    }

    @Override
    public boolean wasActiveAndNeedsUpdate() {
        return this.wasActiveAndNeedsUpdate;
    }

    @Override
    public void wasActiveAndNeedsUpdate(boolean wasActiveAndNeedsUpdate) {
        this.wasActiveAndNeedsUpdate = wasActiveAndNeedsUpdate;
    }

    @Override
    public boolean isOutputsFull() {
        return this.isOutputsFull;
    }

    @Override
    public void isOutputsFull(boolean isOutputsFull) {
        this.isOutputsFull = isOutputsFull;
    }

    @Override
    public boolean invalidInputsForRecipes() {
        return this.invalidInputsForRecipes;
    }

    @Override
    public void invalidInputsForRecipes(boolean invalidInputsForRecipes) {
        this.invalidInputsForRecipes = invalidInputsForRecipes;
    }

    @Override
    public int getLastRecipeIndex() {
        return this.lastRecipeIndex;
    }

    @Override
    public void setLstRecipeIndex(int index) {
        this.lastRecipeIndex = index;
    }

    @Override
    public IRecipe getPreviousIRecipe() {
        return this.previousRecipe == null ? null : new MCRecipe(this.previousRecipe);
    }

    @Override
    public void setPreviousIRecipe(IRecipe previousRecipe) {
        this.previousRecipe = previousRecipe == null ? null : previousRecipe.getInner();
    }

    @Override
    public IControllerTile getMetaTile() {
        return new MCControllerTile((TileControllerCustom)this.metaTileEntity);
    }

    @Override
    public void setProgress(int val) {
        this.progressTime = val;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
    }

    @Override
    public boolean hasNotEnoughEnergy() {
        return this.isHasNotEnoughEnergy();
    }

    @Override
    public void hasNotEnoughEnergy(boolean hasNotEnoughEnergy) {
        this.hasNotEnoughEnergy = hasNotEnoughEnergy;
    }

    @Override
    public long getEnergyInputPerSecond() {
        return super.getEnergyInputPerSecond();
    }

    @Override
    public long getEnergyStored() {
        return super.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return super.getEnergyCapacity();
    }

    @Override
    public int[] calculateOverclock(IRecipe recipe) {
        return super.calculateOverclock(recipe.getInner());
    }

    @Override
    public boolean drawEnergy(int recipeEUt, boolean simulate) {
        return super.drawEnergy(recipeEUt, simulate);
    }

    @Override
    public long getMaxVoltage() {
        return super.getMaxVoltage();
    }

    @Override
    public IIItemHandlerModifiable getCurrentDistinctInputBus() {
        return new MCIItemHandlerModifiable(this.currentDistinctInputBus);
    }

    @Override
    public List<IIItemHandlerModifiable> getInvalidatedInputList() {
        return this.invalidatedInputList.stream().map(MCIItemHandlerModifiable::new).collect(Collectors.toList());
    }

    @Override
    public List<IIItemHandlerModifiable> getInputBus() {
        return super.getInputBuses().stream().map(MCIItemHandlerModifiable::new).collect(Collectors.toList());
    }

    @Override
    public IIItemHandlerModifiable getInInventory() {
        return new MCIItemHandlerModifiable(super.getInputInventory());
    }

    @Override
    public IIItemHandlerModifiable getOutInventory() {
        return new MCIItemHandlerModifiable(super.getOutputInventory());
    }

    @Override
    public IIMultipleTankHandler getInTank() {
        return new MCIMultipleTankHandler(super.getInputTank());
    }

    @Override
    public IIMultipleTankHandler getOutTank() {
        return new MCIMultipleTankHandler(super.getOutputTank());
    }

    @Override
    public IIEnergyContainer getEnergyHatch() {
        return new MCIEnergyContainer(super.getEnergyContainer());
    }
}

