/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.helper.InventoryHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class BuildModifiers {
    public static void onBlockPlaced(EntityPlayer player, List<BlockPos> startCoordinates, EnumFacing sideHit, Vec3d hitVec, boolean placeStartPos) {
        World world = player.field_70170_p;
        ItemRandomizerBag.renewRandomness();
        hitVec = new Vec3d(Math.abs(hitVec.field_72450_a - (double)((int)hitVec.field_72450_a)), Math.abs(hitVec.field_72448_b - (double)((int)hitVec.field_72448_b)), Math.abs(hitVec.field_72449_c - (double)((int)hitVec.field_72449_c)));
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, startCoordinates);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<IBlockState> blockStates = BuildModifiers.findBlockStates(player, startCoordinates, hitVec, sideHit, itemStacks);
        if (blockStates.size() == 0 || coordinates.size() != blockStates.size()) {
            return;
        }
        ArrayList<IBlockState> previousBlockStates = new ArrayList<IBlockState>(coordinates.size());
        List<Object> newBlockStates = new ArrayList(coordinates.size());
        for (BlockPos coordinate : coordinates) {
            previousBlockStates.add(world.func_180495_p(coordinate));
        }
        if (world.field_72995_K) {
            BlockPreviewRenderer.onBlocksPlaced();
            newBlockStates = blockStates;
        } else {
            int i;
            int n = i = placeStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                BlockPos blockPos = coordinates.get(i);
                IBlockState blockState = blockStates.get(i);
                ItemStack itemStack = (ItemStack)itemStacks.get(i);
                if (!(!world.func_175668_a(blockPos, true) || itemStack.func_190926_b() && (itemStack = InventoryHelper.findItemStackInInventory(player, blockState.func_177230_c())).func_190926_b())) {
                    SurvivalHelper.placeBlock(world, player, blockPos, blockState, itemStack, EnumFacing.UP, hitVec, false, false, false);
                }
                ++i;
            }
            for (BlockPos coordinate : coordinates) {
                newBlockStates.add(world.func_180495_p(coordinate));
            }
        }
        if (!placeStartPos) {
            previousBlockStates.set(0, Blocks.field_150350_a.func_176223_P());
        }
        if (Collections.frequency(newBlockStates, Blocks.field_150350_a.func_176223_P()) != newBlockStates.size()) {
            BlockPos firstPos = startCoordinates.get(0);
            BlockPos secondPos = startCoordinates.get(startCoordinates.size() - 1);
            UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
        }
    }

    public static void onBlockBroken(EntityPlayer player, List<BlockPos> startCoordinates, boolean breakStartPos) {
        World world = player.field_70170_p;
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, startCoordinates);
        if (coordinates.isEmpty()) {
            return;
        }
        ArrayList<IBlockState> previousBlockStates = new ArrayList<IBlockState>(coordinates.size());
        ArrayList<IBlockState> newBlockStates = new ArrayList<IBlockState>(coordinates.size());
        for (BlockPos coordinate : coordinates) {
            previousBlockStates.add(world.func_180495_p(coordinate));
        }
        if (world.field_72995_K) {
            BlockPreviewRenderer.onBlocksBroken();
            for (BlockPos coordinate : coordinates) {
                newBlockStates.add(Blocks.field_150350_a.func_176223_P());
            }
        } else {
            int i;
            boolean onlyInstaBreaking = !player.func_184812_l_() && world.func_180495_p(startCoordinates.get(0)).func_185887_b(world, startCoordinates.get(0)) == 0.0f;
            int n = i = breakStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                BlockPos coordinate = coordinates.get(i);
                if (world.func_175668_a(coordinate, false) && (!onlyInstaBreaking || world.func_180495_p(coordinate).func_185887_b(world, coordinate) == 0.0f)) {
                    SurvivalHelper.breakBlock(world, player, coordinate, false);
                }
                ++i;
            }
            for (BlockPos coordinate : coordinates) {
                newBlockStates.add(world.func_180495_p(coordinate));
            }
        }
        if (!breakStartPos) {
            newBlockStates.set(0, Blocks.field_150350_a.func_176223_P());
        }
        BlockPos firstPos = startCoordinates.get(0);
        BlockPos secondPos = startCoordinates.get(startCoordinates.size() - 1);
        Vec3d hitVec = new Vec3d(0.5, 0.5, 0.5);
        UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
    }

    public static List<BlockPos> findCoordinates(EntityPlayer player, List<BlockPos> posList) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        coordinates.addAll(posList);
        for (BlockPos blockPos : posList) {
            List<BlockPos> arrayCoordinates = Array.findCoordinates(player, blockPos);
            coordinates.addAll(arrayCoordinates);
            coordinates.addAll(Mirror.findCoordinates(player, blockPos));
            coordinates.addAll(RadialMirror.findCoordinates(player, blockPos));
            for (BlockPos coordinate : arrayCoordinates) {
                coordinates.addAll(Mirror.findCoordinates(player, coordinate));
                coordinates.addAll(RadialMirror.findCoordinates(player, coordinate));
            }
        }
        return coordinates;
    }

    public static List<BlockPos> findCoordinates(EntityPlayer player, BlockPos blockPos) {
        return BuildModifiers.findCoordinates(player, new ArrayList<BlockPos>(Arrays.asList(blockPos)));
    }

    public static List<IBlockState> findBlockStates(EntityPlayer player, List<BlockPos> posList, Vec3d hitVec, EnumFacing facing, List<ItemStack> itemStacks) {
        IBlockState blockState;
        ArrayList<IBlockState> blockStates = new ArrayList<IBlockState>();
        itemStacks.clear();
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack.func_190926_b() || !CompatHelper.isItemBlockProxy(itemStack)) {
            itemStack = player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (itemStack.func_190926_b() || !CompatHelper.isItemBlockProxy(itemStack)) {
            return blockStates;
        }
        ItemStack itemBlock = ItemStack.field_190927_a;
        itemBlock = itemStack.func_77973_b() instanceof ItemBlock ? itemStack : CompatHelper.getItemBlockFromStack(itemStack);
        ItemRandomizerBag.resetRandomness();
        for (BlockPos blockPos : posList) {
            if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
                itemBlock = CompatHelper.getItemBlockFromStack(itemStack);
            }
            blockState = BuildModifiers.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, EnumHand.MAIN_HAND);
            blockStates.add(blockState);
            itemStacks.add(itemBlock);
        }
        for (BlockPos blockPos : posList) {
            blockState = BuildModifiers.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, EnumHand.MAIN_HAND);
            List<IBlockState> arrayBlockStates = Array.findBlockStates(player, blockPos, blockState, itemStack, itemStacks);
            blockStates.addAll(arrayBlockStates);
            blockStates.addAll(Mirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            blockStates.addAll(RadialMirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            List<BlockPos> arrayCoordinates = Array.findCoordinates(player, blockPos);
            for (int i = 0; i < arrayCoordinates.size(); ++i) {
                BlockPos coordinate = arrayCoordinates.get(i);
                IBlockState blockState1 = arrayBlockStates.get(i);
                blockStates.addAll(Mirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
                blockStates.addAll(RadialMirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
            }
        }
        return blockStates;
    }

    public static boolean isEnabled(ModifierSettingsManager.ModifierSettings modifierSettings, BlockPos startPos) {
        return Mirror.isEnabled(modifierSettings.getMirrorSettings(), startPos) || Array.isEnabled(modifierSettings.getArraySettings()) || RadialMirror.isEnabled(modifierSettings.getRadialMirrorSettings(), startPos) || modifierSettings.doQuickReplace();
    }

    public static IBlockState getBlockStateFromItem(ItemStack itemStack, EntityPlayer player, BlockPos blockPos, EnumFacing facing, Vec3d hitVec, EnumHand hand) {
        return Block.func_149634_a((Item)itemStack.func_77973_b()).getStateForPlacement(player.field_70170_p, blockPos, facing, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, itemStack.func_77960_j(), (EntityLivingBase)player, hand);
    }

    public static boolean compareCoordinates(List<BlockPos> coordinates1, List<BlockPos> coordinates2) {
        if (coordinates1 == null && coordinates2 == null) {
            return true;
        }
        if (coordinates1 == null || coordinates2 == null) {
            return false;
        }
        if (coordinates1.size() == coordinates2.size()) {
            if (coordinates1.size() == 1) {
                return coordinates1.get(0).equals((Object)coordinates2.get(0));
            }
            return true;
        }
        return false;
    }
}

