/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.helper.FixedStack;
import nl.requios.effortlessbuilding.helper.InventoryHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class UndoRedo {
    private static Map<UUID, FixedStack<BlockSet>> undoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static Map<UUID, FixedStack<BlockSet>> undoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();
    private static Map<UUID, FixedStack<BlockSet>> redoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static Map<UUID, FixedStack<BlockSet>> redoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();

    public static void addUndo(EntityPlayer player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.field_70170_p.field_72995_K ? undoStacksClient : undoStacksServer;
        if (blockSet.getCoordinates().size() != blockSet.getPreviousBlockStates().size() || blockSet.getCoordinates().size() != blockSet.getNewBlockStates().size()) {
            EffortlessBuilding.logger.error("Coordinates and blockstate lists are not equal length. Coordinates: {}. Previous blockstates: {}. New blockstates: {}.", (Object)blockSet.getCoordinates().size(), (Object)blockSet.getPreviousBlockStates().size(), (Object)blockSet.getNewBlockStates().size());
        }
        if (!undoStacks.containsKey(player.func_110124_au())) {
            undoStacks.put(player.func_110124_au(), new FixedStack<BlockSet>(new BlockSet[BuildConfig.survivalBalancers.undoStackSize]));
        }
        undoStacks.get(player.func_110124_au()).push(blockSet);
    }

    private static void addRedo(EntityPlayer player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_70170_p.field_72995_K ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.func_110124_au())) {
            redoStacks.put(player.func_110124_au(), new FixedStack<BlockSet>(new BlockSet[BuildConfig.survivalBalancers.undoStackSize]));
        }
        redoStacks.get(player.func_110124_au()).push(blockSet);
    }

    public static boolean undo(EntityPlayer player) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.field_70170_p.field_72995_K ? undoStacksClient : undoStacksServer;
        if (!undoStacks.containsKey(player.func_110124_au())) {
            return false;
        }
        FixedStack<BlockSet> undoStack = undoStacks.get(player.func_110124_au());
        if (undoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = undoStack.pop();
        List<BlockPos> coordinates = blockSet.getCoordinates();
        List<IBlockState> previousBlockStates = blockSet.getPreviousBlockStates();
        List<IBlockState> newBlockStates = blockSet.getNewBlockStates();
        Vec3d hitVec = blockSet.getHitVec();
        List<ItemStack> itemStacks = UndoRedo.findItemStacksInInventory(player, previousBlockStates);
        if (player.field_70170_p.field_72995_K) {
            BlockPreviewRenderer.onBlocksBroken(coordinates, itemStacks, newBlockStates, blockSet.getSecondPos(), blockSet.getFirstPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                BlockPos coordinate = coordinates.get(i);
                ItemStack itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                IBlockState previousBlockState = Blocks.field_150350_a.func_176223_P();
                if (itemStack.func_77973_b() instanceof ItemBlock) {
                    previousBlockState = previousBlockStates.get(i);
                }
                if (!player.field_70170_p.func_175668_a(coordinate, true)) continue;
                if (itemStack.func_190926_b()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, previousBlockStates.get(i));
                    previousBlockState = !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBlock ? previousBlockStates.get(i) : Blocks.field_150350_a.func_176223_P();
                }
                if (itemStack.func_190926_b()) {
                    SurvivalHelper.breakBlock(player.field_70170_p, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.field_70170_p, player, coordinate, previousBlockState, itemStack, EnumFacing.UP, hitVec, true, false, false);
            }
        }
        UndoRedo.addRedo(player, blockSet);
        return true;
    }

    public static boolean redo(EntityPlayer player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_70170_p.field_72995_K ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.func_110124_au())) {
            return false;
        }
        FixedStack<BlockSet> redoStack = redoStacks.get(player.func_110124_au());
        if (redoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = redoStack.pop();
        List<BlockPos> coordinates = blockSet.getCoordinates();
        List<IBlockState> previousBlockStates = blockSet.getPreviousBlockStates();
        List<IBlockState> newBlockStates = blockSet.getNewBlockStates();
        Vec3d hitVec = blockSet.getHitVec();
        List<ItemStack> itemStacks = UndoRedo.findItemStacksInInventory(player, newBlockStates);
        if (player.field_70170_p.field_72995_K) {
            BlockPreviewRenderer.onBlocksPlaced(coordinates, itemStacks, newBlockStates, blockSet.getFirstPos(), blockSet.getSecondPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                BlockPos coordinate = coordinates.get(i);
                ItemStack itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                IBlockState newBlockState = Blocks.field_150350_a.func_176223_P();
                if (itemStack.func_77973_b() instanceof ItemBlock) {
                    newBlockState = newBlockStates.get(i);
                }
                if (!player.field_70170_p.func_175668_a(coordinate, true)) continue;
                if (itemStack.func_190926_b()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, newBlockStates.get(i));
                    newBlockState = !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBlock ? newBlockStates.get(i) : Blocks.field_150350_a.func_176223_P();
                }
                if (itemStack.func_190926_b()) {
                    SurvivalHelper.breakBlock(player.field_70170_p, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.field_70170_p, player, coordinate, newBlockState, itemStack, EnumFacing.UP, hitVec, true, false, false);
            }
        }
        UndoRedo.addUndo(player, blockSet);
        return true;
    }

    public static void clear(EntityPlayer player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> undoStacks = player.field_70170_p.field_72995_K ? undoStacksClient : undoStacksServer;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_70170_p.field_72995_K ? redoStacksClient : redoStacksServer;
        if (undoStacks.containsKey(player.func_110124_au())) {
            undoStacks.get(player.func_110124_au()).clear();
        }
        if (redoStacks.containsKey(player.func_110124_au())) {
            redoStacks.get(player.func_110124_au()).clear();
        }
    }

    private static List<ItemStack> findItemStacksInInventory(EntityPlayer player, List<IBlockState> blockStates) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(blockStates.size());
        for (IBlockState blockState : blockStates) {
            itemStacks.add(UndoRedo.findItemStackInInventory(player, blockState));
        }
        return itemStacks;
    }

    private static ItemStack findItemStackInInventory(EntityPlayer player, IBlockState blockState) {
        Item itemDropped;
        ItemStack itemStack = ItemStack.field_190927_a;
        if (blockState == null) {
            return itemStack;
        }
        itemStack = InventoryHelper.findItemStackInInventory(player, blockState.func_177230_c());
        if (itemStack.func_190926_b() && (itemDropped = blockState.func_177230_c().func_180660_a(blockState, player.field_70170_p.field_73012_v, 10)) instanceof ItemBlock) {
            Block block = ((ItemBlock)itemDropped).func_179223_d();
            itemStack = InventoryHelper.findItemStackInInventory(player, block);
        }
        return itemStack;
    }
}

