/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.IngredientUtils;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockIngredient
extends Item
implements ICreativeRendered,
ILittleIngredientInventory {
    public ItemBlockIngredient() {
        this.field_77787_bX = true;
        this.func_77637_a(LittleTiles.littleTab);
        this.func_77625_d(1);
    }

    public static BlockIngredientEntry loadIngredient(ItemStack stack) {
        if (stack.func_77942_o()) {
            return IngredientUtils.loadBlockIngredient(stack.func_77978_p());
        }
        return null;
    }

    public static void saveIngredient(ItemStack stack, BlockIngredientEntry entry) {
        entry.writeToNBT(stack.func_77978_p());
    }

    public String func_77653_i(ItemStack stack) {
        BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient(stack);
        if (entry != null) {
            return entry.getItemStack().func_82833_r();
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient(stack);
        if (entry != null) {
            tooltip.add(BlockIngredient.printVolume(entry.value, false));
        }
    }

    @Override
    public LittleIngredients getInventory(ItemStack stack) {
        BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient(stack);
        if (entry != null) {
            BlockIngredient ingredient = new BlockIngredient();
            ingredient.add(entry);
            return new LittleIngredients(new LittleIngredient[]{ingredient.setLimits(1, 64.0)}){

                @Override
                protected boolean canAddNewIngredients() {
                    return false;
                }

                @Override
                protected boolean removeEmptyIngredients() {
                    return false;
                }
            };
        }
        return null;
    }

    @Override
    public void setInventory(ItemStack stack, LittleIngredients ingredients, LittleInventory inventory) {
        BlockIngredient blocks = ingredients.get(BlockIngredient.class);
        if (blocks != null && !blocks.isEmpty()) {
            for (BlockIngredientEntry entry : blocks) {
                if (entry.isEmpty() && !(entry.block instanceof BlockAir)) continue;
                if (inventory != null && entry.value >= 1.0) {
                    ItemStack overflow = entry.getItemStack();
                    overflow.func_190920_e((int)entry.value);
                    entry.value -= (double)overflow.func_190916_E();
                    inventory.addStack(overflow);
                }
                if (!(entry.value > 0.0)) continue;
                ItemBlockIngredient.saveIngredient(stack, entry);
                return;
            }
        }
        stack.func_77982_d(null);
        stack.func_190920_e(0);
    }

    public List<? extends RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
        BlockIngredientEntry ingredient = ItemBlockIngredient.loadIngredient(stack);
        if (ingredient == null) {
            return null;
        }
        double volume = Math.min(1.0, ingredient.value);
        LittleGridContext context = LittleGridContext.get();
        long pixels = (long)(volume * (double)context.maxTilesPerBlock);
        if (pixels < (long)(context.size * context.size)) {
            cubes.add(new RenderBox(0.4f, 0.4f, 0.4f, 0.6f, 0.6f, 0.6f, ingredient.block, ingredient.meta));
        } else {
            long remainingPixels = pixels;
            long planes = pixels / context.maxTilesPerPlane;
            long rows = (remainingPixels -= planes * context.maxTilesPerPlane) / (long)context.size;
            remainingPixels -= rows * (long)context.size;
            float height = (float)((double)planes * context.pixelSize);
            if (planes > 0L) {
                cubes.add(new RenderBox(0.0f, 0.0f, 0.0f, 1.0f, height, 1.0f, ingredient.block, ingredient.meta));
            }
            float width = (float)((double)rows * context.pixelSize);
            if (rows > 0L) {
                cubes.add(new RenderBox(0.0f, height, 0.0f, 1.0f, height + (float)context.pixelSize, width, ingredient.block, ingredient.meta));
            }
            if (remainingPixels > 0L) {
                cubes.add(new RenderBox(0.0f, height, width, 1.0f, height + (float)context.pixelSize, width + (float)context.pixelSize, ingredient.block, ingredient.meta));
            }
        }
        return cubes;
    }

    @Override
    public boolean shouldBeMerged() {
        return true;
    }
}

