/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.registry;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.registry.StructureIngredientRule;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.type.LittleBed;
import com.creativemd.littletiles.common.structure.type.LittleChair;
import com.creativemd.littletiles.common.structure.type.LittleFixedStructure;
import com.creativemd.littletiles.common.structure.type.LittleItemHolder;
import com.creativemd.littletiles.common.structure.type.LittleLadder;
import com.creativemd.littletiles.common.structure.type.LittleLight;
import com.creativemd.littletiles.common.structure.type.LittleNoClipStructure;
import com.creativemd.littletiles.common.structure.type.LittleStorage;
import com.creativemd.littletiles.common.structure.type.LittleStructureMessage;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructureBuilder;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.util.ingredient.StackIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class LittleStructureRegistry {
    private static HashMap<String, LittleStructureType> structures = new LinkedHashMap<String, LittleStructureType>();
    private static HashMap<Class<? extends LittleStructure>, LittleStructureType> structuresClass = new LinkedHashMap<Class<? extends LittleStructure>, LittleStructureType>();
    private static PairList<String, PairList<String, Class<? extends LittleStructureGuiParser>>> craftables = new PairList();
    private static List<LittleStructureGuiParser.LittleStructureGuiParserNotFoundHandler> premadeParsers = new ArrayList<LittleStructureGuiParser.LittleStructureGuiParserNotFoundHandler>();
    private static LittleStructureType defaultType;

    public static LittleStructureType registerStructureType(String id, String category, Class<? extends LittleStructure> classStructure, int attribute, Class<? extends LittleStructureGuiParser> parser) {
        return LittleStructureRegistry.registerStructureType(new LittleStructureType(id, category, classStructure, attribute), parser);
    }

    public static void registerGuiParser(String id, String category, Class<? extends LittleStructureGuiParser> parser) {
        category = "structure.category." + category;
        PairList categoryList = (PairList)craftables.getValue((Object)category);
        if (categoryList == null) {
            categoryList = new PairList();
            craftables.add((Object)category, (Object)categoryList);
        }
        categoryList.add((Object)("structure." + id + ".name"), parser);
    }

    public static void registerGuiParserNotFoundHandler(LittleStructureGuiParser.LittleStructureGuiParserNotFoundHandler handler) {
        premadeParsers.add(handler);
    }

    public static PairList<String, PairList<String, Class<? extends LittleStructureGuiParser>>> getCraftables() {
        return craftables;
    }

    public static Class<? extends LittleStructureGuiParser> getParserClass(String id) {
        for (Pair pair : craftables) {
            Class parser = (Class)((PairList)pair.value).getValue((Object)id);
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    public static LittleStructureGuiParser getParser(GuiParent parent, AnimationGuiHandler handler, Class<? extends LittleStructureGuiParser> clazz) {
        try {
            if (clazz == null) {
                return null;
            }
            return clazz.getConstructor(GuiParent.class, AnimationGuiHandler.class).newInstance(parent, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LittleStructureGuiParser getParser(GuiParent parent, AnimationGuiHandler handler, String id) {
        try {
            Class<? extends LittleStructureGuiParser> clazz = LittleStructureRegistry.getParserClass(id);
            if (clazz == null) {
                return null;
            }
            return clazz.getConstructor(GuiParent.class, AnimationGuiHandler.class).newInstance(parent, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LittleStructureGuiParser getParserNotFound(GuiParent parent, AnimationGuiHandler handler, LittleStructure structure) {
        for (LittleStructureGuiParser.LittleStructureGuiParserNotFoundHandler notFound : premadeParsers) {
            LittleStructureGuiParser parser = notFound.create(structure, parent, handler);
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    public static LittleStructureType registerStructureType(LittleStructureType entry, Class<? extends LittleStructureGuiParser> parser) {
        if (structures.containsKey(entry.id)) {
            throw new RuntimeException("ID is already taken! id=" + entry.id);
        }
        if (parser != null) {
            LittleStructureRegistry.registerGuiParser(entry.id, entry.category, parser);
        }
        structures.put(entry.id, entry);
        structuresClass.put(entry.clazz, entry);
        return entry;
    }

    public static String getStructureId(Class<? extends LittleStructure> classStructure) {
        LittleStructureType entry = structuresClass.get(classStructure);
        if (entry != null) {
            return entry.id;
        }
        return null;
    }

    public static Class<? extends LittleStructure> getStructureClass(String id) {
        LittleStructureType entry = structures.get(id);
        if (entry != null) {
            return entry.clazz;
        }
        return null;
    }

    public static LittleStructureType getStructureType(String id) {
        return structures.getOrDefault(id, defaultType);
    }

    public static LittleStructureType getStructureType(Class<? extends LittleStructure> classStructure) {
        return structuresClass.get(classStructure);
    }

    public static void initStructures() {
        defaultType = LittleStructureRegistry.registerStructureType("fixed", "simple", LittleFixedStructure.class, 0, LittleFixedStructure.LittleFixedStructureParser.class);
        LittleStructureRegistry.registerStructureType("ladder", "simple", LittleLadder.class, 1, LittleLadder.LittleLadderParser.class).addIngredient(StructureIngredientRule.LONGEST_SIDE, () -> new StackIngredient(new ItemStack(Blocks.field_150468_ap)));
        LittleStructureRegistry.registerStructureType("bed", "simple", LittleBed.class, 0, LittleBed.LittleBedParser.class).addInput("occupied", 1).addIngredient(StructureIngredientRule.SINGLE, () -> new StackIngredient(new ItemStack(Items.field_151104_aV)));
        LittleStructureRegistry.registerStructureType("chair", "simple", LittleChair.class, 0, LittleChair.LittleChairParser.class).addInput("occupied", 1);
        LittleStructureRegistry.registerStructureType(new LittleStorage.LittleStorageType("storage", "simple", LittleStorage.class, 0).addInput("accessed", 1).addInput("filled", 16), LittleStorage.LittleStorageParser.class);
        LittleStructureRegistry.registerStructureType("noclip", "simple", LittleNoClipStructure.class, 131074, LittleNoClipStructure.LittleNoClipStructureParser.class).addInput("players", 4).addInput("entities", 4);
        LittleStructureRegistry.registerStructureType("light", "simple", LittleLight.class, 262144, LittleLight.LittleLightStructureParser.class).addOutput("enabled", 1, SignalMode.TOGGLE, true).addIngredient(new StructureIngredientRule.StructureIngredientScalerVolume(8.0), () -> new StackIngredient(new ItemStack(Items.field_151114_aO)));
        LittleStructureRegistry.registerStructureType("message", "simple", LittleStructureMessage.class, 0, LittleStructureMessage.LittleMessageStructureParser.class).addOutput("message", 1, SignalMode.EQUAL);
        LittleStructureBuilder.register(new LittleStructureBuilder.LittleStructureBuilderType(LittleStructureRegistry.registerStructureType("item_holder", "simple", LittleItemHolder.class, 512, null).addInput("filled", 1), "frame"));
        LittleDoorBase.initDoors();
        LittleStructurePremade.initPremadeStructures();
    }
}

