/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.output;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.StructureChildConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.ISignalStructureComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.signal.output.SignalOutputHandler;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import java.text.ParseException;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SignalExternalOutputHandler
implements ISignalComponent {
    public final LittleStructure structure;
    public final int index;
    public SignalInputCondition condition;
    public SignalOutputHandler handler;

    public SignalExternalOutputHandler(LittleStructure structure, int index, SignalInputCondition condition, Function<ISignalComponent, SignalOutputHandler> function) {
        this.structure = structure;
        this.index = index;
        this.condition = condition;
        this.handler = function.apply(this);
    }

    public SignalExternalOutputHandler(LittleStructure structure, NBTTagCompound nbt) throws ParseException {
        this.structure = structure;
        this.index = nbt.func_74762_e("index");
        try {
            this.condition = nbt.func_74764_b("con") ? SignalInputCondition.parseInput(nbt.func_74779_i("con")) : null;
        }
        catch (ParseException e) {
            this.condition = null;
        }
        SignalMode mode = SignalMode.EQUAL;
        if (nbt.func_74764_b("mode")) {
            mode = SignalMode.valueOf(nbt.func_74779_i("mode"));
        }
        int delay = nbt.func_74762_e("delay");
        if (this.condition != null) {
            delay = Math.max((int)Math.ceil(this.condition.calculateDelay()), nbt.func_74762_e("delay"));
        }
        this.handler = SignalOutputHandler.create(this, mode, delay, nbt, structure);
    }

    public ISignalStructureComponent getOutput() throws CorruptedConnectionException, NotYetConnectedException {
        StructureChildConnection connection = this.structure.getChild(this.index);
        LittleStructure output = connection.getStructure();
        if (output instanceof LittleSignalOutput) {
            return (ISignalStructureComponent)((Object)output);
        }
        throw new RuntimeException("Invalid structure child expected output " + output);
    }

    public void update() {
        if (this.condition == null) {
            return;
        }
        try {
            int bandwidth = this.handler.getBandwidth();
            if (bandwidth > 0) {
                boolean[] outputState = new boolean[bandwidth];
                boolean[] result = this.condition.test(this.structure, false);
                if (result.length == 1) {
                    Arrays.fill(outputState, result[0]);
                } else {
                    for (int i = 0; i < result.length; ++i) {
                        if (i >= outputState.length) continue;
                        outputState[i] = result[i];
                    }
                }
                this.handler.schedule(outputState);
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    public NBTTagCompound write(boolean preview) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("index", this.index);
        if (this.structure != null) {
            try {
                nbt.func_74768_a("state", BooleanUtils.boolToInt((boolean[])this.getState()));
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        if (this.condition != null) {
            nbt.func_74778_a("con", this.condition.write());
        }
        nbt.func_74778_a("mode", this.handler == null ? SignalMode.EQUAL.name() : this.handler.getMode().name());
        if (this.handler != null) {
            nbt.func_74768_a("delay", this.handler.delay);
            this.handler.write(preview, nbt);
        }
        return nbt;
    }

    @Override
    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getOutput().getBandwidth();
    }

    @Override
    public void changed() throws CorruptedConnectionException, NotYetConnectedException {
        this.getOutput().changed();
        this.structure.schedule();
    }

    @Override
    public boolean[] getState() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getOutput().getState();
    }

    @Override
    public SignalComponentType getType() {
        return SignalComponentType.OUTPUT;
    }

    @Override
    public LittleStructure getStructure() {
        return this.structure;
    }

    @Override
    public World getStructureWorld() {
        if (this.structure == null) {
            return null;
        }
        return this.structure.getWorld();
    }

    public String toString() {
        return "o" + this.index;
    }
}

