/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleLadder
extends LittleStructure {
    public LittleLadder(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    public static boolean isLivingOnLadder(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        int z2;
        int x2;
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return state.func_177230_c().isLadder(state, (IBlockAccess)world, pos, entity);
        }
        BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();
        AxisAlignedBB bb = entity.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    tmp.func_181079_c(x2, y2, z2);
                    state = world.func_180495_p((BlockPos)tmp);
                    if (state.func_177230_c().isLadder(state, (IBlockAccess)world, (BlockPos)tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        bb = entity.func_174813_aQ().func_186662_g(1.0E-4);
        mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    tmp.func_181079_c(x2, y2, z2);
                    state = world.func_180495_p((BlockPos)tmp);
                    if (state.func_177230_c() instanceof BlockTile && state.func_177230_c().isLadder(state, (IBlockAccess)world, (BlockPos)tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static class LittleLadderParser
    extends LittleStructureGuiParser {
        public LittleLadderParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        public void createControls(LittlePreviews previews, LittleStructure structure) {
        }

        @Override
        public LittleLadder parseStructure(LittlePreviews previews) {
            return this.createStructure(LittleLadder.class, null);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleLadder.class);
        }
    }
}

