/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleActivateDoorPacket;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.structure.animation.event.ChildActivateEvent;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class LittleDoor
extends LittleStructure {
    public boolean activateParent = false;
    public boolean disableRightClick = false;
    public boolean opened = false;

    public LittleDoor(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.activateParent = nbt.func_74767_n("activateParent");
        this.disableRightClick = nbt.func_74767_n("disableRightClick");
        this.opened = nbt.func_74767_n("opened");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74757_a("activateParent", this.activateParent);
        nbt.func_74757_a("disableRightClick", this.disableRightClick);
        nbt.func_74757_a("opened", this.opened);
    }

    public EntityAnimation activate(DoorActivator activator, @Nullable EntityPlayer player, @Nullable UUID uuid) throws LittleActionException {
        if (this.mainBlock.isRemoved()) {
            throw new LittleActionException("Structure does not exist");
        }
        if (activator == DoorActivator.RIGHTCLICK && this.disableRightClick) {
            throw new LittleActionException.LittleActionExceptionHidden("Door is locked!");
        }
        this.load();
        if (this.activateParent && this.getParent() != null) {
            LittleStructure parentStructure = this.getParent().getStructure();
            if (parentStructure instanceof LittleDoor) {
                return ((LittleDoor)parentStructure).activate(activator, player, uuid);
            }
            throw new LittleActionException("Invalid parent");
        }
        if (this.isInMotion()) {
            throw new StillInMotionException();
        }
        if (uuid == null) {
            uuid = this instanceof IAnimatedStructure && ((IAnimatedStructure)((Object)this)).isAnimated() ? ((IAnimatedStructure)((Object)this)).getAnimation().func_110124_au() : UUID.randomUUID();
        }
        if (this.getWorld().field_72995_K) {
            this.sendActivationToServer(activator, player, uuid);
            return null;
        }
        if (!this.canOpenDoor(player)) {
            if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("exception.door.notenoughspace", new Object[0]), true);
            }
            throw new LittleActionException("Cannot open door");
        }
        boolean bl = this.opened = !this.opened;
        if (activator != DoorActivator.SIGNAL && !this.getWorld().field_72995_K) {
            this.getOutput(0).toggle();
        }
        return this.openDoor(player, new UUIDSupplier(uuid), false);
    }

    @Override
    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        this.activate(DoorActivator.RIGHTCLICK, playerIn, null);
        action.preventInteraction = true;
        return true;
    }

    public void startAnimation(EntityAnimation animation) {
    }

    public void beforeTick(EntityAnimation animation, int tick) {
    }

    public void afterTick(EntityAnimation animation, int tick) {
    }

    public void finishAnimation(EntityAnimation animation) {
    }

    public void sendActivationToServer(DoorActivator type, EntityPlayer activator, UUID uuid) {
        PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleActivateDoorPacket(type, this.getStructureLocation(), uuid));
    }

    public abstract int getCompleteDuration();

    public abstract List<LittleDoor> collectDoorsToCheck();

    public abstract boolean isInMotion();

    public boolean canOpenDoor(@Nullable EntityPlayer player) {
        if (this.isInMotion()) {
            return false;
        }
        for (BlockPos pos : this.positions()) {
            if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) continue;
            return false;
        }
        for (LittleDoor door : this.collectDoorsToCheck()) {
            if (door.canOpenDoor(player)) continue;
            return false;
        }
        return true;
    }

    public LittleDoor getParentDoor() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.activateParent && this.getParent() != null) {
            return ((LittleDoor)this.getParent().getStructure()).getParentDoor();
        }
        return this;
    }

    public abstract EntityAnimation openDoor(@Nullable EntityPlayer var1, UUIDSupplier var2, boolean var3) throws LittleActionException;

    public void onChildComplete(LittleDoor door, int childId) {
    }

    public void completeAnimation() {
        if (this.activateParent && this.getParent() != null) {
            try {
                LittleStructure parent = this.getParent().getStructure();
                if (parent instanceof LittleDoor) {
                    ((LittleDoor)parent).onChildComplete(this, this.getParent().childId);
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
        if (!this.mainBlock.isRemoved() && !this.isClient()) {
            this.getOutput(0).changed();
            this.notifyChange();
        }
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).identifier.equals("state") && this.opened != output.getState()[0] && !this.isInMotion()) {
            try {
                this.activate(DoorActivator.SIGNAL, null, null);
            }
            catch (LittleActionException littleActionException) {
                // empty catch block
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        super.writeToNBTPreview(nbt, newCenter);
        NBTTagCompound stateNBT = nbt.func_74775_l("state");
        stateNBT.func_74768_a("state", 0);
        return nbt;
    }

    public static enum DoorActivator {
        RIGHTCLICK,
        COMMAND,
        SIGNAL;

    }

    public static class StillInMotionException
    extends LittleActionException.LittleActionExceptionHidden {
        public StillInMotionException() {
            super("Structure is still in motion");
        }
    }

    public static class LittleDoorType
    extends LittleDoorBase.LittleDoorBaseType {
        public LittleDoorType(String id, String category, Class<? extends LittleStructure> structureClass, int attribute) {
            super(id, category, structureClass, attribute);
        }

        @Override
        public void setBit(LittlePreviews previews, BitSet set) {
            NBTTagList list = previews.structureNBT.func_150295_c("events", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                AnimationEvent event = AnimationEvent.loadFromNBT(list.func_150305_b(i));
                if (!(event instanceof ChildActivateEvent)) continue;
                set.set(((ChildActivateEvent)event).childId);
            }
        }
    }
}

