/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.interpolation.CubicInterpolation;
import com.creativemd.creativecore.common.utils.math.interpolation.HermiteInterpolation;
import com.creativemd.creativecore.common.utils.math.interpolation.LinearInterpolation;
import com.creativemd.creativecore.common.utils.math.vec.Vec;
import com.creativemd.creativecore.common.utils.math.vec.Vec3;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.ShapeSelection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleShapeCurve
extends LittleShape {
    private static String[] interpolationTypes = new String[]{"hermite", "cubic", "linear"};

    public LittleShapeCurve() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        HermiteInterpolation interpolation;
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        double halfPixelSize = selection.getContext().pixelSize * 0.5;
        for (ShapeSelection.ShapeSelectPos pos : selection) {
            LittleGridContext context = pos.getContext();
            points.add(new Vec3(pos.pos.getPosX() + halfPixelSize, pos.pos.getPosY() + halfPixelSize, pos.pos.getPosZ() + halfPixelSize));
        }
        int thickness = Math.max(0, selection.getNBT().func_74762_e("thickness") - 1);
        if (points.size() <= 1) {
            LittleBox box = selection.getOverallBox();
            box.growCentered(thickness);
            boxes.add(box);
            return;
        }
        switch (selection.getNBT().func_74762_e("interpolation")) {
            case 0: {
                interpolation = new HermiteInterpolation((Vec[])points.toArray(new Vec3[0]));
                break;
            }
            case 1: {
                interpolation = new CubicInterpolation((Vec[])points.toArray(new Vec3[0]));
                break;
            }
            default: {
                interpolation = new LinearInterpolation((Vec[])points.toArray(new Vec3[0]));
            }
        }
        Vec3 origin = new Vec3((double)boxes.pos.func_177958_n(), (double)boxes.pos.func_177956_o(), (double)boxes.pos.func_177952_p());
        int amount = 0;
        double pointTime = 1.0 / (double)(points.size() - 1);
        double currentTime = 0.0;
        for (int i = 0; i < points.size() - 1; ++i) {
            Vec3 before = (Vec3)points.get(i);
            Vec3 end = (Vec3)points.get(i + 1);
            Vec3 middle = (Vec3)interpolation.valueAt(pointTime * ((double)i + 0.5));
            double distance = before.distance((Vec)middle) + middle.distance((Vec)end);
            int stepCount = (int)Math.ceil(distance / boxes.context.pixelSize * 2.0);
            double stepSize = pointTime / (double)(stepCount - 1);
            for (int j = 0; j < stepCount; ++j) {
                Vec3 vec = (Vec3)interpolation.valueAt(pointTime * (double)i + stepSize * (double)j);
                LittleBox box = new LittleBox(new LittleVec(boxes.context, (Vec3)vec.sub((Vec)origin)));
                box.growCentered(thickness);
                boxes.add(box);
                ++amount;
            }
        }
    }

    @Override
    public boolean requiresNoOverlap() {
        return true;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        list.add("interpolation: " + interpolationTypes[nbt.func_74762_e("interpolation")]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 5, 100, 14, nbt.func_74762_e("thickness"), 1, context.size));
        controls.add((GuiControl)new GuiStateButton("interpolation", nbt.func_74762_e("interpolation"), 5, 30, 40, 7, interpolationTypes));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
        nbt.func_74768_a("interpolation", ((GuiStateButton)gui.get("interpolation")).getState());
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

