/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.vec;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleTransformation {
    public BlockPos center;
    public int rotX;
    public int rotY;
    public int rotZ;
    public LittleVec doubledRotationCenter;
    public LittleVecContext offset;

    public LittleTransformation(int[] array) {
        if (array.length != 13) {
            throw new IllegalArgumentException("Invalid array when creating door transformation!");
        }
        this.center = new BlockPos(array[0], array[1], array[2]);
        this.rotX = array[3];
        this.rotY = array[4];
        this.rotZ = array[5];
        this.doubledRotationCenter = new LittleVec(array[6], array[7], array[8]);
        this.offset = new LittleVecContext(new LittleVec(array[9], array[10], array[11]), LittleGridContext.get(array[12]));
    }

    public LittleTransformation(BlockPos center, int rotX, int rotY, int rotZ, LittleVec doubledRotationCenter, LittleVecContext offset) {
        this.center = center;
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
        this.doubledRotationCenter = doubledRotationCenter;
        this.offset = offset;
    }

    public LittleTransformation(BlockPos center, Rotation rotation) {
        this.center = center;
        int n = rotation.axis == EnumFacing.Axis.X ? (rotation.clockwise ? 1 : -1) : (this.rotX = 0);
        int n2 = rotation.axis == EnumFacing.Axis.Y ? (rotation.clockwise ? 1 : -1) : (this.rotY = 0);
        this.rotZ = rotation.axis == EnumFacing.Axis.Z ? (rotation.clockwise ? 1 : -1) : 0;
        this.doubledRotationCenter = new LittleVec(0, 0, 0);
        this.offset = new LittleVecContext();
    }

    public Rotation getRotation(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                if (this.rotX == 0) {
                    return null;
                }
                return Rotation.getRotation((EnumFacing.Axis)axis, (this.rotX > 0 ? 1 : 0) != 0);
            }
            case Y: {
                if (this.rotY == 0) {
                    return null;
                }
                return Rotation.getRotation((EnumFacing.Axis)axis, (this.rotY > 0 ? 1 : 0) != 0);
            }
            case Z: {
                if (this.rotZ == 0) {
                    return null;
                }
                return Rotation.getRotation((EnumFacing.Axis)axis, (this.rotZ > 0 ? 1 : 0) != 0);
            }
        }
        return null;
    }

    public BlockPos transform(BlockPos pos) {
        int i;
        Rotation rotation;
        pos = pos.func_177973_b((Vec3i)this.center);
        if (this.rotX != 0) {
            rotation = this.getRotation(EnumFacing.Axis.X);
            for (i = 0; i < Math.abs(this.rotX); ++i) {
                pos = RotationUtils.rotate((BlockPos)pos, (Rotation)rotation);
            }
        }
        if (this.rotY != 0) {
            rotation = this.getRotation(EnumFacing.Axis.Y);
            for (i = 0; i < Math.abs(this.rotY); ++i) {
                pos = RotationUtils.rotate((BlockPos)pos, (Rotation)rotation);
            }
        }
        if (this.rotZ != 0) {
            rotation = this.getRotation(EnumFacing.Axis.Z);
            for (i = 0; i < Math.abs(this.rotZ); ++i) {
                pos = RotationUtils.rotate((BlockPos)pos, (Rotation)rotation);
            }
        }
        pos = pos.func_177971_a((Vec3i)this.center);
        if (this.offset != null) {
            pos = pos.func_177971_a((Vec3i)this.offset.getBlockPos());
        }
        return pos;
    }

    public void transform(LittleAbsolutePreviews previews) {
        int i;
        Rotation rotation;
        if (this.rotX != 0) {
            rotation = this.getRotation(EnumFacing.Axis.X);
            for (i = 0; i < Math.abs(this.rotX); ++i) {
                previews.rotatePreviews(rotation, this.doubledRotationCenter);
            }
        }
        if (this.rotY != 0) {
            rotation = this.getRotation(EnumFacing.Axis.Y);
            for (i = 0; i < Math.abs(this.rotY); ++i) {
                previews.rotatePreviews(rotation, this.doubledRotationCenter);
            }
        }
        if (this.rotZ != 0) {
            rotation = this.getRotation(EnumFacing.Axis.Z);
            for (i = 0; i < Math.abs(this.rotZ); ++i) {
                previews.rotatePreviews(rotation, this.doubledRotationCenter);
            }
        }
        if (this.offset != null) {
            previews.movePreviews(this.offset.getContext(), this.offset.getVec());
        }
    }

    public int[] array() {
        return new int[]{this.center.func_177958_n(), this.center.func_177956_o(), this.center.func_177952_p(), this.rotX, this.rotY, this.rotZ, this.doubledRotationCenter.x, this.doubledRotationCenter.y, this.doubledRotationCenter.z, this.offset.getVec().x, this.offset.getVec().y, this.offset.getVec().z, this.offset.getContext().size};
    }

    public String toString() {
        return "center:" + this.center.func_177958_n() + "," + this.center.func_177956_o() + "," + this.center.func_177952_p() + ";rotation:" + this.rotX + "," + this.rotY + "," + this.rotZ + ";offset:" + this.offset.getVec().x + "," + this.offset.getVec().y + "," + this.offset.getVec().z + ";context:" + this.offset.getContext();
    }
}

