/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.world;

import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;

public abstract class LittleAnimationHandler {
    public final World world;
    public List<EntityAnimation> openDoors = new CopyOnWriteArrayList<EntityAnimation>();

    public LittleAnimationHandler(World world) {
        if (world == null) {
            throw new RuntimeException("Creating handler for empty world!");
        }
        this.world = world;
    }

    public List<EntityAnimation> findAnimations(AxisAlignedBB bb) {
        if (this.openDoors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityAnimation> doors = new ArrayList<EntityAnimation>();
        for (EntityAnimation door : this.openDoors) {
            if (!door.func_174813_aQ().func_72326_a(bb)) continue;
            doors.add(door);
        }
        return doors;
    }

    public List<LittleDoor> findAnimations(BlockPos pos) {
        if (this.openDoors.isEmpty()) {
            return Collections.emptyList();
        }
        AxisAlignedBB box = new AxisAlignedBB(pos);
        ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
        for (EntityAnimation door : this.openDoors) {
            if (!(door.structure instanceof LittleDoor) || !door.func_174813_aQ().func_72326_a(box) || doors.contains(door.structure)) continue;
            try {
                doors.add(((LittleDoor)door.structure).getParentDoor());
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
        return doors;
    }

    public EntityAnimation findAnimation(UUID uuid) {
        for (EntityAnimation animation : this.openDoors) {
            if (!animation.func_110124_au().equals(uuid)) continue;
            return animation;
        }
        return null;
    }

    public void createDoor(EntityAnimation door) {
        this.openDoors.add(door);
    }

    public void chunkUnload(ChunkEvent.Unload event) {
        this.openDoors.removeIf(x -> {
            if (x.field_70128_L) {
                x.markRemoved();
                return true;
            }
            return false;
        });
    }

    public void worldUnload(WorldEvent.Unload event) {
        this.openDoors.removeIf(x -> {
            if (x.field_70170_p == event.getWorld()) {
                x.markRemoved();
                return true;
            }
            return false;
        });
    }

    public void worldCollision(GetCollisionBoxesEvent event) {
        AxisAlignedBB box = event.getAabb();
        for (EntityAnimation animation : this.findAnimations(box)) {
            if (animation.noCollision || animation.controller.noClip()) continue;
            OrientatedBoundingBox newAlignedBox = animation.origin.getOrientatedBox(box);
            for (OrientatedBoundingBox bb : animation.worldCollisionBoxes) {
                if (!bb.func_72326_a((AxisAlignedBB)newAlignedBox)) continue;
                event.getCollisionBoxesList().add(bb);
            }
        }
    }
}

