/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.events;

import com.sofodev.armorplus.api.lavainfuser.LavaInfuserManager;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.constants.APEnchantments;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.EntitySkeletalKing;
import com.sofodev.armorplus.common.registry.items.ItemFragment;
import com.sofodev.armorplus.common.registry.items.base.ItemSpecialPickaxe;
import com.sofodev.armorplus.common.registry.items.base.special.Pickaxes;
import com.sofodev.armorplus.common.util.Utils;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;
import net.thedragonteam.thedragonlib.util.LogHelper;

@Mod.EventBusSubscriber(modid="armorplus")
public class CommonEventHandler {
    public static Random random = new Random();

    @SubscribeEvent
    public static void onEnchantEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            if (ModConfig.RegistryConfig.enchantments.enableArmorEnhancement && event.phase == TickEvent.Phase.END && !player.field_70170_p.field_72995_K) {
                NonNullList armorInventory = player.field_71071_by.field_70460_b;
                IntStream.range(0, armorInventory.size()).forEach(index -> {
                    ItemStack stack = (ItemStack)armorInventory.get(index);
                    Item item = stack.func_77973_b();
                    if (!(item instanceof ItemArmor)) {
                        return;
                    }
                    ItemArmor armor = (ItemArmor)item;
                    Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
                    boolean enhanceable = enchants.containsKey(ForgeRegistries.ENCHANTMENTS.getValue(Utils.setRL("enhanced")));
                    ItemArmor.ArmorMaterial armorMaterial = armor.func_82812_d();
                    if (enhanceable) {
                        if (armorMaterial == ItemArmor.ArmorMaterial.CHAIN) {
                            CommonEventHandler.enhance((NonNullList<ItemStack>)armorInventory, enchants, stack, ModItems.chain, index);
                        } else if (armorMaterial == ItemArmor.ArmorMaterial.IRON) {
                            CommonEventHandler.enhance((NonNullList<ItemStack>)armorInventory, enchants, stack, ModItems.iron, index);
                        } else if (armorMaterial == ItemArmor.ArmorMaterial.GOLD) {
                            CommonEventHandler.enhance((NonNullList<ItemStack>)armorInventory, enchants, stack, ModItems.gold, index);
                        } else if (armorMaterial == ItemArmor.ArmorMaterial.DIAMOND) {
                            CommonEventHandler.enhance((NonNullList<ItemStack>)armorInventory, enchants, stack, ModItems.diamond, index);
                        } else {
                            enchants.remove(APEnchantments.ENHANCE);
                        }
                    }
                });
            }
        }
    }

    public static void enhance(NonNullList<ItemStack> armorInventory, Map<Enchantment, Integer> enchants, ItemStack stack, ItemArmor[] array, int i) {
        enchants.remove(APEnchantments.ENHANCE);
        EnchantmentHelper.func_82782_a(enchants, (ItemStack)stack);
        NBTTagCompound oldCompound = stack.func_77978_p();
        ItemStack iron = ItemStack.field_190927_a;
        if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.HEAD) {
            iron = new ItemStack((Item)array[0]);
        } else if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.CHEST) {
            iron = new ItemStack((Item)array[1]);
        } else if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.LEGS) {
            iron = new ItemStack((Item)array[2]);
        } else if (EntityLiving.func_184640_d((ItemStack)stack) == EntityEquipmentSlot.FEET) {
            iron = new ItemStack((Item)array[3]);
        }
        if (oldCompound != null) {
            iron.func_77982_d(oldCompound);
        }
        armorInventory.set(i, (Object)iron);
    }

    @SubscribeEvent
    public static void blockHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        Item item;
        ItemStack tool;
        if (!event.getWorld().field_72995_K && event.getHarvester() != null && !(tool = event.getHarvester().func_184614_ca()).func_190926_b() && (item = tool.func_77973_b()) instanceof ItemSpecialPickaxe && ((ItemSpecialPickaxe)item).pickaxes == Pickaxes.INFUSED_LAVA && item.func_150893_a(tool, event.getState()) >= 1.0f) {
            ListIterator<ItemStack> iter = event.getDrops().listIterator();
            while (iter.hasNext()) {
                ItemStack drop = (ItemStack)iter.next();
                ItemStack furnace = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                ItemStack infuser = LavaInfuserManager.getInstance().getInfusingResult(drop);
                ItemStack result = !furnace.func_190926_b() ? furnace : (!infuser.func_190926_b() ? infuser : ItemStack.field_190927_a);
                if (result.func_190926_b()) continue;
                CommonEventHandler.convertDrop(tool, result, drop, iter);
            }
        }
    }

    private static void convertDrop(ItemStack tool, ItemStack result, ItemStack drop, ListIterator<ItemStack> iter) {
        result = result.func_77946_l();
        result.func_190920_e(drop.func_190916_E());
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        if (fortune > 0) {
            result.func_190920_e(result.func_190916_E() * random.nextInt(fortune + 1) + 1);
        }
        iter.set(result);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        int min = 0;
        int max = 1;
        int randomDrop = random.nextInt(max - min + 1) + min;
        Entity entity = event.getEntity();
        if (entity instanceof EntityDragon) {
            CommonEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.ender_dragon_scale.drop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)ModConfig.EntitiesConfig.mob_drops.ender_dragon_scale.dropAmount, (int)3));
            CommonEventHandler.registerTrophyDrop(event, ModConfig.EntitiesConfig.mob_drops.trophy.enableVanillaTrophyDrops, "ender_dragon");
            CommonEventHandler.registerMobDrop(event, true, ItemStackUtils.getItemStack((Object)ModItems.fragments[ItemFragment.Fragments.MIDNIGHT.getIndex()]));
        }
        if (entity instanceof EntityWither) {
            CommonEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.wither_bone.bossDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)ModConfig.EntitiesConfig.mob_drops.wither_bone.dropAmount, (int)2));
            CommonEventHandler.registerTrophyDrop(event, ModConfig.EntitiesConfig.mob_drops.trophy.enableVanillaTrophyDrops, "wither_boss");
            CommonEventHandler.registerMobDrop(event, true, ItemStackUtils.getItemStack((Object)ModItems.fragments[ItemFragment.Fragments.NOON.getIndex()]));
        }
        if (entity instanceof EntityWitherSkeleton) {
            CommonEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.wither_bone.witherSkeletonDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)randomDrop, (int)2));
        }
        if (entity instanceof EntityGuardian) {
            CommonEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.guardian_scale.guardianDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)randomDrop, (int)1));
        }
        if (entity instanceof EntityElderGuardian) {
            CommonEventHandler.registerMobDrop(event, ModConfig.EntitiesConfig.mob_drops.guardian_scale.elderDrop, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)ModConfig.EntitiesConfig.mob_drops.guardian_scale.dropAmount, (int)1));
            CommonEventHandler.registerTrophyDrop(event, ModConfig.EntitiesConfig.mob_drops.trophy.enableVanillaTrophyDrops, "elder_guardian");
            CommonEventHandler.registerMobDrop(event, true, ItemStackUtils.getItemStack((Object)ModItems.fragments[ItemFragment.Fragments.DAWN.getIndex()]));
        }
        if (entity instanceof EntitySkeletalKing) {
            CommonEventHandler.registerTrophyDrop(event, ModConfig.EntitiesConfig.mob_drops.trophy.enableAPBossTrophyDrops, "skeletal_king");
        }
    }

    private static void registerTrophyDrop(LivingDropsEvent event, boolean flag, String mob) {
        CommonEventHandler.registerMobDrop(event, flag, ItemStackUtils.getItemStack((Object)ForgeRegistries.BLOCKS.getValue(Utils.setRL(mob + "_trophy"))));
    }

    private static void registerMobDrop(LivingDropsEvent event, boolean enableDrop, ItemStack drop) {
        if (enableDrop && !event.getEntityLiving().field_70170_p.field_72995_K) {
            event.getEntityLiving().func_70099_a(drop, 0.0f);
            if (ModConfig.DebugConfig.debugMode) {
                LogHelper.info((Object)(event.getEntity().func_70005_c_() + " dropped:" + drop + " x " + drop.func_190916_E()));
            }
        }
    }
}

