/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.client.sprite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.proxy.ClientProxy;

public class FramesTextureData
extends ArrayList<int[][]> {
    private static final Set<TextureAtlasSprite> scheduledToReleaseCache = Collections.newSetFromMap(new WeakHashMap());
    private final TextureAtlasSprite sprite;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !scheduledToReleaseCache.isEmpty()) {
            Iterator<TextureAtlasSprite> iter = scheduledToReleaseCache.iterator();
            while (iter.hasNext()) {
                TextureAtlasSprite sprite = iter.next();
                if (sprite != null) {
                    try {
                        sprite.func_130103_l();
                    }
                    catch (NullPointerException e) {
                        LoliLogger.instance.error("NullPointerException: Trying to clear {}'s FramesTextureData but unable to!", (Object)sprite.func_94215_i());
                    }
                }
                iter.remove();
            }
        }
    }

    public FramesTextureData(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    @Override
    public int[][] get(int index) {
        if (ClientProxy.canReload && super.isEmpty()) {
            this.load();
            Minecraft.func_71410_x().func_152343_a(() -> scheduledToReleaseCache.add(this.sprite));
        }
        return (int[][])super.get(index);
    }

    @Override
    public int size() {
        if (ClientProxy.canReload && super.isEmpty()) {
            this.load();
            Minecraft.func_71410_x().func_152343_a(() -> scheduledToReleaseCache.add(this.sprite));
        }
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        if (ClientProxy.canReload && super.isEmpty()) {
            this.load();
            Minecraft.func_71410_x().func_152343_a(() -> scheduledToReleaseCache.add(this.sprite));
        }
        return super.isEmpty();
    }

    @Override
    public void clear() {
        super.clear();
        this.trimToSize();
    }

    private void load() {
        ResourceLocation location = this.getLocation();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        if (this.sprite.hasCustomLoader(resourceManager, location)) {
            this.sprite.load(resourceManager, location, rl -> textureMap.func_110572_b(rl.toString()));
        } else {
            try (IResource resource = resourceManager.func_110536_a(location);){
                this.sprite.func_188539_a(resource, 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ResourceLocation getLocation() {
        String[] parts = ResourceLocation.func_177516_a((String)this.sprite.func_94215_i());
        return new ResourceLocation(parts[0], String.format("%s/%s%s", Minecraft.func_71410_x().func_147117_R().getBasePath(), parts[1], ".png"));
    }
}

