/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.container.ContainerNull;
import appeng.container.implementations.ContainerMEPortableTerminal;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotCraftingTerm;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperInvItemHandler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class ContainerWirelessCraftingTerminal
extends ContainerMEPortableTerminal
implements IContainerCraftingPacket {
    private final AppEngInternalInventory output = new AppEngInternalInventory(this, 1);
    private final SlotCraftingMatrix[] craftingSlots = new SlotCraftingMatrix[9];
    private final SlotCraftingTerm outputSlot;
    private AppEngInternalInventory craftingGrid;
    private IRecipe currentRecipe;

    public ContainerWirelessCraftingTerminal(InventoryPlayer ip, WirelessTerminalGuiObject gui) {
        super(ip, gui, true);
        AppEngInternalInventory crafting = this.craftingGrid;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotCraftingMatrix slotCraftingMatrix = new SlotCraftingMatrix(this, (IItemHandler)crafting, x + y * 3, 37 + x * 18, -72 + y * 18);
                this.craftingSlots[x + y * 3] = slotCraftingMatrix;
                this.func_75146_a(slotCraftingMatrix);
            }
        }
        this.outputSlot = new SlotCraftingTerm(this.getPlayerInv().field_70458_d, this.getActionSource(), this.getPowerSource(), this.wirelessTerminalGUIObject, (IItemHandler)crafting, (IItemHandler)crafting, (IItemHandler)this.output, 131, -54, this);
        this.func_75146_a(this.outputSlot);
        this.func_75130_a(new WrapperInvItemHandler((IItemHandler)crafting));
    }

    public void func_75130_a(IInventory inventory) {
        ContainerNull cn = new ContainerNull();
        InventoryCrafting ic = new InventoryCrafting((Container)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.func_70299_a(x, this.craftingSlots[x].func_75211_c());
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a(ic, this.getPlayerInv().field_70458_d.field_70170_p)) {
            this.currentRecipe = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)this.getPlayerInv().field_70458_d.field_70170_p);
        }
        if (this.currentRecipe == null) {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            ItemStack craftingResult = this.currentRecipe.func_77572_b(ic);
            this.outputSlot.func_75215_d(craftingResult);
        }
    }

    @Override
    public void saveChanges() {
        if (Platform.isServer()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.craftingGrid.writeToNBT(tag, "craftingGrid");
            this.upgrades.writeToNBT(tag, "upgrades");
            this.wirelessTerminalGUIObject.saveChanges(tag);
        }
    }

    @Override
    protected void loadFromNBT() {
        super.loadFromNBT();
        this.craftingGrid = new AppEngInternalInventory(this, 9);
        NBTTagCompound data = this.wirelessTerminalGUIObject.getItemStack().func_77978_p();
        if (data != null) {
            this.craftingGrid.readFromNBT(data, "craftingGrid");
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.craftingGrid) {
            this.saveChanges();
        }
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getInventoryPlayer());
        }
        if (name.equals("crafting")) {
            return this.craftingGrid;
        }
        return null;
    }

    @Override
    public boolean useRealItems() {
        return true;
    }
}

