/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.IUpgradeableCellContainer;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.ContainerPatternEncoder;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.InvOperation;
import baubles.api.BaublesApi;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class ContainerWirelessPatternTerminal
extends ContainerPatternEncoder
implements IUpgradeableCellContainer,
IInventorySlotAware {
    private final WirelessTerminalGuiObject wirelessTerminalGUIObject;
    private final int slot;
    protected AppEngInternalInventory output;
    protected AppEngInternalInventory pattern;
    protected AppEngInternalInventory upgrades;
    protected SlotRestrictedInput magnetSlot;
    private double powerMultiplier = 0.5;
    private int ticks = 0;

    public ContainerWirelessPatternTerminal(InventoryPlayer ip, WirelessTerminalGuiObject gui) {
        super(ip, gui, gui, false);
        int y;
        this.crafting = new AppEngInternalInventory(this, 9);
        this.output = new AppEngInternalInventory(this, 3);
        this.pattern = new AppEngInternalInventory(this, 2);
        this.craftingSlots = new SlotFakeCraftingMatrix[9];
        this.outputSlots = new OptionalSlotFake[3];
        if (gui != null) {
            int slotIndex = gui.getInventorySlot();
            if (!gui.isBaubleSlot()) {
                this.lockPlayerInventorySlot(slotIndex);
            }
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_70461_c);
        }
        this.wirelessTerminalGUIObject = gui;
        this.upgrades = new StackUpgradeInventory(this.wirelessTerminalGUIObject.getItemStack(), this, 2);
        this.loadFromNBT();
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix(this.crafting, x + y * 3, 18 + x * 18, -76 + y * 18);
                this.craftingSlots[x + y * 3] = slotFakeCraftingMatrix;
                this.func_75146_a(slotFakeCraftingMatrix);
            }
        }
        this.craftSlot = new SlotPatternTerm(ip.field_70458_d, this.getActionSource(), this.getPowerSource(), gui, this.crafting, (IItemHandler)this.pattern, (IItemHandler)this.cOut, 110, -58, this, 2, this);
        this.func_75146_a(this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (y = 0; y < this.outputSlots.length; ++y) {
            this.outputSlots[y] = new SlotPatternOutputs((IItemHandler)this.output, this, y, 110, -76 + y * 18, 0, 0, 1);
            this.func_75146_a(this.outputSlots[y]);
            this.outputSlots[y].setRenderDisabled(false);
            this.outputSlots[y].setIIcon(-1);
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, (IItemHandler)this.pattern, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, (IItemHandler)this.pattern, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.updateOrderOfOutputSlots();
        this.bindPlayerInventory(ip, 0, 0);
        this.setupUpgrades();
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            ItemStack currentItem;
            if (this.wirelessTerminalGUIObject.isBaubleSlot()) {
                currentItem = BaublesApi.getBaublesHandler((EntityPlayer)this.getPlayerInv().field_70458_d).getStackInSlot(this.slot);
            } else {
                ItemStack itemStack = currentItem = this.slot < 0 ? this.getPlayerInv().func_70448_g() : this.getPlayerInv().func_70301_a(this.slot);
            }
            if (currentItem.func_190926_b()) {
                this.setValidContainer(false);
            } else if (!this.wirelessTerminalGUIObject.getItemStack().func_190926_b() && currentItem != this.wirelessTerminalGUIObject.getItemStack() && !ItemStack.func_179545_c((ItemStack)this.wirelessTerminalGUIObject.getItemStack(), (ItemStack)currentItem)) {
                this.setValidContainer(false);
            }
            ++this.ticks;
            if (this.ticks > 10) {
                double ext = this.wirelessTerminalGUIObject.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (ext < this.getPowerMultiplier() * (double)this.ticks) {
                    if (Platform.isServer() && this.isValidContainer()) {
                        this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.DeviceNotPowered.get());
                    }
                    this.setValidContainer(false);
                }
                this.ticks = 0;
            }
            if (!this.wirelessTerminalGUIObject.rangeCheck()) {
                if (Platform.isServer() && this.isValidContainer()) {
                    this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.OutOfRange.get());
                }
                this.setValidContainer(false);
            } else {
                this.setPowerMultiplier(AEConfig.instance().wireless_getDrainRate(this.wirelessTerminalGUIObject.getRange()));
            }
            super.func_75142_b();
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId < this.field_75151_b.size() && clickTypeIn == ClickType.PICKUP && dragType == 1 && this.field_75151_b.get(slotId) == this.magnetSlot) {
            ItemStack itemStack = this.magnetSlot.func_75211_c();
            if (!this.magnetSlot.func_75211_c().func_190926_b()) {
                NBTTagCompound tag = itemStack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                if (tag.func_74764_b("enabled")) {
                    boolean e = tag.func_74767_n("enabled");
                    tag.func_74757_a("enabled", !e);
                } else {
                    tag.func_74757_a("enabled", false);
                }
                this.magnetSlot.func_75211_c().func_77982_d(tag);
                this.magnetSlot.func_75218_e();
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        NBTTagCompound nbtTagCompound;
        boolean crafting = false;
        if (Platform.isServer() && (nbtTagCompound = this.iGuiItemObject.getItemStack().func_77978_p()) != null && nbtTagCompound.func_74764_b("isCraftingMode")) {
            crafting = nbtTagCompound.func_74767_n("isCraftingMode");
        }
        if (idx == 1) {
            return Platform.isServer() ? !crafting : !this.isCraftingMode();
        }
        if (idx == 2) {
            return Platform.isServer() ? crafting : this.isCraftingMode();
        }
        return false;
    }

    @Override
    public void saveChanges() {
        if (Platform.isServer()) {
            NBTTagCompound tag = new NBTTagCompound();
            ((AppEngInternalInventory)this.crafting).writeToNBT(tag, "craftingGrid");
            this.output.writeToNBT(tag, "output");
            this.pattern.writeToNBT(tag, "patterns");
            this.upgrades.writeToNBT(tag, "upgrades");
            this.wirelessTerminalGUIObject.saveChanges(tag);
        }
    }

    private void loadFromNBT() {
        NBTTagCompound data = this.wirelessTerminalGUIObject.getItemStack().func_77978_p();
        if (data != null) {
            ((AppEngInternalInventory)this.crafting).readFromNBT(data, "craftingGrid");
            this.output.readFromNBT(data, "output");
            this.pattern.readFromNBT(data, "patterns");
            this.upgrades.readFromNBT(this.wirelessTerminalGUIObject.getItemStack().func_77978_p().func_74775_l("upgrades"));
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem pattern;
        ICraftingPatternDetails details;
        ItemStack is;
        if (inv == this.pattern && slot == 1 && !(is = this.pattern.getStackInSlot(1)).func_190926_b() && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getPlayerInv().field_70458_d.field_70170_p)) != null) {
            IAEItemStack item;
            int x;
            this.setCraftingMode(details.isCraftable());
            this.setSubstitute(details.canSubstitute());
            for (x = 0; x < this.crafting.getSlots() && x < details.getInputs().length; ++x) {
                item = details.getInputs()[x];
                ItemHandlerUtil.setStackInSlot(this.crafting, x, item == null ? ItemStack.field_190927_a : item.createItemStack());
            }
            for (x = 0; x < this.output.getSlots(); ++x) {
                item = x < details.getOutputs().length ? details.getOutputs()[x] : null;
                this.output.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
            }
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void setupUpgrades() {
        if (this.wirelessTerminalGUIObject != null) {
            for (int upgradeSlot = 0; upgradeSlot < this.availableUpgrades(); ++upgradeSlot) {
                this.magnetSlot = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, (IItemHandler)this.upgrades, upgradeSlot, 206, 135 + upgradeSlot * 18, this.getInventoryPlayer());
                this.magnetSlot.setNotDraggable();
                this.func_75146_a(this.magnetSlot);
            }
        }
    }

    @Override
    public int getInventorySlot() {
        return this.wirelessTerminalGUIObject.getInventorySlot();
    }

    @Override
    public boolean isBaubleSlot() {
        return this.wirelessTerminalGUIObject.isBaubleSlot();
    }
}

