/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.powered.Terminal;
import appeng.util.Platform;
import baubles.api.BaublesApi;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class PacketTerminalUse
extends AppEngPacket {
    Terminal terminal;

    public PacketTerminalUse(ByteBuf stream) {
        this.terminal = Terminal.values()[stream.readInt()];
    }

    public PacketTerminalUse(Enum<Terminal> terminal) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(terminal.ordinal());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ItemStack is;
        int i;
        NonNullList mainInventory = player.field_71071_by.field_70462_a;
        for (i = 0; i < mainInventory.size(); ++i) {
            is = (ItemStack)mainInventory.get(i);
            if (!this.terminal.getItemDefinition().isSameAs(is)) continue;
            this.openGui(is, i, player, false);
            return;
        }
        for (i = 0; i < BaublesApi.getBaublesHandler((EntityPlayer)player).getSlots(); ++i) {
            is = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i);
            if (!this.terminal.getItemDefinition().isSameAs(is)) continue;
            this.openGui(is, i, player, true);
            break;
        }
    }

    void openGui(ItemStack itemStack, int slotIdx, EntityPlayer player, boolean isBauble) {
        IWirelessTermHandler handler = AEApi.instance().registries().wireless().getWirelessTerminalHandler(itemStack);
        if (handler == null) {
            return;
        }
        String unparsedKey = handler.getEncryptionKey(itemStack);
        if (unparsedKey.isEmpty()) {
            player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
            return;
        }
        long parsedKey = Long.parseLong(unparsedKey);
        ILocatable securityStation = AEApi.instance().registries().locatable().getLocatableBy(parsedKey);
        if (securityStation == null) {
            player.func_145747_a(PlayerMessages.StationCanNotBeLocated.get());
            return;
        }
        if (handler.hasPower(player, 0.5, itemStack)) {
            Platform.openGUI(player, slotIdx, this.terminal.getBridge(), isBauble);
        } else {
            player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
        }
    }
}

