/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.transformer;

import appeng.core.AE2ELCore;
import appeng.core.transformer.ItemStackPatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.Loader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AE2ELTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Consumer<ClassNode> consumer;
        if (Loader.instance().getIndexedModList().get("stackup") != null) {
            return basicClass;
        }
        transformedName = transformedName.replace('/', '.');
        Consumer<ClassNode> emptyConsumer = consumer = n -> {};
        if ("net.minecraft.item.ItemStack".equals(transformedName)) {
            consumer = consumer.andThen(ItemStackPatch::patchCountGetSet);
        } else if ("net.minecraft.network.PacketBuffer".equals(transformedName)) {
            consumer = consumer.andThen(node -> AE2ELTransformer.spliceClasses(node, "appeng.core.transformer.PacketBufferPatch", "readItemStack", "func_150791_c", "writeItemStack", "func_150788_a"));
        }
        if (consumer != emptyConsumer) {
            return AE2ELTransformer.processNode(basicClass, consumer);
        }
        return basicClass;
    }

    public static byte[] processNode(byte[] data, Consumer<ClassNode> classNodeConsumer) {
        ClassReader reader = new ClassReader(data);
        ClassNode nodeOrig = new ClassNode();
        reader.accept((ClassVisitor)nodeOrig, 0);
        classNodeConsumer.accept(nodeOrig);
        ClassWriter writer = new ClassWriter(0);
        nodeOrig.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void spliceClasses(ClassNode data, String className, String ... methods) {
        try (InputStream stream = AE2ELCore.class.getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");){
            AE2ELTransformer.spliceClasses(data, ByteStreams.toByteArray((InputStream)stream), className, methods);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void spliceClasses(ClassNode nodeData, byte[] dataSplice, String className, String ... methods) {
        int j;
        boolean added;
        MethodNode mn;
        int i;
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a AE2EL bug!");
        }
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        ArrayList methodList = Lists.newArrayList((Object[])methods);
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept((ClassVisitor)new ClassRemapper((ClassVisitor)nodeSplice, remapper), 8);
        for (String s : nodeSplice.interfaces) {
            if (!methodSet.contains(s)) continue;
            nodeData.interfaces.add(s);
            System.out.println("Added INTERFACE: " + s);
        }
        for (i = 0; i < nodeSplice.methods.size(); ++i) {
            if (!methodSet.contains(((MethodNode)nodeSplice.methods.get((int)i)).name)) continue;
            mn = (MethodNode)nodeSplice.methods.get(i);
            added = false;
            for (j = 0; j < nodeData.methods.size(); ++j) {
                if (!((MethodNode)nodeData.methods.get((int)j)).name.equals(mn.name) || !((MethodNode)nodeData.methods.get((int)j)).desc.equals(mn.desc)) continue;
                MethodNode oldMn = (MethodNode)nodeData.methods.get(j);
                System.out.println("Spliced in METHOD: " + targetClassName + "." + mn.name);
                nodeData.methods.set(j, mn);
                if (nodeData.name.equals(nodeSplice.superName)) {
                    for (AbstractInsnNode node : mn.instructions) {
                        if (!(node instanceof MethodInsnNode) || node.getOpcode() != 183) continue;
                        MethodInsnNode methodNode = (MethodInsnNode)node;
                        if (!targetClassName2.equals(methodNode.owner)) continue;
                        methodNode.owner = nodeData.superName;
                    }
                }
                oldMn.name = (String)methodList.get(methodList.indexOf(oldMn.name) & 0xFFFFFFFE) + "_ae2el_old";
                nodeData.methods.add(oldMn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added METHOD: " + targetClassName + "." + mn.name);
            nodeData.methods.add(mn);
            added = true;
        }
        for (i = 0; i < nodeSplice.fields.size(); ++i) {
            if (!methodSet.contains(((FieldNode)nodeSplice.fields.get((int)i)).name)) continue;
            mn = (FieldNode)nodeSplice.fields.get(i);
            added = false;
            for (j = 0; j < nodeData.fields.size(); ++j) {
                if (!((FieldNode)nodeData.fields.get((int)j)).name.equals(mn.name) || !((FieldNode)nodeData.fields.get((int)j)).desc.equals(mn.desc)) continue;
                System.out.println("Spliced in FIELD: " + targetClassName + "." + mn.name);
                nodeData.fields.set(j, mn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added FIELD: " + targetClassName + "." + mn.name);
            nodeData.fields.add(mn);
            added = true;
        }
    }
}

