/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.IUpgradeableCellContainer;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEFluidInventoryUpdate;
import appeng.core.sync.packets.PacketTargetFluidStack;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.InventoryAction;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import baubles.api.BaublesApi;
import java.io.IOException;
import java.nio.BufferOverflowException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;

public class ContainerMEPortableFluidCell
extends AEBaseContainer
implements IAEAppEngInventory,
IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEFluidStack>,
IUpgradeableCellContainer,
IInventorySlotAware {
    protected final WirelessTerminalGuiObject wirelessTerminalGUIObject;
    private final IConfigManager clientCM;
    private final IMEMonitor<IAEFluidStack> monitor;
    private final IItemList<IAEFluidStack> fluids = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    @GuiSync(value=99)
    public boolean hasPower = false;
    private final ITerminalHost terminal;
    private IConfigManager serverCM;
    private IConfigManagerHost gui;
    private IGridNode networkNode;
    private IAEFluidStack clientRequestedTargetFluid = null;
    private double powerMultiplier = 0.5;
    private int ticks = 0;
    private final int slot;
    protected AppEngInternalInventory upgrades;

    public ContainerMEPortableFluidCell(InventoryPlayer ip, IPortableCell monitorable) {
        this(ip, monitorable, null, true);
    }

    public ContainerMEPortableFluidCell(InventoryPlayer ip, IPortableCell monitorable, WirelessTerminalGuiObject iGuiItemObject) {
        this(ip, monitorable, iGuiItemObject, true);
    }

    public ContainerMEPortableFluidCell(InventoryPlayer ip, IPortableCell monitorable, WirelessTerminalGuiObject iGuiItemObject, boolean bindInventory) {
        super(ip, monitorable);
        this.terminal = monitorable;
        this.wirelessTerminalGUIObject = (WirelessTerminalGuiObject)monitorable;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        if (Platform.isServer()) {
            this.serverCM = this.terminal.getConfigManager();
            this.monitor = this.terminal.getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            if (this.monitor != null) {
                this.monitor.addListener(this, null);
                this.setPowerSource((IEnergySource)((Object)this.terminal));
                IGridNode node = this.terminal instanceof IGridHost ? ((IGridHost)((Object)this.terminal)).getGridNode(AEPartLocation.INTERNAL) : ((IActionHost)((Object)this.terminal)).getActionableNode();
                if (node != null) {
                    this.networkNode = node;
                }
            }
        } else {
            this.monitor = null;
        }
        if (monitorable != null) {
            int slotIndex = ((IInventorySlotAware)((Object)monitorable)).getInventorySlot();
            if (!((IInventorySlotAware)((Object)monitorable)).isBaubleSlot()) {
                this.lockPlayerInventorySlot(slotIndex);
            }
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_70461_c);
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 140);
        }
        this.hasPower = this.wirelessTerminalGUIObject.extractAEPower(this.getPowerMultiplier(), Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.001;
        this.upgrades = new StackUpgradeInventory(this.wirelessTerminalGUIObject.getItemStack(), this, 2);
        this.loadFromNBT();
        this.setupUpgrades();
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            ItemStack currentItem;
            if (this.wirelessTerminalGUIObject.isBaubleSlot()) {
                currentItem = BaublesApi.getBaublesHandler((EntityPlayer)this.getPlayerInv().field_70458_d).getStackInSlot(this.slot);
            } else {
                ItemStack itemStack = currentItem = this.slot < 0 ? this.getPlayerInv().func_70448_g() : this.getPlayerInv().func_70301_a(this.slot);
            }
            if (currentItem.func_190926_b()) {
                this.setValidContainer(false);
            } else if (!this.wirelessTerminalGUIObject.getItemStack().func_190926_b() && currentItem != this.wirelessTerminalGUIObject.getItemStack() && !ItemStack.func_179545_c((ItemStack)this.wirelessTerminalGUIObject.getItemStack(), (ItemStack)currentItem)) {
                this.setValidContainer(false);
            }
            ++this.ticks;
            if (this.ticks > 10) {
                double ext = this.wirelessTerminalGUIObject.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (ext < this.getPowerMultiplier() * (double)this.ticks) {
                    if (Platform.isServer() && this.isValidContainer()) {
                        this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.DeviceNotPowered.get());
                    }
                    this.setValidContainer(false);
                }
                this.ticks = 0;
                boolean bl = this.hasPower = ext > 0.001;
            }
            if (!this.wirelessTerminalGUIObject.rangeCheck()) {
                if (Platform.isServer() && this.isValidContainer()) {
                    this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.OutOfRange.get());
                }
                this.setValidContainer(false);
            } else {
                this.setPowerMultiplier(AEConfig.instance().wireless_getDrainRate(this.wirelessTerminalGUIObject.getRange()));
            }
            if (this.monitor != this.terminal.getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class))) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum<?> sideRemote;
                Enum<?> sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (IContainerListener crafter : this.field_75149_d) {
                    if (!(crafter instanceof EntityPlayerMP)) continue;
                    try {
                        NetworkHandler.instance().sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        AELog.debug(e);
                    }
                }
            }
            if (!this.fluids.isEmpty()) {
                try {
                    IItemList<IAEFluidStack> monitorCache = this.monitor.getStorageList();
                    PacketMEFluidInventoryUpdate piu = new PacketMEFluidInventoryUpdate();
                    for (IAEFluidStack is : this.fluids) {
                        IAEFluidStack send = monitorCache.findPrecise(is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendFluid(is);
                            continue;
                        }
                        piu.appendFluid(send);
                    }
                    if (!piu.isEmpty()) {
                        this.fluids.resetStatus();
                        for (IAEFluidStack c : this.field_75149_d) {
                            if (!(c instanceof EntityPlayer)) continue;
                            NetworkHandler.instance().sendTo(piu, (EntityPlayerMP)c);
                        }
                    }
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
            }
            super.func_75142_b();
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return ItemStack.field_190927_a;
        }
        EntityPlayerMP player = (EntityPlayerMP)p;
        if (this.field_75151_b.get(idx) instanceof SlotPlayerInv || this.field_75151_b.get(idx) instanceof SlotPlayerHotBar) {
            AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_75151_b.get(idx));
            ItemStack itemStack = clickSlot.func_75211_c();
            ItemStack copy = itemStack.func_77946_l();
            copy.func_190920_e(1);
            IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)copy);
            if (fh == null) {
                return ItemStack.field_190927_a;
            }
            int heldAmount = itemStack.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                IAEFluidStack spill;
                copy = itemStack.func_77946_l();
                copy.func_190920_e(1);
                fh = FluidUtil.getFluidHandler((ItemStack)copy);
                FluidStack extract = fh.drain(Integer.MAX_VALUE, false);
                if (extract == null || extract.amount < 1) {
                    return ItemStack.field_190927_a;
                }
                IAEFluidStack notStorable = Platform.poweredInsert(this.getPowerSource(), this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource(), Actionable.SIMULATE);
                if (notStorable != null && notStorable.getStackSize() > 0L) {
                    int toStore = (int)((long)extract.amount - notStorable.getStackSize());
                    FluidStack storable = fh.drain(toStore, false);
                    if (storable == null || storable.amount == 0) {
                        return ItemStack.field_190927_a;
                    }
                    extract.amount = storable.amount;
                }
                FluidStack drained = fh.drain(extract, true);
                extract.amount = drained.amount;
                IAEFluidStack notInserted = Platform.poweredInsert(this.getPowerSource(), this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L && (spill = this.monitor.injectItems(notInserted, Actionable.MODULATE, this.getActionSource())) != null && spill.getStackSize() > 0L) {
                    fh.fill(spill.getFluidStack(), true);
                }
                if (notInserted != null && notInserted.getStackSize() != 0L) continue;
                if (!player.field_71071_by.func_70441_a(fh.getContainer())) {
                    player.func_71019_a(fh.getContainer(), false);
                }
                clickSlot.func_75209_a(1);
            }
            this.func_75142_b();
            return ItemStack.field_190927_a;
        }
        return super.func_82846_b(p, idx);
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            super.doAction(player, action, slot, id);
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        ItemStack heldCopy = held.func_77946_l();
        heldCopy.func_190920_e(1);
        IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)heldCopy);
        if (fh == null) {
            return;
        }
        if (action == InventoryAction.FILL_ITEM && this.clientRequestedTargetFluid != null) {
            IAEFluidStack stack = this.clientRequestedTargetFluid.copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = fh.fill(stack.getFluidStack(), false);
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                ItemStack copiedFluidContainer = held.func_77946_l();
                copiedFluidContainer.func_190920_e(1);
                fh = FluidUtil.getFluidHandler((ItemStack)copiedFluidContainer);
                IAEFluidStack canPull = Platform.poweredExtraction(this.getPowerSource(), this.monitor, stack.setStackSize(amountAllowed), this.getActionSource(), Actionable.SIMULATE);
                if (canPull == null || canPull.getStackSize() < 1L) {
                    return;
                }
                int canFill = fh.fill(canPull.getFluidStack(), false);
                if (canFill == 0) {
                    return;
                }
                IAEFluidStack pulled = Platform.poweredExtraction(this.getPowerSource(), this.monitor, stack.setStackSize(canFill), this.getActionSource());
                if (pulled == null || pulled.getStackSize() < 1L) {
                    AELog.error("Unable to pull fluid out of the ME system even though the simulation said yes ", new Object[0]);
                    return;
                }
                int used = fh.fill(pulled.getFluidStack(), true);
                if (used != canFill) {
                    AELog.error("Fluid item [%s] reported a different possible amount than it actually accepted.", held.func_82833_r());
                }
                if (held.func_190916_E() == 1) {
                    player.field_71071_by.func_70437_b(fh.getContainer());
                    continue;
                }
                player.field_71071_by.func_70445_o().func_190918_g(1);
                if (player.field_71071_by.func_70441_a(fh.getContainer())) continue;
                player.func_71019_a(fh.getContainer(), false);
            }
            this.updateHeld(player);
        } else if (action == InventoryAction.EMPTY_ITEM) {
            int heldAmount = held.func_190916_E();
            for (int i = 0; i < heldAmount; ++i) {
                IAEFluidStack spill;
                ItemStack copiedFluidContainer = held.func_77946_l();
                copiedFluidContainer.func_190920_e(1);
                fh = FluidUtil.getFluidHandler((ItemStack)copiedFluidContainer);
                FluidStack extract = fh.drain(Integer.MAX_VALUE, false);
                if (extract == null || extract.amount < 1) {
                    return;
                }
                IAEFluidStack notStorable = Platform.poweredInsert(this.getPowerSource(), this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource(), Actionable.SIMULATE);
                if (notStorable != null && notStorable.getStackSize() > 0L) {
                    int toStore = (int)((long)extract.amount - notStorable.getStackSize());
                    FluidStack storable = fh.drain(toStore, false);
                    if (storable == null || storable.amount == 0) {
                        return;
                    }
                    extract.amount = storable.amount;
                }
                FluidStack drained = fh.drain(extract, true);
                extract.amount = drained.amount;
                IAEFluidStack notInserted = Platform.poweredInsert(this.getPowerSource(), this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L && (spill = this.monitor.injectItems(notInserted, Actionable.MODULATE, this.getActionSource())) != null && spill.getStackSize() > 0L) {
                    fh.fill(spill.getFluidStack(), true);
                }
                if (held.func_190916_E() == 1) {
                    player.field_71071_by.func_70437_b(fh.getContainer());
                    continue;
                }
                player.field_71071_by.func_70445_o().func_190918_g(1);
                if (player.field_71071_by.func_70441_a(fh.getContainer())) continue;
                player.func_71019_a(fh.getContainer(), false);
            }
            this.updateHeld(player);
        }
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add(is);
        }
    }

    @Override
    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.queueInventory(c);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.queueInventory(listener);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    private void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEFluidInventoryUpdate piu = new PacketMEFluidInventoryUpdate();
                IItemList<IAEFluidStack> monitorCache = this.monitor.getStorageList();
                for (IAEFluidStack send : monitorCache) {
                    try {
                        piu.appendFluid(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance().sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEFluidInventoryUpdate();
                        piu.appendFluid(send);
                    }
                }
                NetworkHandler.instance().sendTo(piu, (EntityPlayerMP)c);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    public void setTargetStack(IAEFluidStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetFluid == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetFluid != null && stack.getFluidStack().isFluidEqual(this.clientRequestedTargetFluid.getFluidStack())) {
                return;
            }
            NetworkHandler.instance().sendToServer(new PacketTargetFluidStack((AEFluidStack)stack));
        }
        this.clientRequestedTargetFluid = stack == null ? null : stack.copy();
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void setupUpgrades() {
        if (this.wirelessTerminalGUIObject != null) {
            for (int upgradeSlot = 0; upgradeSlot < this.availableUpgrades(); ++upgradeSlot) {
                this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, (IItemHandler)this.upgrades, upgradeSlot, 183, 139 + upgradeSlot * 18, this.getInventoryPlayer()).setNotDraggable());
            }
        }
    }

    @Override
    public void saveChanges() {
        if (Platform.isServer()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.upgrades.writeToNBT(tag, "upgrades");
            this.wirelessTerminalGUIObject.saveChanges(tag);
        }
    }

    private void loadFromNBT() {
        NBTTagCompound data = this.wirelessTerminalGUIObject.getItemStack().func_77978_p();
        if (data != null) {
            this.upgrades.readFromNBT(this.wirelessTerminalGUIObject.getItemStack().func_77978_p().func_74775_l("upgrades"));
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    public int getInventorySlot() {
        return this.wirelessTerminalGUIObject.getInventorySlot();
    }

    @Override
    public boolean isBaubleSlot() {
        return this.wirelessTerminalGUIObject.isBaubleSlot();
    }
}

