/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.brewing;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.brewing.IBrewingAction;
import crafttweaker.mc1120.brewing.MultiBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class ActionAddBrewingRecipe
implements IBrewingAction {
    private final MultiBrewingRecipe recipe;
    private final String outName;
    private final boolean valid;

    public ActionAddBrewingRecipe(IIngredient input, IIngredient[] ingredients, IItemStack output, boolean hidden) {
        this.outName = output.toString();
        this.recipe = new MultiBrewingRecipe(input, ingredients, output, !hidden);
        this.valid = this.recipe.isValid();
    }

    @Override
    public void apply() {
        if (!this.valid) {
            CraftTweakerAPI.logError(String.format("Brewing recipe for %s is invalid", this.outName));
            return;
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)this.recipe);
    }

    @Override
    public String describe() {
        return "Adding brewing recipe for " + this.outName + ", Registry size now: " + BrewingRecipeRegistry.getRecipes().size();
    }
}

