/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.slot;

import com.google.common.collect.ImmutableList;
import gigaherz.toolbelt.Config;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlot;
import gigaherz.toolbelt.network.SyncBeltSlotContents;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ExtensionSlotBelt
implements IExtensionContainer,
INBTSerializable<NBTTagCompound> {
    private static final ResourceLocation CAPABILITY_ID = new ResourceLocation("toolbelt", "belt_slot");
    @CapabilityInject(value=ExtensionSlotBelt.class)
    public static Capability<ExtensionSlotBelt> CAPABILITY = null;
    public static final ResourceLocation BELT = new ResourceLocation("examplemod", "belt");
    private final EntityLivingBase owner;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ExtensionSlotBelt.this.belt.onContentsChanged();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!Config.customBeltSlotEnabled) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlotLimit(int slot) {
            if (!Config.customBeltSlotEnabled) {
                return 0;
            }
            return super.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!Config.customBeltSlotEnabled) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }
    };
    private final ExtensionSlotItemHandler belt = new ExtensionSlotItemHandler(this, BELT, (IItemHandlerModifiable)this.inventory, 0);
    private final ImmutableList<IExtensionSlot> slots = ImmutableList.of((Object)this.belt);

    public static void register() {
        CapabilityManager.INSTANCE.register(ExtensionSlotBelt.class, (Capability.IStorage)new Capability.IStorage<ExtensionSlotBelt>(){

            @Nullable
            public NBTBase writeNBT(Capability<ExtensionSlotBelt> capability, ExtensionSlotBelt instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ExtensionSlotBelt> capability, ExtensionSlotBelt instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, () -> {
            throw new UnsupportedOperationException("Cannot instantiate extension slots without a player, use the class constructor.");
        });
        MinecraftForge.EVENT_BUS.register((Object)new AttachHandlers());
        if (Config.customBeltSlotEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
        } else {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlers.Disabled());
        }
    }

    public static ExtensionSlotBelt get(EntityLivingBase player) {
        return (ExtensionSlotBelt)player.getCapability(CAPABILITY, null);
    }

    private void dropContents() {
        for (IExtensionSlot slot : this.slots) {
            ItemStack stack = slot.getContents();
            if (stack.func_190916_E() <= 0) continue;
            if (this.owner instanceof EntityPlayer) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)this.owner), (ItemStack)stack);
            } else {
                this.owner.func_70099_a(stack, 0.1f);
            }
            slot.setContents(ItemStack.field_190927_a);
        }
    }

    private void syncToSelf() {
        this.syncTo((EntityPlayer)((EntityPlayerMP)this.owner));
    }

    protected void syncTo(EntityPlayer target) {
        SyncBeltSlotContents message = new SyncBeltSlotContents((EntityPlayer)this.owner, this);
        ToolBelt.channel.sendTo((IMessage)message, (EntityPlayerMP)target);
    }

    protected void syncToSelfAndTracking() {
        SyncBeltSlotContents message = new SyncBeltSlotContents((EntityPlayer)this.owner, this);
        ToolBelt.channel.sendToAllTracking((IMessage)message, (Entity)this.owner);
        ToolBelt.channel.sendTo((IMessage)message, (EntityPlayerMP)this.owner);
    }

    private ExtensionSlotBelt(EntityLivingBase owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public EntityLivingBase getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ImmutableList<IExtensionSlot> getSlots() {
        return this.slots;
    }

    @Override
    public void onContentsChanged(IExtensionSlot slot) {
    }

    @Nonnull
    public IExtensionSlot getBelt() {
        return this.belt;
    }

    private void tickAllSlots() {
        for (IExtensionSlot slot : this.slots) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    public void setAll(NonNullList<ItemStack> stacks) {
        ImmutableList<IExtensionSlot> slots = this.getSlots();
        for (int i = 0; i < slots.size(); ++i) {
            ((IExtensionSlot)slots.get(i)).setContents((ItemStack)stacks.get(i));
        }
    }

    public NBTTagCompound serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt);
    }

    private static class EventHandlers {
        private Random rand = new Random();

        private EventHandlers() {
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerLoggedInEvent event) {
            EntityPlayer target = event.player;
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)target);
            if (Config.customBeltSlotEnabled) {
                if (instance == null) {
                    return;
                }
                instance.syncToSelf();
            }
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerChangedDimensionEvent event) {
            EntityPlayer target = event.player;
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)target);
            if (Config.customBeltSlotEnabled) {
                if (instance == null) {
                    return;
                }
                instance.syncToSelf();
            }
        }

        @SubscribeEvent
        public void track(PlayerEvent.StartTracking event) {
            Entity target = event.getTarget();
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            if (target instanceof EntityPlayer) {
                ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)target);
                if (Config.customBeltSlotEnabled) {
                    if (instance == null) {
                        return;
                    }
                    instance.syncTo(event.getEntityPlayer());
                }
            }
        }

        @SubscribeEvent
        public void entityTick(TickEvent.PlayerTickEvent event) {
            ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)event.player);
            if (instance == null) {
                return;
            }
            instance.tickAllSlots();
        }

        @SubscribeEvent
        public void playerDeath(PlayerDropsEvent event) {
            EntityPlayer player = event.getEntityPlayer();
            ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)player);
            if (instance == null) {
                return;
            }
            IExtensionSlot belt = instance.getBelt();
            ItemStack stack = belt.getContents();
            if (EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                stack = ItemStack.field_190927_a;
                belt.setContents(stack);
            }
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !player.func_175149_v() && stack.func_190916_E() > 0) {
                event.getDrops().add(this.prepareDrop(player, stack, true));
                belt.setContents(ItemStack.field_190927_a);
            }
        }

        @SubscribeEvent
        public void playerClone(PlayerEvent.Clone event) {
            EntityPlayer oldPlayer = event.getOriginal();
            EntityPlayer newPlayer = event.getEntityPlayer();
            ExtensionSlotBelt oldBelt = ExtensionSlotBelt.get((EntityLivingBase)oldPlayer);
            ExtensionSlotBelt newBelt = ExtensionSlotBelt.get((EntityLivingBase)newPlayer);
            if (oldBelt == null) {
                return;
            }
            ItemStack stack = oldBelt.getBelt().getContents();
            if (newBelt == null) {
                if (stack.func_190916_E() > 0) {
                    oldPlayer.func_146097_a(stack, true, false);
                }
            } else {
                newBelt.getBelt().setContents(stack);
            }
        }

        @Nullable
        private EntityItem prepareDrop(EntityPlayer player, ItemStack droppedItem, boolean dropAround) {
            if (droppedItem.func_190926_b()) {
                return null;
            }
            double d0 = player.field_70163_u - (double)0.3f + (double)player.func_70047_e();
            EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t, d0, player.field_70161_v, droppedItem);
            entityitem.func_174867_a(40);
            if (dropAround) {
                float f = this.rand.nextFloat() * 0.5f;
                float f1 = this.rand.nextFloat() * ((float)Math.PI * 2);
                entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
                entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
                entityitem.field_70181_x = 0.2f;
            } else {
                float f2 = 0.3f;
                entityitem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
                entityitem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
                entityitem.field_70181_x = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
                float f3 = this.rand.nextFloat() * ((float)Math.PI * 2);
                f2 = 0.02f * this.rand.nextFloat();
                entityitem.field_70159_w += Math.cos(f3) * (double)f2;
                entityitem.field_70181_x += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                entityitem.field_70179_y += Math.sin(f3) * (double)f2;
            }
            return entityitem;
        }

        static class Disabled {
            Disabled() {
            }

            @SubscribeEvent
            public void entityTick(TickEvent.PlayerTickEvent event) {
                ExtensionSlotBelt instance = ExtensionSlotBelt.get((EntityLivingBase)event.player);
                if (instance == null) {
                    return;
                }
                instance.dropContents();
            }
        }
    }

    private static class AttachHandlers {
        private AttachHandlers() {
        }

        @SubscribeEvent
        public void attachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                    final ExtensionSlotBelt extensionContainer;
                    {
                        this.extensionContainer = new ExtensionSlotBelt((EntityLivingBase)((EntityPlayer)event.getObject())){

                            @Override
                            public void onContentsChanged(IExtensionSlot slot) {
                                if (Config.customBeltSlotEnabled && !this.getOwner().field_70170_p.field_72995_K) {
                                    this.syncToSelfAndTracking();
                                }
                            }
                        };
                    }

                    public NBTTagCompound serializeNBT() {
                        return this.extensionContainer.serializeNBT();
                    }

                    public void deserializeNBT(NBTTagCompound nbt) {
                        this.extensionContainer.deserializeNBT(nbt);
                    }

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == CAPABILITY;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == CAPABILITY) {
                            return (T)this.extensionContainer;
                        }
                        return null;
                    }
                });
            }
        }
    }
}

