/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.block;

import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import jackyy.dimensionaledibles.DimensionalEdibles;
import jackyy.dimensionaledibles.block.BlockCakeBase;
import jackyy.dimensionaledibles.block.tile.TileIslandCake;
import jackyy.dimensionaledibles.islands.Island;
import jackyy.dimensionaledibles.islands.IslandManager;
import jackyy.dimensionaledibles.registry.ModConfig;
import jackyy.dimensionaledibles.util.TeleporterHandler;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BlockIslandCake
extends BlockCakeBase
implements ITileEntityProvider {
    public BlockIslandCake() {
        this.setRegistryName("dimensionaledibles:island_cake");
        this.func_149663_c("dimensionaledibles.island_cake");
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!(worldIn.func_175625_s(pos) instanceof TileIslandCake)) {
            return false;
        }
        if (this.convertToPersonalCake(worldIn, pos, state, playerIn, hand)) {
            return true;
        }
        if (this.addFuelToCake(worldIn, pos, state, playerIn, hand)) {
            return true;
        }
        if (!worldIn.field_72995_K) {
            Island island = this.getIsland(worldIn, playerIn, pos);
            if (playerIn.field_71075_bZ.field_75098_d || !this.config().consumesFuel()) {
                this.teleportPlayer(worldIn, playerIn, island.getTeleportLocation());
            } else if (this.consumeCake(worldIn, pos, playerIn)) {
                this.teleportPlayer(worldIn, playerIn, island.getTeleportLocation());
            }
        }
        return true;
    }

    private boolean convertToPersonalCake(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand) {
        if (!ModConfig.tweaks.islandCake.allowPersonalIslands) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileIslandCake)) {
            return false;
        }
        TileIslandCake tic = (TileIslandCake)te;
        ItemStack stack = playerIn.func_184586_b(hand);
        Item lockItem = this.getItemFromResourceString(ModConfig.tweaks.islandCake.personalLockingItem);
        if (lockItem == null) {
            DimensionalEdibles.logger.warn("Lock item not found, won't convert to personal cake");
            return false;
        }
        if (!stack.func_190926_b() && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)new ItemStack(lockItem)) && !tic.isPersonalCake()) {
            tic.setPersonalCake(true);
            tic.setOwner(playerIn.func_110124_au());
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private Island getIsland(World worldIn, EntityPlayer playerIn, BlockPos pos) {
        short teamUUID;
        UUID uuid = playerIn.func_110124_au();
        IslandManager im = IslandManager.forWorld(worldIn);
        Island island = null;
        TileIslandCake tic = (TileIslandCake)worldIn.func_175625_s(pos);
        MinecraftServer server = playerIn.func_184102_h();
        if (server != null && tic != null && !server.func_71264_H() && !tic.isPersonalCake() && DimensionalEdibles.isFTBLibsRunning && (teamUUID = FTBLibAPI.getTeamID((UUID)uuid)) != 0) {
            island = im.getIslandForTeam(teamUUID);
        }
        return island != null ? island : im.getIslandForPlayer(uuid);
    }

    protected void teleportPlayer(World world, EntityPlayer player, BlockPos spawnLoc) {
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        TeleporterHandler.updateDimPos((EntityPlayer)playerMP, world.field_73011_w.getDimension(), playerMP.func_180425_c());
        TeleporterHandler.teleport(playerMP, this.cakeDimension(), spawnLoc, playerMP.field_71133_b.func_184103_al());
    }

    @Override
    protected ModConfig.CakeConfig config() {
        return ModConfig.tweaks.islandCake;
    }

    @Override
    protected int cakeDimension() {
        return ModConfig.tweaks.islandCake.islandDimension;
    }

    @Override
    protected boolean registerItem() {
        return ModConfig.general.islandCake;
    }

    @Override
    @Nonnull
    protected ItemStack defaultFuel() {
        return new ItemStack(Blocks.field_150347_e);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileIslandCake();
    }

    public Item getItemFromResourceString(String resource) {
        if (resource == null || resource.isEmpty()) {
            return null;
        }
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(resource));
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileIslandCake tic = (TileIslandCake)world.func_175625_s(data.getPos());
        if (tic != null && tic.isPersonalCake()) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextFormatting.BLUE + "Personal");
        }
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileIslandCake tic = (TileIslandCake)accessor.getTileEntity();
        if (tic != null && tic.isPersonalCake()) {
            currentTip.add(TextFormatting.BLUE + "Personal");
        }
        return super.getWailaBody(itemStack, currentTip, accessor, config);
    }
}

