/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.islands;

import jackyy.dimensionaledibles.islands.Island;
import jackyy.dimensionaledibles.islands.Util;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class IslandManager {
    private static final HashMap<World, IslandManager> MANAGERS = new HashMap();
    private final IslandsWorldSavedData data;

    private IslandManager(World world) {
        this.data = IslandsWorldSavedData.get(world);
    }

    public static IslandManager forWorld(World world) {
        IslandManager manager = MANAGERS.get(world);
        if (manager == null) {
            manager = new IslandManager(world);
            MANAGERS.put(world, manager);
        }
        return manager;
    }

    public Island getIslandForPlayer(UUID id) {
        Island island = this.data.getByOwningPlayer(id);
        if (island == null) {
            island = this.data.createPlayerOwnedIsland(id);
        }
        return island;
    }

    public Island getIslandForTeam(short id) {
        Island island = this.data.getByOwningTeam(id);
        if (island == null) {
            island = this.data.createTeamOwnedIsland(id);
        }
        return island;
    }

    public static class IslandsWorldSavedData
    extends WorldSavedData {
        private static final int COMPOUND_TYPE = 10;
        private static final String DATA_NAME = "dimensionaledibles_IslandData";
        private final HashMap<UUID, Island> islands = new HashMap();
        private int index = 0;

        public IslandsWorldSavedData() {
            super(DATA_NAME);
        }

        public IslandsWorldSavedData(String s) {
            super(s);
        }

        public static IslandsWorldSavedData get(World world) {
            MapStorage storage = world.getPerWorldStorage();
            IslandsWorldSavedData instance = (IslandsWorldSavedData)storage.func_75742_a(IslandsWorldSavedData.class, DATA_NAME);
            if (instance == null) {
                instance = new IslandsWorldSavedData();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }

        @Nullable
        public Island getByOwningPlayer(UUID id) {
            return this.islands.values().stream().filter(i -> i.getOwningPlayer() != null).filter(i -> i.getOwningPlayer().equals(id)).findFirst().orElse(null);
        }

        @Nullable
        public Island getByOwningTeam(short id) {
            return this.islands.values().stream().filter(i -> i.getOwningTeam() != 0).filter(i -> i.getOwningTeam() == id).findFirst().orElse(null);
        }

        public Island createPlayerOwnedIsland(UUID id) {
            BlockPos teleport = Util.islandTeleportLocation(this.index);
            Island island = new Island(this.index++, teleport);
            island.setOwningPlayer(id);
            this.islands.put(island.getUuid(), island);
            this.func_76185_a();
            return island;
        }

        public Island createTeamOwnedIsland(short id) {
            BlockPos teleport = Util.islandTeleportLocation(this.index);
            Island island = new Island(this.index++, teleport);
            island.setOwningTeam(id);
            this.islands.put(island.getUuid(), island);
            this.func_76185_a();
            return island;
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.index = nbt.func_74762_e("index");
            this.islands.clear();
            NBTTagList list = nbt.func_150295_c("islands", 10);
            for (NBTBase i : list) {
                Island island = new Island();
                island.deserializeNBT((NBTTagCompound)i);
                this.islands.put(island.getUuid(), island);
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            compound.func_74768_a("index", this.index);
            NBTTagList islandList = new NBTTagList();
            for (Island island : this.islands.values()) {
                islandList.func_74742_a((NBTBase)island.serializeNBT());
            }
            compound.func_74782_a("islands", (NBTBase)islandList);
            return compound;
        }
    }
}

