/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration.mods;

import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.integration.NetworkProvider;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

@IntegrationHandler.IntegratedMod(value="refinedstorage")
public class RefinedStorage
extends NetworkProvider {
    @Override
    @Nullable
    protected IItemHandler getWrappedNetworkInternal(TileEntity te, EntityPlayer player, NetworkIO.Operation operation) {
        INetwork network;
        if (te instanceof INetworkNodeProxy && (network = ((INetworkNodeProxy)te).getNode().getNetwork()) != null && network.getSecurityManager().hasPermission(operation == NetworkIO.Operation.EXTRACT ? Permission.EXTRACT : Permission.INSERT, player)) {
            return new NetworkRefinedStorageIO(player, network, operation);
        }
        return null;
    }

    private static class NetworkRefinedStorageIO
    extends NetworkIO<NetworkIO.StackProviderVanilla> {
        private INetwork network;

        public NetworkRefinedStorageIO(EntityPlayer player, INetwork network, NetworkIO.Operation operation) {
            super(player, operation == NetworkIO.Operation.INSERT ? null : (Collection)network.getItemStorageCache().getList().getStacks().stream().map(stack -> new NetworkIO.StackProviderVanilla(stack.func_77946_l())).collect(Collectors.toList()));
            this.network = network;
        }

        @Override
        @Nullable
        public ItemStack insertItemInternal(ItemStack stack, boolean simulate) {
            return this.network.insertItem(stack, stack.func_190916_E(), this.getAction(simulate));
        }

        @Override
        @Nonnull
        protected NetworkIO.IStackProvider extractItemInternal(NetworkIO.StackProviderVanilla stackProvider, int amount, boolean simulate) {
            return new NetworkIO.StackProviderVanilla(this.network.extractItem(stackProvider.getStack(), amount, this.getAction(simulate)));
        }

        private Action getAction(boolean simulate) {
            return simulate ? Action.SIMULATE : Action.PERFORM;
        }
    }
}

