/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.config;

import com.ezrol.terry.lib.huffstruct.StructNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.core.util.UuidUtil;

public class UuidTypeNode
extends StructNode {
    private UUID value;

    public UuidTypeNode(StructNode base) {
        if (base == null || base.getBinaryString() == null) {
            this.value = UuidUtil.getTimeBasedUuid();
        } else {
            this.value = this.extractUUID(base.getBinaryString());
            if (this.value == null) {
                this.value = UuidUtil.getTimeBasedUuid();
            }
        }
    }

    private UUID extractUUID(byte[] data) {
        if (data.length != 16) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long low = buf.getLong();
        long high = buf.getLong();
        return new UUID(high, low);
    }

    @Override
    public List<StructNode> getArray() {
        return null;
    }

    @Override
    public byte[] getBinaryString() {
        ByteBuffer buf = ByteBuffer.wrap(new byte[16]);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(this.value.getLeastSignificantBits());
        buf.putLong(this.value.getMostSignificantBits());
        return buf.array();
    }

    public UUID getValue() {
        return this.value;
    }

    public void setValue(UUID value) {
        this.value = value;
    }

    public String toString() {
        return "UuidTypeNode{value=" + this.value + '}';
    }
}

