---
--- Generated by Luanalysis
--- Created by binghong.shen_187191.
--- DateTime: 2022/5/31 11:52
--[[======================================
||	filename:       DesertRotObelisk_Auto
||	owner:          binghong.shen
||	description:    赤王庙 自动旋转方尖碑
||	LogName:        DesertRotObelisk_Auto
||	Protection:     [Protection]
=======================================]]
--[[

--点阵id
defs.pointarray_ID = 110100049

--旋转CD
defs.RotateTime = 5

--方尖碑configID和初始旋转
defs.gadget_1
defs.gadget_2
defs.gadget_3
defs.rotation_1
defs.rotation_2
defs.rotation_3

--重力压板对应的控制的方尖碑(后来改为了开关控制)
defs.boardControlList={
[12001]={12002,12003},
}

--]]
---
local obeliskList={
	{config_id=defs.gadget_1,rotation=defs.rotation_1},
	{config_id=defs.gadget_2,rotation=defs.rotation_2},
	{config_id=defs.gadget_3,rotation=defs.rotation_3},
}




local extraTriggers={
	{ config_id = 8000001, name = "Group_Load", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_GroupLoad", trigger_count = 0 },
	{ config_id = 8000002, name = "Platform_Arrive", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "", action = "action_PlatformArrive", trigger_count = 0 },
	{ config_id = 8000003, name = "OnRotateAxis", event = EventType.EVENT_TIME_AXIS_PASS, source = "", condition = "", action = "action_TimeAxisPass", trigger_count = 0 },
	{ config_id = 8000004, name = "OnGadgetStateChange", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "", action = "action_GadgetStateChange", trigger_count = 0 },
}

function template(context, evt)
	return 0
end

function action_GroupLoad(context, evt)
	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_GroupLoad start ")

	if ScriptLib.GetGroupVariableValue(context,"success")~=0 then
		for _,v in pairs(obeliskList)do
			if v.config_id ~= 0 then
				ScriptLib.SetGadgetStateByConfigId(context, v.config_id, 203)
			end
		end
		return 0
	end

	--还原成初始状态
	for _,v in pairs(obeliskList)do
		if(v.rotation==0)then
			ScriptLib.SetGadgetStateByConfigId(context, v.config_id, 201)
		end
		if(v.rotation==120)then
			ScriptLib.SetPlatformPointArray(context, v.config_id, defs.pointarray_ID, { 1 }, { route_type = 0,turn_mode=true })
			ScriptLib.SetGadgetStateByConfigId(context, v.config_id, 202)
		end
		if(v.rotation==240)then
			ScriptLib.SetPlatformPointArray(context, v.config_id, defs.pointarray_ID, { 2 }, { route_type = 0,turn_mode=true })
			ScriptLib.SetGadgetStateByConfigId(context, v.config_id, 202)
		end
		ScriptLib.SetGroupVariableValue(context, v.config_id.."rotation", v.rotation)
		ScriptLib.SetGroupVariableValue(context, v.config_id.."isLock", 1)

	end


	--开启计时器
	ScriptLib.InitTimeAxis(context, "RotateTimeAxis", {defs.RotateTime}, true)

	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_GroupLoad end ")


	return 0
end

function action_GadgetStateChange(context,evt)
	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_GadgetStateChange start ")

	local config_id = evt.param2
	local state = evt.param1
	local isBoard = false

	for boardId,_ in pairs(defs.boardControlList)do
		if boardId == config_id then
			isBoard = true
			break
		end
	end
	if(isBoard)then
		local lockObeliskTable = {}
		for boardId,controlList in pairs(defs.boardControlList)do
			local boardState = ScriptLib.GetGadgetStateByConfigId(context, 0, boardId)
			if (boardState == 0 or boardState == 202) then
				for _,v in pairs(controlList)do
					table.insert(lockObeliskTable,v)
				end
			end
		end

		for _,v in pairs(obeliskList)do
			local isLock = false
			for _,lockObelisk in pairs(lockObeliskTable)do
				if(v.config_id==lockObelisk)then
					isLock = true
				end
			end
			if isLock then
				ScriptLib.SetGroupVariableValue(context, v.config_id.."isLock", 1)
			else
				ScriptLib.SetGroupVariableValue(context, v.config_id.."isLock", 0)
			end
		end
	end
	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_GadgetStateChange end ")

	return 0
end

function action_TimeAxisPass(context,evt)
	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_TimeAxisPass start ")

	if evt.source_name == "RotateTimeAxis" then
		for _,v in pairs(obeliskList)do
			local isLock = ScriptLib.GetGroupVariableValue(context, v.config_id.."isLock")
			if(isLock==0)then
				RotateGadget(context,v.config_id)
			end
		end
	end
	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_TimeAxisPass end ")

	return 0
end

function RotateGadget(context,config_id)
	ScriptLib.SetGadgetStateByConfigId(context, config_id, 202)
	ScriptLib.SetPlatformPointArray(context, config_id, defs.pointarray_ID, { 1 }, { route_type = 0,turn_mode=true })
	local curRot = ScriptLib.GetGroupVariableValue(context, config_id.."rotation")
	ScriptLib.SetGroupVariableValue(context, config_id.."rotation", (curRot+120)%360)
end

function action_PlatformArrive(context, evt)
	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_PlatformArrive start ")

	local config_id = evt.param1
	local curRot = ScriptLib.GetGroupVariableValue(context, config_id.."rotation")
	if curRot == nil then
		return 0
	end
	if(curRot==0)then
		ScriptLib.SetGadgetStateByConfigId(context, config_id, 201)
	else
		ScriptLib.SetGadgetStateByConfigId(context, config_id, 0)
	end

	if(CheckIsSuccess(context))then
		ScriptLib.SetGroupVariableValue(context, "success", 1)
		ScriptLib.EndTimeAxis(context, "RotateTimeAxis")
		for _,v in pairs(obeliskList)do
			if v.config_id ~= 0 then
				ScriptLib.SetGadgetStateByConfigId(context, v.config_id, 203)
			end
		end
		ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto :  success ")

	end
	ScriptLib.PrintContextLog(context, "@@ DesertRotObelisk_Auto : action_PlatformArrive end ")

	return 0
end


function CheckIsSuccess(context)
	for _,v in pairs(obeliskList)do
		if(ScriptLib.GetGadgetStateByConfigId(context, 0, v.config_id)~=201)then
			return false
		end
	end
	return true
end

function LF_Initialize_Group(triggers, suites)
	for i=1,#extraTriggers do
		table.insert(triggers, extraTriggers[i])
		table.insert(suites[init_config.suite].triggers,extraTriggers[i].name)
	end
	table.insert(variables,{ config_id=40000001,name = "success", value = 0, no_refresh = true})
	for i=1,#obeliskList do
		if obeliskList[i].config_id ~= 0 then
			table.insert(variables,{ config_id=60000000+obeliskList[i].config_id,name = obeliskList[i].config_id.."rotation", value = obeliskList[i].rotation})
			table.insert(variables,{ config_id=70000000+obeliskList[i].config_id,name = obeliskList[i].config_id.."isLock", value = 0})
		end
	end
end



LF_Initialize_Group(triggers, suites)
