-- 基础信息
local base_info = {
	group_id = 133001569
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 569004, monster_id = 21020501, pos = { x = 1648.106, y = 232.550, z = -1192.689 }, rot = { x = 0.000, y = 21.551, z = 0.000 }, level = 26, drop_id = 1000100, disableWander = true, affix = { 1102, 1103, 1104, 1105 }, pose_id = 401, area_id = 2 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 569001, gadget_id = 70710340, pos = { x = 1659.582, y = 233.309, z = -1185.926 }, rot = { x = 0.000, y = 201.048, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569002, gadget_id = 70710340, pos = { x = 1650.830, y = 232.550, z = -1182.063 }, rot = { x = 0.000, y = 206.734, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569003, gadget_id = 70710340, pos = { x = 1643.352, y = 234.168, z = -1180.495 }, rot = { x = 0.000, y = 206.734, z = 9.584 }, level = 1, area_id = 2 },
	{ config_id = 569005, gadget_id = 70710293, pos = { x = 1660.269, y = 238.113, z = -1200.876 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569006, gadget_id = 70710293, pos = { x = 1654.166, y = 232.819, z = -1197.671 }, rot = { x = 359.414, y = 357.181, z = 6.278 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569007, gadget_id = 70710293, pos = { x = 1659.207, y = 234.146, z = -1193.830 }, rot = { x = 10.298, y = 2.437, z = 26.567 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569008, gadget_id = 70710293, pos = { x = 1632.814, y = 234.871, z = -1197.181 }, rot = { x = 0.000, y = 359.798, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569009, gadget_id = 70710293, pos = { x = 1634.272, y = 234.548, z = -1211.030 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569010, gadget_id = 70710293, pos = { x = 1633.808, y = 233.792, z = -1204.159 }, rot = { x = 0.000, y = 218.738, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569011, gadget_id = 70300118, pos = { x = 1633.999, y = 234.281, z = -1204.002 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569018, gadget_id = 70710293, pos = { x = 1633.808, y = 233.792, z = -1204.159 }, rot = { x = 0.000, y = 218.738, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569019, gadget_id = 70710293, pos = { x = 1634.272, y = 234.548, z = -1211.030 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569020, gadget_id = 70710293, pos = { x = 1632.814, y = 234.871, z = -1197.181 }, rot = { x = 0.000, y = 359.798, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569021, gadget_id = 70710293, pos = { x = 1659.207, y = 234.146, z = -1193.830 }, rot = { x = 10.298, y = 2.437, z = 26.567 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569022, gadget_id = 70710293, pos = { x = 1654.166, y = 232.819, z = -1197.671 }, rot = { x = 359.414, y = 357.181, z = 6.278 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569023, gadget_id = 70710293, pos = { x = 1660.269, y = 238.113, z = -1200.876 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1050121, drop_count = 1, area_id = 2 },
	{ config_id = 569037, gadget_id = 70710336, pos = { x = 1659.582, y = 233.309, z = -1185.926 }, rot = { x = 0.000, y = 201.048, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569038, gadget_id = 70710336, pos = { x = 1643.352, y = 234.168, z = -1180.495 }, rot = { x = 0.000, y = 206.734, z = 9.584 }, level = 1, area_id = 2 },
	{ config_id = 569039, gadget_id = 70710336, pos = { x = 1650.830, y = 232.550, z = -1182.063 }, rot = { x = 0.000, y = 206.734, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569041, gadget_id = 70300118, pos = { x = 1634.321, y = 235.033, z = -1210.961 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569042, gadget_id = 70300118, pos = { x = 1632.857, y = 235.463, z = -1197.139 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569043, gadget_id = 70300118, pos = { x = 1658.929, y = 234.834, z = -1193.831 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569044, gadget_id = 70300118, pos = { x = 1654.106, y = 233.359, z = -1197.631 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 2 },
	{ config_id = 569045, gadget_id = 70300118, pos = { x = 1660.256, y = 238.587, z = -1200.796 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 2 }
}

-- 区域
regions = {
	{ config_id = 569040, shape = RegionShape.SPHERE, radius = 20, pos = { x = 1653.789, y = 235.611, z = -1180.519 }, area_id = 2 }
}

-- 触发器
triggers = {
	{ config_id = 1569012, name = "ANY_GADGET_DIE_569012", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569012", action = "action_EVENT_ANY_GADGET_DIE_569012" },
	{ config_id = 1569013, name = "ANY_GADGET_DIE_569013", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569013", action = "action_EVENT_ANY_GADGET_DIE_569013" },
	{ config_id = 1569014, name = "ANY_GADGET_DIE_569014", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569014", action = "action_EVENT_ANY_GADGET_DIE_569014" },
	{ config_id = 1569015, name = "ANY_MONSTER_DIE_569015", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_569015", action = "action_EVENT_ANY_MONSTER_DIE_569015" },
	{ config_id = 1569016, name = "ANY_GADGET_DIE_569016", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569016", action = "action_EVENT_ANY_GADGET_DIE_569016" },
	{ config_id = 1569017, name = "QUEST_FINISH_569017", event = EventType.EVENT_QUEST_FINISH, source = "1906607", condition = "", action = "action_EVENT_QUEST_FINISH_569017" },
	{ config_id = 1569024, name = "GATHER_569024", event = EventType.EVENT_GATHER, source = "569023", condition = "", action = "action_EVENT_GATHER_569024" },
	{ config_id = 1569025, name = "GATHER_569025", event = EventType.EVENT_GATHER, source = "569022", condition = "", action = "action_EVENT_GATHER_569025" },
	{ config_id = 1569026, name = "GATHER_569026", event = EventType.EVENT_GATHER, source = "569021", condition = "", action = "action_EVENT_GATHER_569026" },
	{ config_id = 1569027, name = "GATHER_569027", event = EventType.EVENT_GATHER, source = "569020", condition = "", action = "action_EVENT_GATHER_569027" },
	{ config_id = 1569028, name = "GATHER_569028", event = EventType.EVENT_GATHER, source = "569019", condition = "", action = "action_EVENT_GATHER_569028" },
	{ config_id = 1569029, name = "GATHER_569029", event = EventType.EVENT_GATHER, source = "569018", condition = "", action = "action_EVENT_GATHER_569029" },
	{ config_id = 1569030, name = "VARIABLE_CHANGE_569030", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_569030", action = "" },
	{ config_id = 1569031, name = "ANY_GADGET_DIE_569031", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569031", action = "action_EVENT_ANY_GADGET_DIE_569031" },
	{ config_id = 1569032, name = "ANY_GADGET_DIE_569032", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569032", action = "action_EVENT_ANY_GADGET_DIE_569032" },
	{ config_id = 1569033, name = "ANY_GADGET_DIE_569033", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569033", action = "action_EVENT_ANY_GADGET_DIE_569033" },
	{ config_id = 1569034, name = "ANY_GADGET_DIE_569034", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569034", action = "action_EVENT_ANY_GADGET_DIE_569034" },
	{ config_id = 1569035, name = "ANY_GADGET_DIE_569035", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569035", action = "action_EVENT_ANY_GADGET_DIE_569035" },
	{ config_id = 1569036, name = "ANY_GADGET_DIE_569036", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_569036", action = "action_EVENT_ANY_GADGET_DIE_569036" },
	{ config_id = 1569040, name = "ENTER_REGION_569040", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_569040", action = "action_EVENT_ENTER_REGION_569040", trigger_count = 0 }
}

-- 变量
variables = {
	{ config_id = 1, name = "mine3", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 4,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 569001, 569002, 569003 },
		regions = { },
		triggers = { "ANY_GADGET_DIE_569012", "ANY_GADGET_DIE_569013", "ANY_GADGET_DIE_569014", "ANY_GADGET_DIE_569016", "QUEST_FINISH_569017" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { 569004 },
		gadgets = { 569005, 569006, 569007, 569008, 569009, 569010 },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_569015" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 水晶,
		monsters = { },
		gadgets = { 569011, 569018, 569019, 569020, 569021, 569022, 569023, 569041, 569042, 569043, 569044, 569045 },
		regions = { },
		triggers = { "VARIABLE_CHANGE_569030", "ANY_GADGET_DIE_569031", "ANY_GADGET_DIE_569032", "ANY_GADGET_DIE_569033", "ANY_GADGET_DIE_569034", "ANY_GADGET_DIE_569035", "ANY_GADGET_DIE_569036" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 569037, 569038, 569039 },
		regions = { 569040 },
		triggers = { "ENTER_REGION_569040" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569012(context, evt)
	if 569001 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569012(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 569002 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 569003 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569013(context, evt)
	if 569002 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569013(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 569001 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 569003 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569014(context, evt)
	if 569003 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569014(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 569001 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 569002 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_569015(context, evt)
	--判断死亡怪物的configid是否为 569004
	if evt.param1 ~= 569004 then
	    return false
	 end
	  
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_569015(context, evt)
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=1646,y=232,z=-1199}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 31021149, pos, 100) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015693") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569016(context, evt)
	-- 判断指定group组剩余gadget数量是否是0 
	if ScriptLib.CheckRemainGadgetCountByGroupId(context, {group_id = 133001569}) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569016(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015692") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=1658,y=235,z=-1181}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 31021128, pos, 90) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_FINISH_569017(context, evt)
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=1654,y=235,z=-1179}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 31021128, pos, 50) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_GATHER_569024(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_GATHER_569025(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_GATHER_569026(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_GATHER_569027(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_GATHER_569028(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_GATHER_569029(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_569030(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"mine3"为6
	if ScriptLib.GetGroupVariableValue(context, "mine3") ~= 6 then
			return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569031(context, evt)
	if 569023 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569031(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015694") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133001569, EntityType.GADGET, 569045 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569032(context, evt)
	if 569022 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569032(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015694") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133001569, EntityType.GADGET, 569044 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569033(context, evt)
	if 569021 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569033(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015694") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133001569, EntityType.GADGET, 569043 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569034(context, evt)
	if 569020 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569034(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015694") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133001569, EntityType.GADGET, 569042 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569035(context, evt)
	if 569019 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569035(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015694") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133001569, EntityType.GADGET, 569041 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_569036(context, evt)
	if 569018 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_569036(context, evt)
	-- 针对当前group内变量名为 "mine3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "mine3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015694") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133001569, EntityType.GADGET, 569011 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_569040(context, evt)
	if evt.param1 ~= 569040 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_569040(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330015691") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end